/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.capabilities;

import com.supermartijn642.tesseract.EnumChannelType;
import com.supermartijn642.tesseract.TesseractTile;
import com.supermartijn642.tesseract.manager.Channel;
import com.supermartijn642.tesseract.manager.TesseractReference;
import javax.annotation.Nonnull;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class CombinedFluidHandler
implements IFluidHandler {
    private final Channel channel;
    private final TesseractTile requester;

    public CombinedFluidHandler(Channel channel, TesseractTile requester) {
        this.channel = channel;
        this.requester = requester;
    }

    public int getTanks() {
        int tanks = 0;
        for (TesseractReference location : this.channel.tesseracts) {
            TesseractTile tile;
            if (!location.isValid() || (tile = location.getTesseract()) == this.requester) continue;
            for (IFluidHandler handler : tile.getSurroundingCapabilities(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)) {
                tanks += Math.max(handler.getTanks(), 0);
            }
        }
        return tanks;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        int tanks = 0;
        for (TesseractReference location : this.channel.tesseracts) {
            TesseractTile tile;
            if (!location.isValid() || (tile = location.getTesseract()) == this.requester) continue;
            for (IFluidHandler handler : tile.getSurroundingCapabilities(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)) {
                if (tank - tanks < handler.getTanks()) {
                    return handler.getFluidInTank(tank - tanks);
                }
                tanks += Math.max(handler.getTanks(), 0);
            }
        }
        return FluidStack.EMPTY;
    }

    public int getTankCapacity(int tank) {
        int tanks = 0;
        for (TesseractReference location : this.channel.tesseracts) {
            TesseractTile tile;
            if (!location.isValid() || (tile = location.getTesseract()) == this.requester) continue;
            for (IFluidHandler handler : tile.getSurroundingCapabilities(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)) {
                if (tank - tanks < handler.getTanks()) {
                    return handler.getTankCapacity(tank - tanks);
                }
                tanks += Math.max(handler.getTanks(), 0);
            }
        }
        return 0;
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        int tanks = 0;
        for (TesseractReference location : this.channel.tesseracts) {
            TesseractTile tile;
            if (!location.isValid() || (tile = location.getTesseract()) == this.requester) continue;
            for (IFluidHandler handler : tile.getSurroundingCapabilities(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)) {
                if (tank - tanks < handler.getTanks()) {
                    return handler.isFluidValid(tank - tanks, stack);
                }
                tanks += Math.max(handler.getTanks(), 0);
            }
        }
        return false;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.requester.canSend(EnumChannelType.FLUID) || resource.isEmpty()) {
            return 0;
        }
        FluidStack fluid = resource.copy();
        int amount = 0;
        block0: for (TesseractReference location : this.channel.receivingTesseracts) {
            TesseractTile tile;
            if (!location.isValid() || (tile = location.getTesseract()) == this.requester) continue;
            for (IFluidHandler handler : tile.getSurroundingCapabilities(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)) {
                if ((amount += handler.fill(fluid, action)) >= resource.getAmount()) break block0;
                fluid.setAmount(resource.getAmount() - amount);
            }
        }
        return amount;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.requester.canReceive(EnumChannelType.FLUID) || resource == null || resource.isEmpty()) {
            return FluidStack.EMPTY;
        }
        FluidStack fluid = resource.copy();
        block0: for (TesseractReference location : this.channel.sendingTesseracts) {
            TesseractTile tile;
            if (!location.isValid() || (tile = location.getTesseract()) == this.requester) continue;
            for (IFluidHandler handler : tile.getSurroundingCapabilities(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)) {
                FluidStack stack = handler.drain(fluid.copy(), IFluidHandler.FluidAction.SIMULATE);
                if (!stack.isEmpty() && resource.isFluidEqual(stack)) {
                    if (action.execute()) {
                        handler.drain(fluid.copy(), IFluidHandler.FluidAction.EXECUTE);
                    }
                    fluid.setAmount(fluid.getAmount() - stack.getAmount());
                }
                if (!fluid.isEmpty()) continue;
                break block0;
            }
        }
        if (fluid.getAmount() == resource.getAmount()) {
            return FluidStack.EMPTY;
        }
        fluid.setAmount(resource.getAmount() - fluid.getAmount());
        return fluid;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (!this.requester.canReceive(EnumChannelType.FLUID) || maxDrain <= 0) {
            return FluidStack.EMPTY;
        }
        FluidStack fluid = null;
        block0: for (TesseractReference location : this.channel.sendingTesseracts) {
            TesseractTile tile;
            if (!location.isValid() || (tile = location.getTesseract()) == this.requester) continue;
            for (IFluidHandler handler : tile.getSurroundingCapabilities(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)) {
                if (fluid == null) {
                    fluid = handler.drain(maxDrain, action);
                    if (fluid.isEmpty()) {
                        fluid = null;
                        continue;
                    }
                    fluid.setAmount(maxDrain - fluid.getAmount());
                    continue;
                }
                FluidStack stack = handler.drain(fluid.copy(), IFluidHandler.FluidAction.SIMULATE);
                if (!stack.isEmpty() && fluid.isFluidEqual(stack)) {
                    if (action.execute()) {
                        handler.drain(fluid.copy(), IFluidHandler.FluidAction.EXECUTE);
                    }
                    fluid.setAmount(fluid.getAmount() - stack.getAmount());
                }
                if (!fluid.isEmpty()) continue;
                break block0;
            }
        }
        if (fluid == null) {
            return FluidStack.EMPTY;
        }
        fluid.setAmount(maxDrain - fluid.getAmount());
        return fluid;
    }
}

