/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagradditions.lib;

import com.blakebr0.mysticalagradditions.config.ModConfigs;
import com.blakebr0.mysticalagradditions.init.ModBlocks;
import com.blakebr0.mysticalagradditions.init.ModItems;
import com.blakebr0.mysticalagriculture.api.IMysticalAgriculturePlugin;
import com.blakebr0.mysticalagriculture.api.MysticalAgriculturePlugin;
import com.blakebr0.mysticalagriculture.api.crop.Crop;
import com.blakebr0.mysticalagriculture.api.crop.CropTier;
import com.blakebr0.mysticalagriculture.api.crop.CropType;
import com.blakebr0.mysticalagriculture.api.crop.ICrop;
import com.blakebr0.mysticalagriculture.api.lib.LazyIngredient;
import com.blakebr0.mysticalagriculture.api.lib.PluginConfig;
import com.blakebr0.mysticalagriculture.api.registry.ICropRegistry;
import java.util.Arrays;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.ModList;

@MysticalAgriculturePlugin
public final class ModCorePlugin
implements IMysticalAgriculturePlugin {
    private static final boolean DEBUG = false;
    public static final CropTier CROP_TIER_6 = new CropTier(new ResourceLocation("mysticalagradditions", "6"), 6, 4194398, TextFormatting.DARK_PURPLE);
    public static final Crop NETHER_STAR = new Crop(new ResourceLocation("mysticalagradditions", "nether_star"), CROP_TIER_6, CropType.RESOURCE, LazyIngredient.item((String)"minecraft:nether_star"));
    public static final Crop DRAGON_EGG = new Crop(new ResourceLocation("mysticalagradditions", "dragon_egg"), CROP_TIER_6, CropType.RESOURCE, LazyIngredient.item((String)"mysticalagradditions:dragon_scale"));
    public static final Crop AWAKENED_DRACONIUM = new Crop(new ResourceLocation("mysticalagradditions", "awakened_draconium"), CROP_TIER_6, CropType.RESOURCE, LazyIngredient.tag((String)"forge:ingots/draconium_awakened"));
    public static final Crop NITRO_CRYSTAL = new Crop(new ResourceLocation("mysticalagradditions", "nitro_crystal"), CROP_TIER_6, CropType.RESOURCE, LazyIngredient.item((String)"powah:crystal_nitro"));

    public void configure(PluginConfig config) {
        config.setModId("mysticalagradditions");
        config.disableDynamicSeedCraftingRecipes();
        config.disableDynamicSeedInfusionRecipes();
        config.disableDynamicSeedReprocessingRecipes();
    }

    public void onRegisterCrops(ICropRegistry registry) {
        registry.register((ICrop)NETHER_STAR);
        registry.register((ICrop)DRAGON_EGG);
        registry.register(ModCorePlugin.withRequiredMods((ICrop)AWAKENED_DRACONIUM, "draconicevolution"));
        registry.register(ModCorePlugin.withRequiredMods((ICrop)NITRO_CRYSTAL, "powah"));
    }

    public void onPostRegisterCrops(ICropRegistry registry) {
        CROP_TIER_6.setFarmland(() -> (FarmlandBlock)ModBlocks.INSANIUM_FARMLAND.get()).setEssence(ModItems.INSANIUM_ESSENCE).setFertilizable(((Boolean)ModConfigs.FERTILIZABLE_CROPS.get()).booleanValue()).setSecondarySeedDrop(false);
        NETHER_STAR.setCrux(ModBlocks.NETHER_STAR_CRUX);
        DRAGON_EGG.setCrux(ModBlocks.DRAGON_EGG_CRUX);
        AWAKENED_DRACONIUM.setCrux(ModBlocks.AWAKENED_DRACONIUM_CRUX);
        NITRO_CRYSTAL.setCrux(ModBlocks.NITRO_CRYSTAL_CRUX);
    }

    private static ICrop withRequiredMods(ICrop crop, String ... mods) {
        boolean enabled = Arrays.stream(mods).anyMatch(arg_0 -> ((ModList)ModList.get()).isLoaded(arg_0));
        return crop.setEnabled(enabled);
    }
}

