/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.data.stack;

import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.data.stack.IStackAdapter;
import it.zerono.mods.zerocore.lib.data.stack.IStackHolder;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.ObjIntConsumer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public abstract class AbstractStackHolder<Holder extends AbstractStackHolder<Holder, Stack>, Stack>
implements IStackHolder<Holder, Stack> {
    private final BiPredicate<Integer, Stack> _stackValidator;
    private ObjIntConsumer<IStackHolder.ChangeType> _onChangeListener;
    private Runnable _onLoadListener;
    private Int2IntFunction _maxCapacityProvider;

    protected AbstractStackHolder() {
        this(AbstractStackHolder::defaultValidator);
    }

    protected AbstractStackHolder(BiPredicate<Integer, Stack> stackValidator) {
        this._stackValidator = Objects.requireNonNull(stackValidator);
        this._onChangeListener = (change, index) -> {};
        this._onLoadListener = CodeHelper.VOID_RUNNABLE;
        this._maxCapacityProvider = $ -> 0;
    }

    protected void onLoad() {
        this._onLoadListener.run();
    }

    protected void onChange(IStackHolder.ChangeType change, int index) {
        this._onChangeListener.accept(change, index);
    }

    protected <StackType, ContentType> void syncFrom(CompoundNBT data, IStackAdapter<StackType, ContentType> adapter, Int2ObjectFunction<List<StackType>> itemsListSupplier) {
        List stacks = (List)itemsListSupplier.get(data.func_74762_e("Size"));
        ListNBT tagList = data.func_150295_c("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT itemTags = tagList.func_150305_b(i);
            int slot = itemTags.func_74762_e("Slot");
            if (slot < 0 || slot >= stacks.size()) continue;
            stacks.set(slot, adapter.readFrom(itemTags));
        }
        this.onLoad();
    }

    protected <StackType, ContentType> CompoundNBT syncTo(CompoundNBT data, List<StackType> items, IStackAdapter<StackType, ContentType> adapter) {
        ListNBT nbtTagList = new ListNBT();
        for (int i = 0; i < items.size(); ++i) {
            if (adapter.isEmpty(items.get(i))) continue;
            CompoundNBT itemTag = new CompoundNBT();
            itemTag.func_74768_a("Slot", i);
            adapter.writeTo(items.get(i), itemTag);
            nbtTagList.add((Object)itemTag);
        }
        data.func_218657_a("Items", (INBT)nbtTagList);
        data.func_74768_a("Size", items.size());
        return data;
    }

    @Override
    public boolean isStackValid(int index, Stack stack) {
        return this._stackValidator.test(index, stack);
    }

    @Override
    public Holder setOnContentsChangedListener(ObjIntConsumer<IStackHolder.ChangeType> listener) {
        this._onChangeListener = Objects.requireNonNull(listener);
        return (Holder)this;
    }

    @Override
    public Holder setOnLoadListener(Runnable listener) {
        this._onLoadListener = Objects.requireNonNull(listener);
        return (Holder)this;
    }

    @Override
    public void setMaxCapacity(Int2IntFunction maxCapacity) {
        this._maxCapacityProvider = Objects.requireNonNull(maxCapacity);
    }

    @Override
    public int getMaxCapacity(int index) {
        return this._maxCapacityProvider.applyAsInt(index);
    }

    protected static <Stack> boolean defaultValidator(Integer index, Stack stack) {
        return true;
    }
}

