/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.block;

import it.zerono.mods.zerocore.lib.block.AbstractModBlockEntity;
import it.zerono.mods.zerocore.lib.block.ITileCommandHandler;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.fml.LogicalSide;

@FunctionalInterface
public interface ITileCommandDispatcher {
    public void dispatch(LogicalSide var1, String var2, CompoundNBT var3);

    public static interface Builder<T extends AbstractModBlockEntity> {
        public Builder<T> addHandler(String var1, ITileCommandHandler<T> var2);

        default public Builder<T> addHandler(String name, BiConsumer<T, LogicalSide> handler) {
            return this.addHandler(name, (T tile, LogicalSide source, CompoundNBT parameters) -> handler.accept(tile, source));
        }

        default public Builder<T> addServerHandler(String name, BiConsumer<T, CompoundNBT> handler) {
            return this.addHandler(name, (T tile, LogicalSide source, CompoundNBT parameters) -> {
                if (source.isClient()) {
                    handler.accept(tile, parameters);
                }
            });
        }

        default public Builder<T> addServerHandler(String name, Consumer<T> handler) {
            return this.addHandler(name, (T tile, LogicalSide source, CompoundNBT parameters) -> {
                if (source.isClient()) {
                    handler.accept(tile);
                }
            });
        }

        default public Builder<T> addClientHandler(String name, BiConsumer<T, CompoundNBT> handler) {
            return this.addHandler(name, (T tile, LogicalSide source, CompoundNBT parameters) -> {
                if (source.isServer()) {
                    handler.accept(tile, parameters);
                }
            });
        }

        default public Builder<T> addClientHandler(String name, Consumer<T> handler) {
            return this.addHandler(name, (T tile, LogicalSide source, CompoundNBT parameters) -> {
                if (source.isServer()) {
                    handler.accept(tile);
                }
            });
        }

        public ITileCommandDispatcher build(T var1);
    }
}

