/*
 * Decompiled with CFR 0.152.
 */
package com.sunekaer.mods.toolkit.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;

public class CommandOreDist {
    private static final DecimalFormat FORMATTER = new DecimalFormat("########0.00");

    public static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"oredist").requires(cs -> cs.func_197034_c(0))).executes(ctx -> {
            ((CommandSource)ctx.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("commands.toolkit.oredist.missing"));
            return 1;
        })).then(Commands.func_197056_a((String)"AreaSize", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> CommandOreDist.getOreDist((CommandSource)ctx.getSource(), (PlayerEntity)((CommandSource)ctx.getSource()).func_197035_h(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"AreaSize"))));
    }

    private static int getOreDist(CommandSource source, PlayerEntity player, int size) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        double searchSize = 16 * size / 2;
        double startX = player.func_213303_ch().func_82615_a() - searchSize;
        double startZ = player.func_213303_ch().func_82616_c() - searchSize;
        double endX = player.func_213303_ch().func_82615_a() + searchSize;
        double endZ = player.func_213303_ch().func_82616_c() + searchSize;
        World world = player.func_130014_f_();
        for (int y = 0; y < 255; ++y) {
            for (double x2 = startX; x2 < endX; x2 += 1.0) {
                for (double z = startZ; z < endZ; z += 1.0) {
                    BlockPos tBlockPos = new BlockPos(x2, (double)y, z);
                    BlockState tBlockState = world.func_180495_p(tBlockPos);
                    Block tBlock = tBlockState.func_177230_c();
                    if (tBlock.equals(Blocks.field_150350_a) || tBlock.equals(Blocks.field_150357_h) || tBlock.equals(Blocks.field_150348_b) || tBlock.equals(Blocks.field_150346_d) || tBlock.equals(Blocks.field_150355_j) || !Tags.Blocks.ORES.func_230236_b_().contains(tBlock.getBlock())) continue;
                    String key = tBlock.getBlock().getRegistryName().toString();
                    Object value = map.get(tBlock.getBlock().getRegistryName().toString());
                    if (value != null) {
                        map.put(key, (Integer)map.get(key) + 1);
                        continue;
                    }
                    map.put(key, 1);
                }
            }
        }
        double sum = map.values().stream().reduce(0, Integer::sum).intValue();
        if (sum == 0.0) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("\u00a7c No ores found"), true);
            return 1;
        }
        map.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).forEachOrdered(x -> source.func_197030_a((ITextComponent)new TranslationTextComponent("\u00a7c" + (String)x.getKey() + " \u00a7rCount: " + x.getValue() + " (" + FORMATTER.format((double)((Integer)x.getValue() * 100) / sum) + "%%)"), true));
        return 1;
    }
}

