/*
 * Decompiled with CFR 0.152.
 */
package owmii.lib.client.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Matrix4f;
import owmii.lib.util.math.V3d;

public class Cube {
    private final MatrixStack matrix;
    private final IVertexBuilder builder;
    private Set<Side> sides = new HashSet<Side>();
    private V3d pos = V3d.ZERO;
    private double size = 1.0;
    private float r = 1.0f;
    private float b = 1.0f;
    private float g = 1.0f;
    private float a = 1.0f;
    private int light;

    Cube(MatrixStack matrix, IVertexBuilder builder) {
        this.matrix = matrix;
        this.builder = builder;
    }

    public static Cube create(MatrixStack stack, IVertexBuilder builder) {
        return new Cube(stack, builder);
    }

    public Cube size(double size) {
        this.size = size;
        return this;
    }

    public Cube pos(double x, double y, double z) {
        return this.pos(new V3d(x, y, z));
    }

    public Cube pos(V3d pos) {
        this.pos = pos;
        return this;
    }

    public Cube bright() {
        this.light(0xF000F0);
        return this;
    }

    public Cube light(int light) {
        this.light = light;
        return this;
    }

    public Cube side(BlockState state) {
        this.sides.add(Side.from((Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H)));
        return this;
    }

    public Cube side(Direction side) {
        this.sides.add(Side.from(side));
        return this;
    }

    public Cube side(Side side) {
        this.sides.add(side);
        return this;
    }

    public Cube color(int color) {
        return this.color((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
    }

    public Cube color(float r, float g, float b) {
        return this.color(r, g, b, 1.0f);
    }

    public Cube color(float r, float g, float b, float a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        return this;
    }

    public Cube alpha(float alpha) {
        this.a = alpha;
        return this;
    }

    public void draw(TextureAtlasSprite sprite) {
        float d = (float)(this.size / 2.0);
        Matrix4f matrix4f = this.matrix.func_227866_c_().func_227870_a_();
        boolean isAll = this.sides.isEmpty();
        if (isAll || this.sides.contains((Object)Side.UP)) {
            this.builder.func_227888_a_(matrix4f, (float)this.pos.func_82615_a() - d, (float)this.pos.func_82617_b() + d, (float)this.pos.func_82616_c() + d).func_227885_a_(this.r, this.g, this.b, this.a).func_225583_a_(sprite.func_94209_e(), sprite.func_94206_g()).func_227886_a_(this.light).func_181675_d();
            this.builder.func_227888_a_(matrix4f, (float)this.pos.func_82615_a() + d, (float)this.pos.func_82617_b() + d, (float)this.pos.func_82616_c() + d).func_227885_a_(this.r, this.g, this.b, this.a).func_225583_a_(sprite.func_94212_f(), sprite.func_94206_g()).func_227886_a_(this.light).func_181675_d();
            this.builder.func_227888_a_(matrix4f, (float)this.pos.func_82615_a() + d, (float)this.pos.func_82617_b() + d, (float)this.pos.func_82616_c() - d).func_227885_a_(this.r, this.g, this.b, this.a).func_225583_a_(sprite.func_94212_f(), sprite.func_94210_h()).func_227886_a_(this.light).func_181675_d();
            this.builder.func_227888_a_(matrix4f, (float)this.pos.func_82615_a() - d, (float)this.pos.func_82617_b() + d, (float)this.pos.func_82616_c() - d).func_227885_a_(this.r, this.g, this.b, this.a).func_225583_a_(sprite.func_94209_e(), sprite.func_94210_h()).func_227886_a_(this.light).func_181675_d();
        }
        if (isAll || this.sides.contains((Object)Side.DOWN)) {
            this.builder.func_227888_a_(matrix4f, (float)this.pos.func_82615_a() - d, (float)this.pos.func_82617_b() - d, (float)this.pos.func_82616_c() - d).func_227885_a_(this.r, this.g, this.b, this.a).func_225583_a_(sprite.func_94209_e(), sprite.func_94206_g()).func_227886_a_(this.light).func_181675_d();
            this.builder.func_227888_a_(matrix4f, (float)this.pos.func_82615_a() + d, (float)this.pos.func_82617_b() - d, (float)this.pos.func_82616_c() - d).func_227885_a_(this.r, this.g, this.b, this.a).func_225583_a_(sprite.func_94212_f(), sprite.func_94206_g()).func_227886_a_(this.light).func_181675_d();
            this.builder.func_227888_a_(matrix4f, (float)this.pos.func_82615_a() + d, (float)this.pos.func_82617_b() - d, (float)this.pos.func_82616_c() + d).func_227885_a_(this.r, this.g, this.b, this.a).func_225583_a_(sprite.func_94212_f(), sprite.func_94210_h()).func_227886_a_(this.light).func_181675_d();
            this.builder.func_227888_a_(matrix4f, (float)this.pos.func_82615_a() - d, (float)this.pos.func_82617_b() - d, (float)this.pos.func_82616_c() + d).func_227885_a_(this.r, this.g, this.b, this.a).func_225583_a_(sprite.func_94209_e(), sprite.func_94210_h()).func_227886_a_(this.light).func_181675_d();
        }
        if (isAll || this.sides.contains((Object)Side.NORTH)) {
            this.builder.func_227888_a_(matrix4f, (float)this.pos.func_82615_a() + d, (float)this.pos.func_82617_b() - d, (float)this.pos.func_82616_c() + d).func_227885_a_(this.r, this.g, this.b, this.a).func_225583_a_(sprite.func_94209_e(), sprite.func_94206_g()).func_227886_a_(this.light).func_181675_d();
            this.builder.func_227888_a_(matrix4f, (float)this.pos.func_82615_a() + d, (float)this.pos.func_82617_b() + d, (float)this.pos.func_82616_c() + d).func_227885_a_(this.r, this.g, this.b, this.a).func_225583_a_(sprite.func_94209_e(), sprite.func_94210_h()).func_227886_a_(this.light).func_181675_d();
            this.builder.func_227888_a_(matrix4f, (float)this.pos.func_82615_a() - d, (float)this.pos.func_82617_b() + d, (float)this.pos.func_82616_c() + d).func_227885_a_(this.r, this.g, this.b, this.a).func_225583_a_(sprite.func_94212_f(), sprite.func_94210_h()).func_227886_a_(this.light).func_181675_d();
            this.builder.func_227888_a_(matrix4f, (float)this.pos.func_82615_a() - d, (float)this.pos.func_82617_b() - d, (float)this.pos.func_82616_c() + d).func_227885_a_(this.r, this.g, this.b, this.a).func_225583_a_(sprite.func_94212_f(), sprite.func_94206_g()).func_227886_a_(this.light).func_181675_d();
        }
        if (isAll || this.sides.contains((Object)Side.SOUTH)) {
            this.builder.func_227888_a_(matrix4f, (float)this.pos.func_82615_a() - d, (float)this.pos.func_82617_b() - d, (float)this.pos.func_82616_c() - d).func_227885_a_(this.r, this.g, this.b, this.a).func_225583_a_(sprite.func_94209_e(), sprite.func_94206_g()).func_227886_a_(this.light).func_181675_d();
            this.builder.func_227888_a_(matrix4f, (float)this.pos.func_82615_a() - d, (float)this.pos.func_82617_b() + d, (float)this.pos.func_82616_c() - d).func_227885_a_(this.r, this.g, this.b, this.a).func_225583_a_(sprite.func_94209_e(), sprite.func_94210_h()).func_227886_a_(this.light).func_181675_d();
            this.builder.func_227888_a_(matrix4f, (float)this.pos.func_82615_a() + d, (float)this.pos.func_82617_b() + d, (float)this.pos.func_82616_c() - d).func_227885_a_(this.r, this.g, this.b, this.a).func_225583_a_(sprite.func_94212_f(), sprite.func_94210_h()).func_227886_a_(this.light).func_181675_d();
            this.builder.func_227888_a_(matrix4f, (float)this.pos.func_82615_a() + d, (float)this.pos.func_82617_b() - d, (float)this.pos.func_82616_c() - d).func_227885_a_(this.r, this.g, this.b, this.a).func_225583_a_(sprite.func_94212_f(), sprite.func_94206_g()).func_227886_a_(this.light).func_181675_d();
        }
        if (isAll || this.sides.contains((Object)Side.WEST)) {
            this.builder.func_227888_a_(matrix4f, (float)this.pos.func_82615_a() - d, (float)this.pos.func_82617_b() - d, (float)this.pos.func_82616_c() + d).func_227885_a_(this.r, this.g, this.b, this.a).func_225583_a_(sprite.func_94212_f(), sprite.func_94206_g()).func_227886_a_(this.light).func_181675_d();
            this.builder.func_227888_a_(matrix4f, (float)this.pos.func_82615_a() - d, (float)this.pos.func_82617_b() + d, (float)this.pos.func_82616_c() + d).func_227885_a_(this.r, this.g, this.b, this.a).func_225583_a_(sprite.func_94212_f(), sprite.func_94210_h()).func_227886_a_(this.light).func_181675_d();
            this.builder.func_227888_a_(matrix4f, (float)this.pos.func_82615_a() - d, (float)this.pos.func_82617_b() + d, (float)this.pos.func_82616_c() - d).func_227885_a_(this.r, this.g, this.b, this.a).func_225583_a_(sprite.func_94209_e(), sprite.func_94210_h()).func_227886_a_(this.light).func_181675_d();
            this.builder.func_227888_a_(matrix4f, (float)this.pos.func_82615_a() - d, (float)this.pos.func_82617_b() - d, (float)this.pos.func_82616_c() - d).func_227885_a_(this.r, this.g, this.b, this.a).func_225583_a_(sprite.func_94209_e(), sprite.func_94206_g()).func_227886_a_(this.light).func_181675_d();
        }
        if (isAll || this.sides.contains((Object)Side.EAST)) {
            this.builder.func_227888_a_(matrix4f, (float)this.pos.func_82615_a() + d, (float)this.pos.func_82617_b() - d, (float)this.pos.func_82616_c() - d).func_227885_a_(this.r, this.g, this.b, this.a).func_225583_a_(sprite.func_94212_f(), sprite.func_94206_g()).func_227886_a_(this.light).func_181675_d();
            this.builder.func_227888_a_(matrix4f, (float)this.pos.func_82615_a() + d, (float)this.pos.func_82617_b() + d, (float)this.pos.func_82616_c() - d).func_227885_a_(this.r, this.g, this.b, this.a).func_225583_a_(sprite.func_94212_f(), sprite.func_94210_h()).func_227886_a_(this.light).func_181675_d();
            this.builder.func_227888_a_(matrix4f, (float)this.pos.func_82615_a() + d, (float)this.pos.func_82617_b() + d, (float)this.pos.func_82616_c() + d).func_227885_a_(this.r, this.g, this.b, this.a).func_225583_a_(sprite.func_94209_e(), sprite.func_94210_h()).func_227886_a_(this.light).func_181675_d();
            this.builder.func_227888_a_(matrix4f, (float)this.pos.func_82615_a() + d, (float)this.pos.func_82617_b() - d, (float)this.pos.func_82616_c() + d).func_227885_a_(this.r, this.g, this.b, this.a).func_225583_a_(sprite.func_94209_e(), sprite.func_94206_g()).func_227886_a_(this.light).func_181675_d();
        }
    }

    public static enum Side {
        ALL,
        DOWN,
        UP,
        NORTH,
        SOUTH,
        WEST,
        EAST;


        public static Side from(Direction side) {
            return Side.values()[side.ordinal() + 1];
        }
    }
}

