/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.gui.BaseContainer;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.IHoverTextWidget;
import com.supermartijn642.core.gui.widget.ITickableWidget;
import com.supermartijn642.core.gui.widget.TextFieldWidget;
import com.supermartijn642.core.gui.widget.Widget;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.util.InputMappings;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public abstract class BaseContainerScreen<T extends BaseContainer>
extends ContainerScreen<T> {
    private static final ResourceLocation SLOT_TEXTURE = new ResourceLocation("supermartijn642corelib", "textures/gui/slot.png");
    private final List<Widget> widgets = new LinkedList<Widget>();
    private final List<ITickableWidget> tickableWidgets = new LinkedList<ITickableWidget>();
    @Deprecated
    protected final T field_147002_h;
    protected final T container;
    private boolean drawSlots = true;

    public BaseContainerScreen(T screenContainer, ITextComponent title) {
        super(screenContainer, ((BaseContainer)((Object)screenContainer)).player.field_71071_by, title);
        this.container = screenContainer;
        this.field_147002_h = screenContainer;
    }

    protected abstract int sizeX();

    protected abstract int sizeY();

    protected int left() {
        return (this.field_230708_k_ - this.sizeX()) / 2;
    }

    protected int top() {
        return (this.field_230709_l_ - this.sizeY()) / 2;
    }

    public int getXSize() {
        return this.sizeX();
    }

    public int getYSize() {
        return this.sizeY();
    }

    public int getGuiLeft() {
        return this.left();
    }

    public int getGuiTop() {
        return this.top();
    }

    protected void setDrawSlots(boolean drawSlots) {
        this.drawSlots = drawSlots;
    }

    public void func_231160_c_() {
        this.field_146999_f = this.sizeX();
        this.field_147000_g = this.sizeY();
        super.func_231160_c_();
        this.widgets.clear();
        this.tickableWidgets.clear();
        this.addWidgets();
    }

    protected abstract void addWidgets();

    protected <T extends Widget> T addWidget(T widget) {
        this.widgets.add(widget);
        if (widget instanceof ITickableWidget) {
            this.tickableWidgets.add((ITickableWidget)((Object)widget));
        }
        return widget;
    }

    protected <T extends Widget> T removeWidget(T widget) {
        this.widgets.remove(widget);
        if (widget instanceof ITickableWidget) {
            this.tickableWidgets.remove(widget);
        }
        return widget;
    }

    public void func_231023_e_() {
        for (Widget widget : this.widgets) {
            if (!(widget instanceof ITickableWidget)) continue;
            ((ITickableWidget)((Object)widget)).tick();
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        matrixStack.func_227861_a_((double)this.left(), (double)this.top(), 0.0);
        this.renderBackground(matrixStack, mouseX - this.left(), mouseY - this.top());
        if (this.drawSlots) {
            for (Slot slot : ((BaseContainer)((Object)this.field_147002_h)).field_75151_b) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(SLOT_TEXTURE);
                ScreenUtils.drawTexture(matrixStack, slot.field_75223_e - 1, slot.field_75221_f - 1, 18.0f, 18.0f);
            }
        }
        matrixStack.func_227861_a_((double)(-this.left()), (double)(-this.top()), 0.0);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        RenderSystem.enableAlphaTest();
        GlStateManager.func_227722_g_();
        matrixStack.func_227861_a_((double)this.left(), (double)this.top(), 0.0);
        for (Widget widget : this.widgets) {
            widget.blitOffset = this.func_230927_p_();
            widget.wasHovered = widget.hovered;
            widget.hovered = mouseX - this.left() > widget.x && mouseX - this.left() < widget.x + widget.width && mouseY - this.top() > widget.y && mouseY - this.top() < widget.y + widget.height;
            widget.render(matrixStack, mouseX - this.left(), mouseY - this.top(), partialTicks);
            widget.narrate();
        }
        this.renderForeground(matrixStack, mouseX - this.left(), mouseY - this.top());
        for (Widget widget : this.widgets) {
            ITextComponent text;
            if (!(widget instanceof IHoverTextWidget) || !widget.isHovered() || (text = ((IHoverTextWidget)((Object)widget)).getHoverText()) == null) continue;
            this.func_238652_a_(matrixStack, text, mouseX - this.left(), mouseY - this.top());
        }
        matrixStack.func_227861_a_((double)(-this.left()), (double)(-this.top()), 0.0);
        super.func_230459_a_(matrixStack, mouseX, mouseY);
        this.renderTooltips(matrixStack, mouseX, mouseY);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int x, int y) {
    }

    protected void func_230451_b_(MatrixStack matrixStack, int x, int y) {
    }

    protected void renderBackground(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.drawScreenBackground(matrixStack);
    }

    protected void renderForeground(MatrixStack matrixStack, int mouseX, int mouseY) {
        ScreenUtils.drawString(matrixStack, this.field_230712_o_, this.field_230704_d_, 8.0f, 7.0f, 0x404040);
    }

    protected void renderTooltips(MatrixStack matrixStack, int mouseX, int mouseY) {
    }

    protected void drawScreenBackground(MatrixStack matrixStack, float x, float y, float width, float height) {
        ScreenUtils.drawScreenBackground(matrixStack, x, y, width, height);
    }

    protected void drawScreenBackground(MatrixStack matrixStack) {
        ScreenUtils.drawScreenBackground(matrixStack, 0.0f, 0.0f, this.sizeX(), this.sizeY());
    }

    public boolean func_231177_au__() {
        return false;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        this.onMousePress((int)(mouseX -= (double)this.left()), (int)(mouseY -= (double)this.top()), button);
        for (Widget widget : this.widgets) {
            widget.mouseClicked((int)mouseX, (int)mouseY, button);
        }
        return super.func_231044_a_(mouseX += (double)this.left(), mouseY += (double)this.top(), button);
    }

    protected void onMousePress(int mouseX, int mouseY, int button) {
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        this.onMouseRelease((int)(mouseX -= (double)this.left()), (int)(mouseY -= (double)this.top()), button);
        for (Widget widget : this.widgets) {
            widget.mouseReleased((int)mouseX, (int)mouseY, button);
        }
        return super.func_231048_c_(mouseX += (double)this.left(), mouseY += (double)this.top(), button);
    }

    protected void onMouseRelease(int mouseX, int mouseY, int button) {
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        this.onMouseScroll((int)(mouseX -= (double)this.left()), (int)(mouseY -= (double)this.top()), delta);
        for (Widget widget : this.widgets) {
            widget.mouseScrolled((int)mouseX, (int)mouseY, delta);
        }
        return super.func_231043_a_(mouseX += (double)this.left(), mouseY += (double)this.top(), delta);
    }

    protected void onMouseScroll(int mouseX, int mouseY, double scroll) {
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (this.keyPressed(keyCode)) {
            return true;
        }
        InputMappings.Input key = InputMappings.func_197954_a((int)keyCode, (int)scanCode);
        if (ClientUtils.getMinecraft().field_71474_y.field_151445_Q.isActiveAndMatches(key)) {
            this.func_231175_as__();
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean keyPressed(int keyCode) {
        boolean handled = false;
        for (Widget widget : this.widgets) {
            if (widget instanceof TextFieldWidget && ((TextFieldWidget)widget).canWrite()) {
                handled = true;
            }
            widget.keyPressed(keyCode);
        }
        return handled;
    }

    public boolean func_223281_a_(int keyCode, int scanCode, int modifiers) {
        return this.keyReleased(keyCode);
    }

    public boolean keyReleased(int keyCode) {
        for (Widget widget : this.widgets) {
            widget.keyReleased(keyCode);
        }
        return false;
    }

    public boolean func_231042_a_(char codePoint, int modifiers) {
        return this.charTyped(codePoint);
    }

    public boolean charTyped(char c) {
        for (Widget widget : this.widgets) {
            widget.charTyped(c);
        }
        return false;
    }
}

