/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators;

import com.supermartijn642.movingelevators.ElevatorBlockTile;
import com.supermartijn642.movingelevators.ElevatorGroup;
import com.supermartijn642.movingelevators.MovingElevators;
import com.supermartijn642.movingelevators.packets.ElevatorGroupPacket;
import com.supermartijn642.movingelevators.packets.ElevatorGroupsPacket;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ElevatorGroupCapability {
    @CapabilityInject(value=ElevatorGroupCapability.class)
    public static Capability<ElevatorGroupCapability> CAPABILITY;
    private final World world;
    private final Map<ElevatorGroupPosition, ElevatorGroup> groups = new HashMap<ElevatorGroupPosition, ElevatorGroup>();

    public static void register() {
        CapabilityManager.INSTANCE.register(ElevatorGroupCapability.class, (Capability.IStorage)new Capability.IStorage<ElevatorGroupCapability>(){

            public CompoundNBT writeNBT(Capability<ElevatorGroupCapability> capability, ElevatorGroupCapability instance, Direction side) {
                return instance.write();
            }

            public void readNBT(Capability<ElevatorGroupCapability> capability, ElevatorGroupCapability instance, Direction side, INBT nbt) {
                instance.read((CompoundNBT)nbt);
            }
        }, ElevatorGroupCapability::new);
    }

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<World> e) {
        World world = (World)e.getObject();
        final LazyOptional capability = LazyOptional.of(() -> new ElevatorGroupCapability(world));
        e.addCapability(new ResourceLocation("movingelevators", "elevator_groups"), (ICapabilityProvider)new ICapabilitySerializable<INBT>(){

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                return cap == CAPABILITY ? capability.cast() : LazyOptional.empty();
            }

            public INBT serializeNBT() {
                return CAPABILITY.writeNBT(capability.orElse(null), null);
            }

            public void deserializeNBT(INBT nbt) {
                CAPABILITY.readNBT(capability.orElse(null), null, nbt);
            }
        });
        e.addListener(() -> ((LazyOptional)capability).invalidate());
    }

    @SubscribeEvent
    public static void onTick(TickEvent.WorldTickEvent e) {
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        ElevatorGroupCapability.tickWorldCapability(e.world);
    }

    public static void tickWorldCapability(World world) {
        world.getCapability(CAPABILITY).ifPresent(ElevatorGroupCapability::tick);
    }

    @SubscribeEvent
    public static void onJoinWorld(PlayerEvent.PlayerChangedDimensionEvent e) {
        ServerPlayerEntity player = (ServerPlayerEntity)e.getPlayer();
        player.field_70170_p.getCapability(CAPABILITY).ifPresent(groups -> MovingElevators.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ElevatorGroupsPacket(groups.write())));
    }

    @SubscribeEvent
    public static void onJoin(PlayerEvent.PlayerLoggedInEvent e) {
        ServerPlayerEntity player = (ServerPlayerEntity)e.getPlayer();
        player.field_70170_p.getCapability(CAPABILITY).ifPresent(groups -> MovingElevators.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ElevatorGroupsPacket(groups.write())));
    }

    public ElevatorGroupCapability(World world) {
        this.world = world;
    }

    public ElevatorGroupCapability() {
        this.world = null;
    }

    public ElevatorGroup get(int x, int z, Direction facing) {
        return this.groups.get(new ElevatorGroupPosition(x, z, facing));
    }

    public void add(ElevatorBlockTile controller) {
        ElevatorGroupPosition pos = new ElevatorGroupPosition(controller.func_174877_v(), controller.getFacing());
        this.groups.putIfAbsent(pos, new ElevatorGroup(this.world, pos.x, pos.z, pos.facing));
        this.groups.get(pos).add(controller);
    }

    public void remove(ElevatorBlockTile controller) {
        ElevatorGroupPosition pos = new ElevatorGroupPosition(controller.func_174877_v(), controller.getFacing());
        ElevatorGroup group = this.groups.get(pos);
        group.remove(controller);
        if (group.getFloorCount() == 0) {
            this.groups.remove(pos);
        }
    }

    public void tick() {
        for (ElevatorGroup group : this.groups.values()) {
            group.update();
        }
    }

    public void updateGroup(ElevatorGroup group) {
        if (!this.world.field_72995_K && group != null) {
            MovingElevators.CHANNEL.send(PacketDistributor.DIMENSION.with(() -> ((World)this.world).func_234923_W_()), (Object)new ElevatorGroupPacket(this.writeGroup(group)));
        }
    }

    public ElevatorGroup getGroup(ElevatorBlockTile tile) {
        return this.groups.get(new ElevatorGroupPosition(tile.func_174877_v().func_177958_n(), tile.func_174877_v().func_177952_p(), tile.getFacing()));
    }

    public Collection<ElevatorGroup> getGroups() {
        return this.groups.values();
    }

    public CompoundNBT write() {
        CompoundNBT compound = new CompoundNBT();
        for (Map.Entry<ElevatorGroupPosition, ElevatorGroup> entry : this.groups.entrySet()) {
            CompoundNBT groupTag = new CompoundNBT();
            groupTag.func_218657_a("group", (INBT)entry.getValue().write());
            groupTag.func_218657_a("pos", (INBT)entry.getKey().write());
            compound.func_218657_a(entry.getKey().x + ";" + entry.getKey().z, (INBT)groupTag);
        }
        return compound;
    }

    public void read(CompoundNBT compound) {
        this.groups.clear();
        for (String key : compound.func_150296_c()) {
            CompoundNBT groupTag = compound.func_74775_l(key);
            if (!groupTag.func_74764_b("group") || !groupTag.func_74764_b("pos")) continue;
            ElevatorGroupPosition pos = ElevatorGroupPosition.read(groupTag.func_74775_l("pos"));
            ElevatorGroup group = new ElevatorGroup(this.world, pos.x, pos.z, pos.facing);
            group.read(groupTag.func_74775_l("group"));
            this.groups.put(pos, group);
        }
    }

    private CompoundNBT writeGroup(ElevatorGroup group) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_218657_a("group", (INBT)group.write());
        tag.func_218657_a("pos", (INBT)new ElevatorGroupPosition(group.x, group.z, group.facing).write());
        return tag;
    }

    public void readGroup(CompoundNBT tag) {
        if (tag.func_74764_b("group") && tag.func_74764_b("pos")) {
            ElevatorGroupPosition pos = ElevatorGroupPosition.read(tag.func_74775_l("pos"));
            ElevatorGroup group = new ElevatorGroup(this.world, pos.x, pos.z, pos.facing);
            group.read(tag.func_74775_l("group"));
            this.groups.put(pos, group);
        }
    }

    private static class ElevatorGroupPosition {
        public final int x;
        public final int z;
        public final Direction facing;

        private ElevatorGroupPosition(int x, int z, Direction facing) {
            this.x = x;
            this.z = z;
            this.facing = facing;
        }

        public ElevatorGroupPosition(BlockPos pos, Direction facing) {
            this(pos.func_177958_n(), pos.func_177952_p(), facing);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ElevatorGroupPosition that = (ElevatorGroupPosition)o;
            if (this.x != that.x) {
                return false;
            }
            if (this.z != that.z) {
                return false;
            }
            return this.facing == that.facing;
        }

        public int hashCode() {
            int result = this.x;
            result = 31 * result + this.z;
            result = 31 * result + (this.facing != null ? this.facing.hashCode() : 0);
            return result;
        }

        public CompoundNBT write() {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74768_a("x", this.x);
            tag.func_74768_a("z", this.z);
            tag.func_74768_a("facing", this.facing.func_176736_b());
            return tag;
        }

        public static ElevatorGroupPosition read(CompoundNBT tag) {
            return new ElevatorGroupPosition(tag.func_74762_e("x"), tag.func_74762_e("z"), Direction.func_176731_b((int)tag.func_74762_e("facing")));
        }
    }
}

