/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.IConfigCardAccess;
import mekanism.common.Mekanism;
import mekanism.common.registries.MekanismTileEntityTypes;
import mekanism.common.tile.TileEntityBoundingBlock;
import mekanism.common.tile.interfaces.IAdvancedBoundingBlock;
import mekanism.common.tile.interfaces.IBoundingBlock;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class TileEntityAdvancedBoundingBlock
extends TileEntityBoundingBlock
implements IConfigCardAccess.ISpecialConfigData {
    public TileEntityAdvancedBoundingBlock() {
        super(MekanismTileEntityTypes.ADVANCED_BOUNDING_BLOCK.getTileEntityType());
    }

    @Override
    protected IAdvancedBoundingBlock getInv() {
        IBoundingBlock boundingBlock = super.getInv();
        if (boundingBlock != null && !(boundingBlock instanceof IAdvancedBoundingBlock)) {
            Mekanism.logger.error("Found tile {} instead of an IAdvancedBoundingBlock, at {}. Multiblock cannot function", (Object)boundingBlock, (Object)this.getMainPos());
            return null;
        }
        return (IAdvancedBoundingBlock)boundingBlock;
    }

    @Override
    public void onPower() {
        super.onPower();
        IAdvancedBoundingBlock inv = this.getInv();
        if (inv != null) {
            inv.onPower();
        }
    }

    @Override
    public void onNoPower() {
        super.onNoPower();
        IAdvancedBoundingBlock inv = this.getInv();
        if (inv != null) {
            inv.onNoPower();
        }
    }

    @Override
    public CompoundNBT getConfigurationData(CompoundNBT nbtTags) {
        IAdvancedBoundingBlock inv = this.getInv();
        return inv == null ? new CompoundNBT() : inv.getConfigurationData(nbtTags);
    }

    @Override
    public void setConfigurationData(CompoundNBT nbtTags) {
        IAdvancedBoundingBlock inv = this.getInv();
        if (inv != null) {
            inv.setConfigurationData(nbtTags);
        }
    }

    @Override
    public String getDataType() {
        IAdvancedBoundingBlock inv = this.getInv();
        if (inv == null) {
            return "null";
        }
        return inv.getDataType();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        IAdvancedBoundingBlock inv = this.getInv();
        if (inv == null) {
            return super.getCapability(capability, side);
        }
        return inv.getOffsetCapability(capability, side, (Vector3i)this.field_174879_c.func_177973_b((Vector3i)this.getMainPos()));
    }
}

