/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tier;

import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.math.FloatingLong;
import mekanism.api.tier.BaseTier;
import mekanism.api.tier.ITier;
import mekanism.common.config.value.CachedFloatingLongValue;
import mekanism.common.util.EnumUtils;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public enum CableTier implements ITier
{
    BASIC(BaseTier.BASIC, FloatingLong.createConst(8000L)),
    ADVANCED(BaseTier.ADVANCED, FloatingLong.createConst(128000L)),
    ELITE(BaseTier.ELITE, FloatingLong.createConst(1024000L)),
    ULTIMATE(BaseTier.ULTIMATE, FloatingLong.createConst(0x7D0000L));

    private final FloatingLong baseCapacity;
    private final BaseTier baseTier;
    private CachedFloatingLongValue capacityReference;

    private CableTier(BaseTier tier, FloatingLong capacity) {
        this.baseCapacity = capacity;
        this.baseTier = tier;
    }

    public static CableTier get(BaseTier tier) {
        for (CableTier transmitter : EnumUtils.CABLE_TIERS) {
            if (transmitter.getBaseTier() != tier) continue;
            return transmitter;
        }
        return BASIC;
    }

    @Override
    public BaseTier getBaseTier() {
        return this.baseTier;
    }

    public FloatingLong getCableCapacity() {
        return this.capacityReference == null ? this.getBaseCapacity() : (FloatingLong)this.capacityReference.get();
    }

    public FloatingLong getBaseCapacity() {
        return this.baseCapacity;
    }

    public void setConfigReference(CachedFloatingLongValue capacityReference) {
        this.capacityReference = capacityReference;
    }
}

