/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import mekanism.api.Upgrade;
import mekanism.api.functions.TriConsumer;
import mekanism.common.Mekanism;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.lib.security.ISecurityObject;
import mekanism.common.lib.security.SecurityMode;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.tile.TileEntitySecurityDesk;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.tile.factory.TileEntityFactory;
import mekanism.common.tile.interfaces.IHasDumpButton;
import mekanism.common.tile.interfaces.IHasGasMode;
import mekanism.common.tile.interfaces.IHasMode;
import mekanism.common.tile.interfaces.IHasSortableFilters;
import mekanism.common.tile.interfaces.IRedstoneControl;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.tile.laser.TileEntityLaserAmplifier;
import mekanism.common.tile.machine.TileEntityDigitalMiner;
import mekanism.common.tile.machine.TileEntityFormulaicAssemblicator;
import mekanism.common.tile.qio.TileEntityQIOExporter;
import mekanism.common.tile.qio.TileEntityQIOImporter;
import mekanism.common.tile.qio.TileEntityQIORedstoneAdapter;
import mekanism.common.util.TransporterUtils;
import mekanism.common.util.UpgradeUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketGuiInteract {
    private final Type interactionType;
    private GuiInteraction interaction;
    private GuiInteractionItem itemInteraction;
    private GuiInteractionEntity entityInteraction;
    private BlockPos tilePosition;
    private ItemStack extraItem;
    private int entityID;
    private int extra;

    public PacketGuiInteract(GuiInteractionEntity interaction, int entityID) {
        this.interactionType = Type.ENTITY;
        this.entityInteraction = interaction;
        this.entityID = entityID;
    }

    public PacketGuiInteract(GuiInteraction interaction, TileEntity tile) {
        this(interaction, tile.func_174877_v());
    }

    public PacketGuiInteract(GuiInteraction interaction, TileEntity tile, int extra) {
        this(interaction, tile.func_174877_v(), extra);
    }

    public PacketGuiInteract(GuiInteraction interaction, BlockPos tilePosition) {
        this(interaction, tilePosition, 0);
    }

    public PacketGuiInteract(GuiInteraction interaction, BlockPos tilePosition, int extra) {
        this.interactionType = Type.INT;
        this.interaction = interaction;
        this.tilePosition = tilePosition;
        this.extra = extra;
    }

    public PacketGuiInteract(GuiInteractionItem interaction, TileEntity tile, ItemStack stack) {
        this(interaction, tile.func_174877_v(), stack);
    }

    public PacketGuiInteract(GuiInteractionItem interaction, BlockPos tilePosition, ItemStack stack) {
        this.interactionType = Type.ITEM;
        this.itemInteraction = interaction;
        this.tilePosition = tilePosition;
        this.extraItem = stack;
    }

    public static void handle(PacketGuiInteract message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            ServerPlayerEntity player = ctx.getSender();
            if (player != null) {
                if (message.interactionType == Type.ENTITY) {
                    Entity entity = player.field_70170_p.func_73045_a(message.entityID);
                    if (entity != null) {
                        message.entityInteraction.consume(entity, (PlayerEntity)player);
                    }
                } else {
                    TileEntityMekanism tile = WorldUtils.getTileEntity(TileEntityMekanism.class, (IBlockReader)player.field_70170_p, message.tilePosition);
                    if (tile != null) {
                        if (message.interactionType == Type.INT) {
                            message.interaction.consume(tile, (PlayerEntity)player, message.extra);
                        } else if (message.interactionType == Type.ITEM) {
                            message.itemInteraction.consume(tile, (PlayerEntity)player, message.extraItem);
                        }
                    }
                }
            }
        });
        ctx.setPacketHandled(true);
    }

    public static void encode(PacketGuiInteract pkt, PacketBuffer buf) {
        buf.func_179249_a((Enum)pkt.interactionType);
        if (pkt.interactionType == Type.ENTITY) {
            buf.func_179249_a((Enum)pkt.entityInteraction);
            buf.func_150787_b(pkt.entityID);
        } else if (pkt.interactionType == Type.INT) {
            buf.func_179249_a((Enum)pkt.interaction);
            buf.func_179255_a(pkt.tilePosition);
            buf.func_150787_b(pkt.extra);
        } else if (pkt.interactionType == Type.ITEM) {
            buf.func_179249_a((Enum)pkt.itemInteraction);
            buf.func_179255_a(pkt.tilePosition);
            buf.func_150788_a(pkt.extraItem);
        }
    }

    public static PacketGuiInteract decode(PacketBuffer buf) {
        Type type = (Type)buf.func_179257_a(Type.class);
        if (type == Type.ENTITY) {
            return new PacketGuiInteract((GuiInteractionEntity)buf.func_179257_a(GuiInteractionEntity.class), buf.func_150792_a());
        }
        if (type == Type.INT) {
            return new PacketGuiInteract((GuiInteraction)buf.func_179257_a(GuiInteraction.class), buf.func_179259_c(), buf.func_150792_a());
        }
        if (type == Type.ITEM) {
            return new PacketGuiInteract((GuiInteractionItem)buf.func_179257_a(GuiInteractionItem.class), buf.func_179259_c(), buf.func_150791_c());
        }
        Mekanism.logger.error("Received malformed GUI interaction packet.");
        return null;
    }

    private static enum Type {
        ENTITY,
        ITEM,
        INT;

    }

    public static enum GuiInteractionEntity {
        NEXT_SECURITY_MODE((entity, player) -> {
            UUID owner;
            ISecurityObject security;
            if (entity instanceof ISecurityObject && (security = (ISecurityObject)entity).hasSecurity() && (owner = security.getOwnerUUID()) != null && player.func_110124_au().equals(owner)) {
                security.setSecurityMode((SecurityMode)security.getSecurityMode().getNext());
            }
        });

        private final BiConsumer<Entity, PlayerEntity> consumerForEntity;

        private GuiInteractionEntity(BiConsumer<Entity, PlayerEntity> consumerForTile) {
            this.consumerForEntity = consumerForTile;
        }

        public void consume(Entity entity, PlayerEntity player) {
            this.consumerForEntity.accept(entity, player);
        }
    }

    public static enum GuiInteraction {
        CONTAINER_STOP_TRACKING((tile, player, extra) -> {
            if (player.field_71070_bA instanceof MekanismContainer) {
                ((MekanismContainer)player.field_71070_bA).stopTracking(extra);
            }
        }),
        CONTAINER_TRACK_EJECTOR((tile, player, extra) -> {
            if (player.field_71070_bA instanceof MekanismContainer && tile instanceof ISideConfiguration) {
                ((MekanismContainer)player.field_71070_bA).startTracking(extra, ((ISideConfiguration)((Object)tile)).getEjector());
            }
        }),
        CONTAINER_TRACK_SIDE_CONFIG((tile, player, extra) -> {
            if (player.field_71070_bA instanceof MekanismContainer && tile instanceof ISideConfiguration) {
                ((MekanismContainer)player.field_71070_bA).startTracking(extra, ((ISideConfiguration)((Object)tile)).getConfig());
            }
        }),
        QIO_REDSTONE_ADAPTER_COUNT((tile, player, extra) -> {
            if (tile instanceof TileEntityQIORedstoneAdapter) {
                ((TileEntityQIORedstoneAdapter)tile).handleCountChange((int)extra);
            }
        }),
        QIO_TOGGLE_IMPORT_WITHOUT_FILTER((tile, player, extra) -> {
            if (tile instanceof TileEntityQIOImporter) {
                ((TileEntityQIOImporter)tile).toggleImportWithoutFilter();
            }
        }),
        QIO_TOGGLE_EXPORT_WITHOUT_FILTER((tile, player, extra) -> {
            if (tile instanceof TileEntityQIOExporter) {
                ((TileEntityQIOExporter)tile).toggleExportWithoutFilter();
            }
        }),
        AUTO_SORT_BUTTON((tile, player, extra) -> {
            if (tile instanceof TileEntityFactory) {
                ((TileEntityFactory)tile).toggleSorting();
            }
        }),
        DUMP_BUTTON((tile, player, extra) -> {
            if (tile instanceof IHasDumpButton) {
                ((IHasDumpButton)((Object)tile)).dump();
            }
        }),
        GAS_MODE_BUTTON((tile, player, extra) -> {
            if (tile instanceof IHasGasMode) {
                ((IHasGasMode)((Object)tile)).nextMode((int)extra);
            }
        }),
        AUTO_EJECT_BUTTON((tile, player, extra) -> {
            if (tile instanceof TileEntityDigitalMiner) {
                ((TileEntityDigitalMiner)tile).toggleAutoEject();
            } else if (tile instanceof TileEntityLogisticalSorter) {
                ((TileEntityLogisticalSorter)tile).toggleAutoEject();
            }
        }),
        AUTO_PULL_BUTTON((tile, player, extra) -> {
            if (tile instanceof TileEntityDigitalMiner) {
                ((TileEntityDigitalMiner)tile).toggleAutoPull();
            }
        }),
        INVERSE_BUTTON((tile, player, extra) -> {
            if (tile instanceof TileEntityDigitalMiner) {
                ((TileEntityDigitalMiner)tile).toggleInverse();
            }
        }),
        RESET_BUTTON((tile, player, extra) -> {
            if (tile instanceof TileEntityDigitalMiner) {
                ((TileEntityDigitalMiner)tile).reset();
            }
        }),
        SILK_TOUCH_BUTTON((tile, player, extra) -> {
            if (tile instanceof TileEntityDigitalMiner) {
                ((TileEntityDigitalMiner)tile).toggleSilkTouch();
            }
        }),
        START_BUTTON((tile, player, extra) -> {
            if (tile instanceof TileEntityDigitalMiner) {
                ((TileEntityDigitalMiner)tile).start();
            }
        }),
        STOP_BUTTON((tile, player, extra) -> {
            if (tile instanceof TileEntityDigitalMiner) {
                ((TileEntityDigitalMiner)tile).stop();
            }
        }),
        SET_RADIUS((tile, player, extra) -> {
            if (tile instanceof TileEntityDigitalMiner) {
                ((TileEntityDigitalMiner)tile).setRadiusFromPacket((int)extra);
            }
        }),
        SET_MIN_Y((tile, player, extra) -> {
            if (tile instanceof TileEntityDigitalMiner) {
                ((TileEntityDigitalMiner)tile).setMinYFromPacket((int)extra);
            }
        }),
        SET_MAX_Y((tile, player, extra) -> {
            if (tile instanceof TileEntityDigitalMiner) {
                ((TileEntityDigitalMiner)tile).setMaxYFromPacket((int)extra);
            }
        }),
        MOVE_FILTER_UP((tile, player, extra) -> {
            if (tile instanceof IHasSortableFilters) {
                ((IHasSortableFilters)((Object)tile)).moveUp((int)extra);
            }
        }),
        MOVE_FILTER_DOWN((tile, player, extra) -> {
            if (tile instanceof IHasSortableFilters) {
                ((IHasSortableFilters)((Object)tile)).moveDown((int)extra);
            }
        }),
        REMOVE_UPGRADE((tile, player, extra) -> {
            Upgrade upgradeType;
            TileComponentUpgrade componentUpgrade;
            if (tile.supportsUpgrades() && (componentUpgrade = tile.getComponent()).getUpgrades(upgradeType = Upgrade.byIndexStatic(extra)) > 0 && player.field_71071_by.func_70441_a(UpgradeUtils.getStack(upgradeType))) {
                componentUpgrade.removeUpgrade(upgradeType);
            }
        }),
        NEXT_SECURITY_MODE((tile, player, extra) -> {
            UUID owner;
            if (tile.hasSecurity() && (owner = tile.getOwnerUUID()) != null && player.func_110124_au().equals(owner)) {
                tile.setSecurityMode((SecurityMode)tile.getSecurityMode().getNext());
            }
        }),
        SECURITY_DESK_MODE((tile, player, extra) -> {
            if (tile instanceof TileEntitySecurityDesk) {
                ((TileEntitySecurityDesk)tile).setSecurityDeskMode(SecurityMode.byIndexStatic(extra));
            }
        }),
        NEXT_MODE((tile, player, extra) -> {
            if (tile instanceof IHasMode) {
                ((IHasMode)((Object)tile)).nextMode();
            }
        }),
        NEXT_REDSTONE_CONTROL((tile, player, extra) -> tile.setControlType(tile.getControlType().getNext(mode -> mode != IRedstoneControl.RedstoneControl.PULSE || tile.canPulse()))),
        ENCODE_FORMULA((tile, player, extra) -> {
            if (tile instanceof TileEntityFormulaicAssemblicator) {
                ((TileEntityFormulaicAssemblicator)tile).encodeFormula();
            }
        }),
        STOCK_CONTROL_BUTTON((tile, player, extra) -> {
            if (tile instanceof TileEntityFormulaicAssemblicator) {
                ((TileEntityFormulaicAssemblicator)tile).toggleStockControl();
            }
        }),
        CRAFT_SINGLE((tile, player, extra) -> {
            if (tile instanceof TileEntityFormulaicAssemblicator) {
                ((TileEntityFormulaicAssemblicator)tile).craftSingle();
            }
        }),
        CRAFT_ALL((tile, player, extra) -> {
            if (tile instanceof TileEntityFormulaicAssemblicator) {
                ((TileEntityFormulaicAssemblicator)tile).craftAll();
            }
        }),
        MOVE_ITEMS((tile, player, extra) -> {
            if (tile instanceof TileEntityFormulaicAssemblicator) {
                ((TileEntityFormulaicAssemblicator)tile).moveItems();
            }
        }),
        ROUND_ROBIN_BUTTON((tile, player, extra) -> {
            if (tile instanceof TileEntityLogisticalSorter) {
                ((TileEntityLogisticalSorter)tile).toggleRoundRobin();
            }
        }),
        SINGLE_ITEM_BUTTON((tile, player, extra) -> {
            if (tile instanceof TileEntityLogisticalSorter) {
                ((TileEntityLogisticalSorter)tile).toggleSingleItem();
            }
        }),
        CHANGE_COLOR((tile, player, extra) -> {
            if (tile instanceof TileEntityLogisticalSorter) {
                ((TileEntityLogisticalSorter)tile).changeColor(TransporterUtils.readColor(extra));
            }
        }),
        OVERRIDE_BUTTON((tile, player, extra) -> {
            if (tile instanceof TileEntitySecurityDesk) {
                ((TileEntitySecurityDesk)tile).toggleOverride();
            }
        }),
        REMOVE_TRUSTED((tile, player, extra) -> {
            if (tile instanceof TileEntitySecurityDesk) {
                ((TileEntitySecurityDesk)tile).removeTrusted((int)extra);
            }
        }),
        SET_TIME((tile, player, extra) -> {
            if (tile instanceof TileEntityLaserAmplifier) {
                ((TileEntityLaserAmplifier)tile).setTime((int)extra);
            }
        });

        private final TriConsumer<TileEntityMekanism, PlayerEntity, Integer> consumerForTile;

        private GuiInteraction(TriConsumer<TileEntityMekanism, PlayerEntity, Integer> consumerForTile) {
            this.consumerForTile = consumerForTile;
        }

        public void consume(TileEntityMekanism tile, PlayerEntity player, int extra) {
            this.consumerForTile.accept(tile, player, extra);
        }
    }

    public static enum GuiInteractionItem {
        QIO_REDSTONE_ADAPTER_STACK((tile, player, stack) -> {
            if (tile instanceof TileEntityQIORedstoneAdapter) {
                ((TileEntityQIORedstoneAdapter)tile).handleStackChange((ItemStack)stack);
            }
        });

        private final TriConsumer<TileEntityMekanism, PlayerEntity, ItemStack> consumerForTile;

        private GuiInteractionItem(TriConsumer<TileEntityMekanism, PlayerEntity, ItemStack> consumerForTile) {
            this.consumerForTile = consumerForTile;
        }

        public void consume(TileEntityMekanism tile, PlayerEntity player, ItemStack stack) {
            this.consumerForTile.accept(tile, player, stack);
        }
    }
}

