/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block.attribute;

import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.IIncrementalEnum;
import mekanism.api.math.MathUtils;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.ILangEntry;
import mekanism.common.MekanismLang;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeState;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.text.ITextComponent;

public class AttributeStateBoilerValveMode
implements AttributeState {
    public static final EnumProperty<BoilerValveMode> modeProperty = EnumProperty.func_177709_a((String)"mode", BoilerValveMode.class);

    @Override
    public BlockState copyStateData(BlockState oldState, BlockState newState) {
        if (Attribute.has(newState.func_177230_c(), AttributeStateBoilerValveMode.class)) {
            newState = (BlockState)newState.func_206870_a(modeProperty, oldState.func_177229_b(modeProperty));
        }
        return newState;
    }

    @Override
    public BlockState getDefaultState(@Nonnull BlockState state) {
        return (BlockState)state.func_206870_a(modeProperty, (Comparable)((Object)BoilerValveMode.INPUT));
    }

    @Override
    public void fillBlockStateContainer(Block block, List<Property<?>> properties) {
        properties.add((Property<?>)modeProperty);
    }

    public static enum BoilerValveMode implements IStringSerializable,
    IHasTextComponent,
    IIncrementalEnum<BoilerValveMode>
    {
        INPUT("input", MekanismLang.BOILER_VALVE_MODE_INPUT, EnumColor.BRIGHT_GREEN),
        OUTPUT_STEAM("output_steam", MekanismLang.BOILER_VALVE_MODE_OUTPUT_STEAM, EnumColor.GRAY),
        OUTPUT_COOLANT("output_coolant", MekanismLang.BOILER_VALVE_MODE_OUTPUT_COOLANT, EnumColor.DARK_AQUA);

        private static final BoilerValveMode[] MODES;
        private final String name;
        private final ILangEntry langEntry;
        private final EnumColor color;

        private BoilerValveMode(String name, ILangEntry langEntry, EnumColor color) {
            this.name = name;
            this.langEntry = langEntry;
            this.color = color;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }

        @Override
        public ITextComponent getTextComponent() {
            return this.langEntry.translateColored(this.color, new Object[0]);
        }

        @Nonnull
        public static BoilerValveMode byIndexStatic(int index) {
            return MathUtils.getByIndexMod(MODES, index);
        }

        @Override
        @Nonnull
        public BoilerValveMode byIndex(int index) {
            return BoilerValveMode.byIndexStatic(index);
        }

        static {
            MODES = BoilerValveMode.values();
        }
    }
}

