/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.chemical.ChemicalBuilder;
import mekanism.api.chemical.ChemicalTags;
import mekanism.api.chemical.attribute.ChemicalAttribute;
import mekanism.api.providers.IChemicalProvider;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.IHasTranslationKey;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.ReverseTagWrapper;
import net.minecraftforge.registries.ForgeRegistryEntry;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class Chemical<CHEMICAL extends Chemical<CHEMICAL>>
extends ForgeRegistryEntry<CHEMICAL>
implements IChemicalProvider<CHEMICAL>,
IHasTextComponent,
IHasTranslationKey {
    private final ReverseTagWrapper<CHEMICAL> reverseTags = new ReverseTagWrapper(this.getChemical(), chemicalTags::getCollection);
    private final Map<Class<? extends ChemicalAttribute>, ChemicalAttribute> attributeMap;
    private final ResourceLocation iconLocation;
    private final boolean hidden;
    private final int tint;
    private String translationKey;

    protected Chemical(ChemicalBuilder<CHEMICAL, ?> builder, ChemicalTags<CHEMICAL> chemicalTags) {
        this.attributeMap = builder.getAttributeMap();
        this.iconLocation = builder.getTexture();
        this.tint = builder.getColor();
        this.hidden = builder.isHidden();
    }

    @Override
    public CHEMICAL getChemical() {
        return (CHEMICAL)this;
    }

    @Override
    public String getTranslationKey() {
        if (this.translationKey == null) {
            this.translationKey = this.getDefaultTranslationKey();
        }
        return this.translationKey;
    }

    public boolean has(Class<? extends ChemicalAttribute> type) {
        return this.attributeMap.containsKey(type);
    }

    @Nullable
    public <T extends ChemicalAttribute> T get(Class<T> type) {
        return (T)this.attributeMap.get(type);
    }

    public void addAttribute(ChemicalAttribute attribute) {
        this.attributeMap.put(attribute.getClass(), attribute);
    }

    public Collection<ChemicalAttribute> getAttributes() {
        return this.attributeMap.values();
    }

    public Collection<Class<? extends ChemicalAttribute>> getAttributeTypes() {
        return this.attributeMap.keySet();
    }

    public abstract CompoundNBT write(CompoundNBT var1);

    protected abstract String getDefaultTranslationKey();

    @Override
    public ITextComponent getTextComponent() {
        return new TranslationTextComponent(this.getTranslationKey());
    }

    public ResourceLocation getIcon() {
        return this.iconLocation;
    }

    public int getTint() {
        return this.tint;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isIn(ITag<CHEMICAL> tag) {
        return tag.func_230235_a_(this.getChemical());
    }

    public Set<ResourceLocation> getTags() {
        return this.reverseTags.getTagNames();
    }

    public abstract boolean isEmptyType();
}

