/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.network.pipe.attachment.extractor;

import com.refinedmods.refinedpipes.container.provider.ExtractorAttachmentContainerProvider;
import com.refinedmods.refinedpipes.inventory.fluid.FluidInventory;
import com.refinedmods.refinedpipes.network.Network;
import com.refinedmods.refinedpipes.network.NetworkManager;
import com.refinedmods.refinedpipes.network.fluid.FluidNetwork;
import com.refinedmods.refinedpipes.network.item.ItemNetwork;
import com.refinedmods.refinedpipes.network.pipe.Destination;
import com.refinedmods.refinedpipes.network.pipe.Pipe;
import com.refinedmods.refinedpipes.network.pipe.attachment.Attachment;
import com.refinedmods.refinedpipes.network.pipe.attachment.extractor.BlacklistWhitelist;
import com.refinedmods.refinedpipes.network.pipe.attachment.extractor.ExtractorAttachmentType;
import com.refinedmods.refinedpipes.network.pipe.attachment.extractor.ItemDestinationFinder;
import com.refinedmods.refinedpipes.network.pipe.attachment.extractor.RedstoneMode;
import com.refinedmods.refinedpipes.network.pipe.attachment.extractor.RoutingMode;
import com.refinedmods.refinedpipes.network.pipe.item.ItemPipe;
import com.refinedmods.refinedpipes.network.pipe.transport.ItemTransport;
import com.refinedmods.refinedpipes.network.pipe.transport.callback.ItemBounceBackTransportCallback;
import com.refinedmods.refinedpipes.network.pipe.transport.callback.ItemInsertTransportCallback;
import com.refinedmods.refinedpipes.network.pipe.transport.callback.ItemPipeGoneTransportCallback;
import com.refinedmods.refinedpipes.routing.Path;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExtractorAttachment
extends Attachment {
    private static final Logger LOGGER = LogManager.getLogger(ExtractorAttachment.class);
    public static final int MAX_FILTER_SLOTS = 15;
    private final ExtractorAttachmentType type;
    private final ItemStackHandler itemFilter;
    private final FluidInventory fluidFilter;
    private final ItemDestinationFinder itemDestinationFinder = new ItemDestinationFinder(this);
    private int ticks;
    private RedstoneMode redstoneMode = RedstoneMode.IGNORED;
    private BlacklistWhitelist blacklistWhitelist = BlacklistWhitelist.BLACKLIST;
    private RoutingMode routingMode = RoutingMode.NEAREST;
    private int stackSize;
    private boolean exactMode = true;

    public ExtractorAttachment(Pipe pipe, Direction direction, ExtractorAttachmentType type) {
        super(pipe, direction);
        this.type = type;
        this.stackSize = type.getItemsToExtract();
        this.itemFilter = ExtractorAttachment.createItemFilterInventory(this);
        this.fluidFilter = ExtractorAttachment.createFluidFilterInventory(this);
    }

    public boolean isFluidMode() {
        return this.pipe.getNetwork() instanceof FluidNetwork;
    }

    @Override
    public void update() {
        Network network = this.pipe.getNetwork();
        int tickInterval = 0;
        if (network instanceof ItemNetwork) {
            tickInterval = this.type.getItemTickInterval();
        } else if (network instanceof FluidNetwork) {
            tickInterval = this.type.getFluidTickInterval();
        }
        if (tickInterval != 0 && this.ticks++ % tickInterval != 0) {
            return;
        }
        if (!this.redstoneMode.isEnabled(this.pipe.getWorld(), this.pipe.getPos())) {
            return;
        }
        BlockPos destinationPos = this.pipe.getPos().func_177972_a(this.getDirection());
        TileEntity tile = this.pipe.getWorld().func_175625_s(destinationPos);
        if (tile == null) {
            return;
        }
        if (network instanceof ItemNetwork) {
            tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.getDirection().func_176734_d()).ifPresent(itemHandler -> this.update((ItemNetwork)network, destinationPos, (IItemHandler)itemHandler));
        } else if (network instanceof FluidNetwork) {
            tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.getDirection().func_176734_d()).ifPresent(fluidHandler -> this.update((FluidNetwork)network, (IFluidHandler)fluidHandler));
        }
    }

    private void update(ItemNetwork network, BlockPos sourcePos, IItemHandler source) {
        if (this.stackSize == 0) {
            return;
        }
        Pair<Destination, Integer> destinationAndSourceSlot = this.findDestinationAndSourceSlot(sourcePos, source);
        if (destinationAndSourceSlot == null) {
            return;
        }
        Destination destination = (Destination)destinationAndSourceSlot.getLeft();
        Path<BlockPos> path = network.getDestinationPathCache().getPath(this.pipe.getPos(), destination);
        if (path == null) {
            LOGGER.error("No path found from " + this.pipe.getPos() + " to " + destination);
            return;
        }
        ItemStack extracted = source.extractItem(((Integer)destinationAndSourceSlot.getRight()).intValue(), this.stackSize, false);
        if (extracted.func_190926_b()) {
            return;
        }
        BlockPos fromPos = this.pipe.getPos().func_177972_a(this.getDirection());
        ((ItemPipe)this.pipe).addTransport(new ItemTransport(extracted.func_77946_l(), fromPos, destination.getReceiver(), path.toQueue(), new ItemInsertTransportCallback(destination.getReceiver(), destination.getIncomingDirection(), extracted), new ItemBounceBackTransportCallback(destination.getReceiver(), sourcePos, extracted), new ItemPipeGoneTransportCallback(extracted)));
    }

    private Pair<Destination, Integer> findDestinationAndSourceSlot(BlockPos sourcePos, IItemHandler source) {
        int startIndex = 0;
        do {
            ItemStack slot;
            if ((slot = source.getStackInSlot(startIndex)).func_190926_b() || !this.acceptsItem(slot)) {
                ++startIndex;
                continue;
            }
            ItemStack extracted = source.extractItem(startIndex, this.stackSize, true);
            if (extracted.func_190926_b()) {
                ++startIndex;
                continue;
            }
            Destination destination = this.itemDestinationFinder.find(this.routingMode, sourcePos, extracted);
            if (destination == null) {
                ++startIndex;
                continue;
            }
            return Pair.of((Object)destination, (Object)startIndex);
        } while (startIndex < source.getSlots());
        return null;
    }

    private void update(FluidNetwork network, IFluidHandler source) {
        FluidStack drained = source.drain(this.type.getFluidsToExtract(), IFluidHandler.FluidAction.SIMULATE);
        if (drained.isEmpty()) {
            return;
        }
        if (!this.acceptsFluid(drained)) {
            return;
        }
        int filled = network.getFluidTank().fill(drained, IFluidHandler.FluidAction.SIMULATE);
        if (filled <= 0) {
            return;
        }
        int toDrain = Math.min(this.type.getFluidsToExtract(), filled);
        drained = source.drain(toDrain, IFluidHandler.FluidAction.EXECUTE);
        network.getFluidTank().fill(drained, IFluidHandler.FluidAction.EXECUTE);
        NetworkManager.get(this.pipe.getWorld()).func_76185_a();
    }

    private boolean acceptsItem(ItemStack stack) {
        if (this.blacklistWhitelist == BlacklistWhitelist.WHITELIST) {
            for (int i = 0; i < this.itemFilter.getSlots(); ++i) {
                ItemStack filtered = this.itemFilter.getStackInSlot(i);
                boolean equals = filtered.func_77969_a(stack);
                if (this.exactMode) {
                    boolean bl = equals = equals && ItemStack.func_77970_a((ItemStack)filtered, (ItemStack)stack);
                }
                if (!equals) continue;
                return true;
            }
            return false;
        }
        if (this.blacklistWhitelist == BlacklistWhitelist.BLACKLIST) {
            for (int i = 0; i < this.itemFilter.getSlots(); ++i) {
                ItemStack filtered = this.itemFilter.getStackInSlot(i);
                boolean equals = filtered.func_77969_a(stack);
                if (this.exactMode) {
                    boolean bl = equals = equals && ItemStack.func_77970_a((ItemStack)filtered, (ItemStack)stack);
                }
                if (!equals) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean acceptsFluid(FluidStack stack) {
        if (this.blacklistWhitelist == BlacklistWhitelist.WHITELIST) {
            for (int i = 0; i < this.fluidFilter.getSlots(); ++i) {
                boolean equals;
                FluidStack filtered = this.fluidFilter.getFluid(i);
                boolean bl = equals = filtered.getFluid() == stack.getFluid();
                if (this.exactMode) {
                    boolean bl2 = equals = equals && FluidStack.areFluidStackTagsEqual((FluidStack)filtered, (FluidStack)stack);
                }
                if (!equals) continue;
                return true;
            }
            return false;
        }
        if (this.blacklistWhitelist == BlacklistWhitelist.BLACKLIST) {
            for (int i = 0; i < this.fluidFilter.getSlots(); ++i) {
                boolean equals;
                FluidStack filtered = this.fluidFilter.getFluid(i);
                boolean bl = equals = filtered.getFluid() == stack.getFluid();
                if (this.exactMode) {
                    boolean bl3 = equals = equals && FluidStack.areFluidStackTagsEqual((FluidStack)filtered, (FluidStack)stack);
                }
                if (!equals) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void openContainer(ServerPlayerEntity player) {
        super.openContainer(player);
        ExtractorAttachmentContainerProvider.open(this.pipe, this, player);
    }

    @Override
    public ResourceLocation getId() {
        return this.type.getId();
    }

    @Override
    public ItemStack getDrop() {
        return new ItemStack((IItemProvider)this.type.getItem());
    }

    @Override
    public CompoundNBT writeToNbt(CompoundNBT tag) {
        tag.func_74774_a("rm", (byte)this.redstoneMode.ordinal());
        tag.func_218657_a("itemfilter", (INBT)this.itemFilter.serializeNBT());
        tag.func_74774_a("bw", (byte)this.blacklistWhitelist.ordinal());
        tag.func_74768_a("rr", this.itemDestinationFinder.getRoundRobinIndex());
        tag.func_74774_a("routingm", (byte)this.routingMode.ordinal());
        tag.func_74768_a("stacksi", this.stackSize);
        tag.func_74757_a("exa", this.exactMode);
        tag.func_218657_a("fluidfilter", (INBT)this.fluidFilter.writeToNbt());
        return super.writeToNbt(tag);
    }

    public ExtractorAttachmentType getType() {
        return this.type;
    }

    public ItemStackHandler getItemFilter() {
        return this.itemFilter;
    }

    public FluidInventory getFluidFilter() {
        return this.fluidFilter;
    }

    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    public void setRedstoneMode(RedstoneMode redstoneMode) {
        if (!this.type.getCanSetRedstoneMode()) {
            return;
        }
        this.redstoneMode = redstoneMode;
    }

    public void setBlacklistWhitelist(BlacklistWhitelist blacklistWhitelist) {
        if (!this.type.getCanSetWhitelistBlacklist()) {
            return;
        }
        this.blacklistWhitelist = blacklistWhitelist;
    }

    public BlacklistWhitelist getBlacklistWhitelist() {
        return this.blacklistWhitelist;
    }

    public void setRoutingMode(RoutingMode routingMode) {
        if (!this.type.getCanSetRoutingMode()) {
            return;
        }
        this.routingMode = routingMode;
    }

    public RoutingMode getRoutingMode() {
        return this.routingMode;
    }

    public void setStackSize(int stackSize) {
        if (stackSize < 0) {
            stackSize = 0;
        }
        if (stackSize > this.type.getItemsToExtract()) {
            stackSize = this.type.getItemsToExtract();
        }
        this.stackSize = stackSize;
    }

    public int getStackSize() {
        return this.stackSize;
    }

    public void setRoundRobinIndex(int roundRobinIndex) {
        this.itemDestinationFinder.setRoundRobinIndex(roundRobinIndex);
    }

    public void setExactMode(boolean exactMode) {
        if (!this.type.getCanSetExactMode()) {
            return;
        }
        this.exactMode = exactMode;
    }

    public boolean isExactMode() {
        return this.exactMode;
    }

    public static ItemStackHandler createItemFilterInventory(final @Nullable ExtractorAttachment attachment) {
        return new ItemStackHandler(15){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                if (attachment != null) {
                    NetworkManager.get(attachment.pipe.getWorld()).func_76185_a();
                }
            }
        };
    }

    public static FluidInventory createFluidFilterInventory(final @Nullable ExtractorAttachment attachment) {
        return new FluidInventory(15){

            @Override
            protected void onContentsChanged() {
                super.onContentsChanged();
                if (attachment != null) {
                    NetworkManager.get(attachment.pipe.getWorld()).func_76185_a();
                }
            }
        };
    }
}

