/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.block;

import com.refinedmods.refinedpipes.block.PipeBlock;
import com.refinedmods.refinedpipes.network.pipe.item.ItemPipeType;
import com.refinedmods.refinedpipes.network.pipe.shape.PipeShapeCache;
import com.refinedmods.refinedpipes.tile.ItemPipeTileEntity;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraftforge.items.CapabilityItemHandler;

public class ItemPipeBlock
extends PipeBlock {
    private final ItemPipeType type;

    public ItemPipeBlock(PipeShapeCache shapeCache, ItemPipeType type) {
        super(shapeCache);
        this.type = type;
        this.setRegistryName(type.getId());
    }

    public ItemPipeType getType() {
        return this.type;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ItemPipeTileEntity(this.type);
    }

    @Override
    protected boolean hasConnection(IWorld world, BlockPos pos, Direction direction) {
        TileEntity currentTile = world.func_175625_s(pos);
        if (currentTile instanceof ItemPipeTileEntity && ((ItemPipeTileEntity)currentTile).getAttachmentManager().hasAttachment(direction)) {
            return false;
        }
        BlockState facingState = world.func_180495_p(pos.func_177972_a(direction));
        TileEntity facingTile = world.func_175625_s(pos.func_177972_a(direction));
        if (facingTile instanceof ItemPipeTileEntity && ((ItemPipeTileEntity)facingTile).getAttachmentManager().hasAttachment(direction.func_176734_d())) {
            return false;
        }
        return facingState.func_177230_c() instanceof ItemPipeBlock;
    }

    @Override
    protected boolean hasInvConnection(IWorld world, BlockPos pos, Direction direction) {
        TileEntity facingTile = world.func_175625_s(pos.func_177972_a(direction));
        return facingTile != null && facingTile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.func_176734_d()).isPresent();
    }
}

