/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.block;

import com.refinedmods.refinedpipes.block.PipeBlock;
import com.refinedmods.refinedpipes.network.pipe.energy.EnergyPipeEnergyStorage;
import com.refinedmods.refinedpipes.network.pipe.energy.EnergyPipeType;
import com.refinedmods.refinedpipes.network.pipe.shape.PipeShapeCache;
import com.refinedmods.refinedpipes.tile.EnergyPipeTileEntity;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyPipeBlock
extends PipeBlock {
    private final EnergyPipeType type;

    public EnergyPipeBlock(PipeShapeCache shapeCache, EnergyPipeType type) {
        super(shapeCache);
        this.type = type;
        this.setRegistryName(type.getId());
    }

    public EnergyPipeType getType() {
        return this.type;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new EnergyPipeTileEntity(this.type);
    }

    @Override
    protected boolean hasConnection(IWorld world, BlockPos pos, Direction direction) {
        TileEntity currentTile = world.func_175625_s(pos);
        if (currentTile instanceof EnergyPipeTileEntity && ((EnergyPipeTileEntity)currentTile).getAttachmentManager().hasAttachment(direction)) {
            return false;
        }
        BlockState facingState = world.func_180495_p(pos.func_177972_a(direction));
        TileEntity facingTile = world.func_175625_s(pos.func_177972_a(direction));
        if (facingTile instanceof EnergyPipeTileEntity && ((EnergyPipeTileEntity)facingTile).getAttachmentManager().hasAttachment(direction.func_176734_d())) {
            return false;
        }
        return facingState.func_177230_c() instanceof EnergyPipeBlock && ((EnergyPipeBlock)facingState.func_177230_c()).getType() == this.type;
    }

    @Override
    protected boolean hasInvConnection(IWorld world, BlockPos pos, Direction direction) {
        TileEntity facingTile = world.func_175625_s(pos.func_177972_a(direction));
        if (facingTile == null) {
            return false;
        }
        IEnergyStorage energyStorage = (IEnergyStorage)facingTile.getCapability(CapabilityEnergy.ENERGY, direction.func_176734_d()).orElse(null);
        if (energyStorage == null) {
            return false;
        }
        return !(energyStorage instanceof EnergyPipeEnergyStorage);
    }
}

