/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;

public class ShadowRenderHelper {
    private static final RenderType SHADOW_LAYER = RenderType.func_228650_h_((ResourceLocation)new ResourceLocation("textures/misc/shadow.png"));

    public static void renderShadow(MatrixStack matrixStack, IRenderTypeBuffer buffer, float opacity, float radius) {
        MatrixStack.Entry entry = matrixStack.func_227866_c_();
        IVertexBuilder builder = buffer.getBuffer(SHADOW_LAYER);
        ShadowRenderHelper.shadowVertex(entry, builder, opacity /= 2.0f, -1.0f * radius, 0.0f, -1.0f * radius, 0.0f, 0.0f);
        ShadowRenderHelper.shadowVertex(entry, builder, opacity, -1.0f * radius, 0.0f, 1.0f * radius, 0.0f, 1.0f);
        ShadowRenderHelper.shadowVertex(entry, builder, opacity, 1.0f * radius, 0.0f, 1.0f * radius, 1.0f, 1.0f);
        ShadowRenderHelper.shadowVertex(entry, builder, opacity, 1.0f * radius, 0.0f, -1.0f * radius, 1.0f, 0.0f);
    }

    public static void renderShadow(MatrixStack matrixStack, IRenderTypeBuffer buffer, IWorldReader world, Vector3d pos, float opacity, float radius) {
        float f = radius;
        double d2 = pos.func_82615_a();
        double d0 = pos.func_82617_b();
        double d1 = pos.func_82616_c();
        int i = MathHelper.func_76128_c((double)(d2 - (double)f));
        int j = MathHelper.func_76128_c((double)(d2 + (double)f));
        int k = MathHelper.func_76128_c((double)(d0 - (double)f));
        int l = MathHelper.func_76128_c((double)d0);
        int i1 = MathHelper.func_76128_c((double)(d1 - (double)f));
        int j1 = MathHelper.func_76128_c((double)(d1 + (double)f));
        MatrixStack.Entry entry = matrixStack.func_227866_c_();
        IVertexBuilder builder = buffer.getBuffer(SHADOW_LAYER);
        for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)new BlockPos(i, k, i1), (BlockPos)new BlockPos(j, l, j1))) {
            ShadowRenderHelper.renderBlockShadow(entry, builder, world, blockpos, d2, d0, d1, f, opacity);
        }
    }

    private static void renderBlockShadow(MatrixStack.Entry entry, IVertexBuilder builder, IWorldReader world, BlockPos pos, double x, double y, double z, float radius, float opacity) {
        float f;
        VoxelShape voxelshape;
        BlockPos blockpos = pos.func_177977_b();
        BlockState blockstate = world.func_180495_p(blockpos);
        if (blockstate.func_185901_i() != BlockRenderType.INVISIBLE && world.func_201696_r(pos) > 3 && blockstate.func_235785_r_((IBlockReader)world, blockpos) && !(voxelshape = blockstate.func_196954_c((IBlockReader)world, pos.func_177977_b())).func_197766_b() && (f = (float)(((double)opacity - (y - (double)pos.func_177956_o()) / 2.0) * 0.5 * (double)world.func_205052_D(pos))) >= 0.0f) {
            if (f > 1.0f) {
                f = 1.0f;
            }
            AxisAlignedBB axisalignedbb = voxelshape.func_197752_a();
            double d0 = (double)pos.func_177958_n() + axisalignedbb.field_72340_a;
            double d1 = (double)pos.func_177958_n() + axisalignedbb.field_72336_d;
            double d2 = (double)pos.func_177956_o() + axisalignedbb.field_72338_b;
            double d3 = (double)pos.func_177952_p() + axisalignedbb.field_72339_c;
            double d4 = (double)pos.func_177952_p() + axisalignedbb.field_72334_f;
            float f1 = (float)(d0 - x);
            float f2 = (float)(d1 - x);
            float f3 = (float)(d2 - y + 0.015625);
            float f4 = (float)(d3 - z);
            float f5 = (float)(d4 - z);
            float f6 = -f1 / 2.0f / radius + 0.5f;
            float f7 = -f2 / 2.0f / radius + 0.5f;
            float f8 = -f4 / 2.0f / radius + 0.5f;
            float f9 = -f5 / 2.0f / radius + 0.5f;
            ShadowRenderHelper.shadowVertex(entry, builder, f, f1, f3, f4, f6, f8);
            ShadowRenderHelper.shadowVertex(entry, builder, f, f1, f3, f5, f6, f9);
            ShadowRenderHelper.shadowVertex(entry, builder, f, f2, f3, f5, f7, f9);
            ShadowRenderHelper.shadowVertex(entry, builder, f, f2, f3, f4, f7, f8);
        }
    }

    private static void shadowVertex(MatrixStack.Entry entry, IVertexBuilder builder, float alpha, float x, float y, float z, float u, float v) {
        builder.func_227888_a_(entry.func_227870_a_(), x, y, z).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(u, v).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_227887_a_(entry.func_227872_b_(), 0.0f, 1.0f, 0.0f).func_181675_d();
    }
}

