/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item;

import com.simibubi.create.AllItems;
import com.simibubi.create.content.logistics.item.LecternControllerTileEntity;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public abstract class LinkedControllerPacketBase
extends SimplePacketBase {
    private BlockPos lecternPos;

    public LinkedControllerPacketBase(BlockPos lecternPos) {
        this.lecternPos = lecternPos;
    }

    public LinkedControllerPacketBase(PacketBuffer buffer) {
        if (buffer.readBoolean()) {
            this.lecternPos = new BlockPos(buffer.readInt(), buffer.readInt(), buffer.readInt());
        }
    }

    protected boolean inLectern() {
        return this.lecternPos != null;
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.writeBoolean(this.inLectern());
        if (this.inLectern()) {
            buffer.writeInt(this.lecternPos.func_177958_n());
            buffer.writeInt(this.lecternPos.func_177956_o());
            buffer.writeInt(this.lecternPos.func_177952_p());
        }
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)context.get()).getSender();
            if (player == null) {
                return;
            }
            if (this.inLectern()) {
                TileEntity te = player.field_70170_p.func_175625_s(this.lecternPos);
                if (!(te instanceof LecternControllerTileEntity)) {
                    return;
                }
                this.handleLectern(player, (LecternControllerTileEntity)te);
            } else {
                ItemStack controller = player.func_184614_ca();
                if (!AllItems.LINKED_CONTROLLER.isIn(controller) && !AllItems.LINKED_CONTROLLER.isIn(controller = player.func_184592_cb())) {
                    return;
                }
                this.handleItem(player, controller);
            }
        });
        context.get().setPacketHandled(true);
    }

    protected abstract void handleItem(ServerPlayerEntity var1, ItemStack var2);

    protected abstract void handleLectern(ServerPlayerEntity var1, LecternControllerTileEntity var2);
}

