/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.processing;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.utility.Pair;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class ProcessingOutput {
    public static final ProcessingOutput EMPTY = new ProcessingOutput(ItemStack.field_190927_a, 1.0f);
    private static final Random r = new Random();
    private final ItemStack stack;
    private final float chance;
    private Pair<ResourceLocation, Integer> compatDatagenOutput;

    public ProcessingOutput(ItemStack stack, float chance) {
        this.stack = stack;
        this.chance = chance;
    }

    public ProcessingOutput(Pair<ResourceLocation, Integer> item, float chance) {
        this.stack = ItemStack.field_190927_a;
        this.compatDatagenOutput = item;
        this.chance = chance;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public float getChance() {
        return this.chance;
    }

    public ItemStack rollOutput() {
        int outputAmount = this.stack.func_190916_E();
        for (int roll = 0; roll < this.stack.func_190916_E(); ++roll) {
            if (!(r.nextFloat() > this.chance)) continue;
            --outputAmount;
        }
        if (outputAmount == 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack out = this.stack.func_77946_l();
        out.func_190920_e(outputAmount);
        return out;
    }

    public JsonElement serialize() {
        int count;
        JsonObject json = new JsonObject();
        ResourceLocation resourceLocation = this.compatDatagenOutput == null ? this.stack.func_77973_b().getRegistryName() : this.compatDatagenOutput.getFirst();
        json.addProperty("item", resourceLocation.toString());
        int n = count = this.compatDatagenOutput == null ? this.stack.func_190916_E() : this.compatDatagenOutput.getSecond().intValue();
        if (count != 1) {
            json.addProperty("count", (Number)count);
        }
        if (this.stack.func_77942_o()) {
            json.add("nbt", new JsonParser().parse(this.stack.func_77978_p().toString()));
        }
        if (this.chance != 1.0f) {
            json.addProperty("chance", (Number)Float.valueOf(this.chance));
        }
        return json;
    }

    public static ProcessingOutput deserialize(JsonElement je) {
        if (!je.isJsonObject()) {
            throw new JsonSyntaxException("ProcessingOutput must be a json object");
        }
        JsonObject json = je.getAsJsonObject();
        String itemId = JSONUtils.func_151200_h((JsonObject)json, (String)"item");
        int count = JSONUtils.func_151208_a((JsonObject)json, (String)"count", (int)1);
        float chance = JSONUtils.func_151204_g((JsonObject)json, (String)"chance") ? JSONUtils.func_151217_k((JsonObject)json, (String)"chance") : 1.0f;
        ItemStack itemstack = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemId)), count);
        if (JSONUtils.func_151204_g((JsonObject)json, (String)"nbt")) {
            try {
                JsonElement element = json.get("nbt");
                itemstack.func_77982_d(JsonToNBT.func_180713_a((String)(element.isJsonObject() ? Create.GSON.toJson(element) : JSONUtils.func_151206_a((JsonElement)element, (String)"nbt"))));
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
            }
        }
        return new ProcessingOutput(itemstack, chance);
    }

    public void write(PacketBuffer buf) {
        buf.func_150788_a(this.getStack());
        buf.writeFloat(this.getChance());
    }

    public static ProcessingOutput read(PacketBuffer buf) {
        return new ProcessingOutput(buf.func_150791_c(), buf.readFloat());
    }
}

