/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.tank;

import com.simibubi.create.content.contraptions.fluids.tank.FluidTankBlock;
import com.simibubi.create.content.contraptions.fluids.tank.FluidTankConnectivityHandler;
import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.gui.widgets.InterpolatedChasingValue;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class FluidTankTileEntity
extends SmartTileEntity
implements IHaveGoggleInformation {
    private static final int MAX_SIZE = 3;
    protected LazyOptional<IFluidHandler> fluidCapability;
    protected boolean forceFluidLevelUpdate = true;
    protected FluidTank tankInventory = this.createInventory();
    protected BlockPos controller;
    protected BlockPos lastKnownPos;
    protected boolean updateConnectivity = false;
    protected boolean window = true;
    protected int luminosity;
    protected int width = 1;
    protected int height = 1;
    private static final int SYNC_RATE = 8;
    protected int syncCooldown;
    protected boolean queuedSync;
    private InterpolatedChasingValue fluidLevel;
    private AxisAlignedBB renderBoundingBox;

    public FluidTankTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.fluidCapability = LazyOptional.of(() -> this.tankInventory);
        this.refreshCapability();
    }

    protected SmartFluidTank createInventory() {
        return new SmartFluidTank(FluidTankTileEntity.getCapacityMultiplier(), this::onFluidStackChanged);
    }

    protected void updateConnectivity() {
        this.updateConnectivity = false;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        FluidTankConnectivityHandler.formTanks(this);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.syncCooldown > 0) {
            --this.syncCooldown;
            if (this.syncCooldown == 0 && this.queuedSync) {
                this.sendData();
            }
        }
        if (this.lastKnownPos == null) {
            this.lastKnownPos = this.func_174877_v();
        } else if (!this.lastKnownPos.equals((Object)this.field_174879_c) && this.field_174879_c != null) {
            this.onPositionChanged();
            return;
        }
        if (this.updateConnectivity) {
            this.updateConnectivity();
        }
        if (this.fluidLevel != null) {
            this.fluidLevel.tick();
        }
    }

    public BlockPos getLastKnownPos() {
        return this.lastKnownPos;
    }

    public boolean isController() {
        return this.controller == null || this.field_174879_c.func_177958_n() == this.controller.func_177958_n() && this.field_174879_c.func_177956_o() == this.controller.func_177956_o() && this.field_174879_c.func_177952_p() == this.controller.func_177952_p();
    }

    @Override
    public void initialize() {
        super.initialize();
        this.sendData();
        if (this.field_145850_b.field_72995_K) {
            this.updateRenderBoundingBox();
        }
    }

    private void onPositionChanged() {
        this.removeController(true);
        this.lastKnownPos = this.field_174879_c;
    }

    protected void onFluidStackChanged(FluidStack newFluidStack) {
        if (!this.func_145830_o()) {
            return;
        }
        FluidAttributes attributes = newFluidStack.getFluid().getAttributes();
        int luminosity = (int)((float)attributes.getLuminosity(newFluidStack) / 1.2f);
        boolean reversed = attributes.isLighterThanAir();
        int maxY = (int)(this.getFillState() * (float)this.height + 1.0f);
        for (int yOffset = 0; yOffset < this.height; ++yOffset) {
            boolean isBright;
            boolean bl = reversed ? this.height - yOffset <= maxY : (isBright = yOffset < maxY);
            int actualLuminosity = isBright ? luminosity : (luminosity > 0 ? 1 : 0);
            for (int xOffset = 0; xOffset < this.width; ++xOffset) {
                for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                    BlockPos pos = this.field_174879_c.func_177982_a(xOffset, yOffset, zOffset);
                    FluidTankTileEntity tankAt = FluidTankConnectivityHandler.anyTankAt((IBlockReader)this.field_145850_b, pos);
                    if (tankAt == null) continue;
                    this.field_145850_b.func_175666_e(pos, tankAt.func_195044_w().func_177230_c());
                    if (tankAt.luminosity == actualLuminosity) continue;
                    tankAt.setLuminosity(actualLuminosity);
                }
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            this.func_70296_d();
            this.sendData();
        }
        if (this.isVirtual()) {
            if (this.fluidLevel == null) {
                this.fluidLevel = new InterpolatedChasingValue().start(this.getFillState());
            }
            this.fluidLevel.target(this.getFillState());
        }
    }

    protected void setLuminosity(int luminosity) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.luminosity == luminosity) {
            return;
        }
        this.luminosity = luminosity;
        this.sendData();
    }

    public FluidTankTileEntity getControllerTE() {
        if (this.isController()) {
            return this;
        }
        TileEntity tileEntity = this.field_145850_b.func_175625_s(this.controller);
        if (tileEntity instanceof FluidTankTileEntity) {
            return (FluidTankTileEntity)tileEntity;
        }
        return null;
    }

    public void applyFluidTankSize(int blocks) {
        this.tankInventory.setCapacity(blocks * FluidTankTileEntity.getCapacityMultiplier());
        int overflow = this.tankInventory.getFluidAmount() - this.tankInventory.getCapacity();
        if (overflow > 0) {
            this.tankInventory.drain(overflow, IFluidHandler.FluidAction.EXECUTE);
        }
        this.forceFluidLevelUpdate = true;
    }

    public void removeController(boolean keepFluids) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.updateConnectivity = true;
        if (!keepFluids) {
            this.applyFluidTankSize(1);
        }
        this.controller = null;
        this.width = 1;
        this.height = 1;
        this.onFluidStackChanged(this.tankInventory.getFluid());
        BlockState state = this.func_195044_w();
        if (FluidTankBlock.isTank(state)) {
            state = (BlockState)state.func_206870_a((Property)FluidTankBlock.BOTTOM, (Comparable)Boolean.valueOf(true));
            state = (BlockState)state.func_206870_a((Property)FluidTankBlock.TOP, (Comparable)Boolean.valueOf(true));
            state = (BlockState)state.func_206870_a(FluidTankBlock.SHAPE, (Comparable)((Object)(this.window ? FluidTankBlock.Shape.WINDOW : FluidTankBlock.Shape.PLAIN)));
            this.func_145831_w().func_180501_a(this.field_174879_c, state, 22);
        }
        this.refreshCapability();
        this.func_70296_d();
        this.sendData();
    }

    public void toggleWindows() {
        FluidTankTileEntity te = this.getControllerTE();
        if (te == null) {
            return;
        }
        te.setWindows(!te.window);
    }

    public void sendDataImmediately() {
        this.syncCooldown = 0;
        this.queuedSync = false;
        this.sendData();
    }

    @Override
    public void sendData() {
        if (this.syncCooldown > 0) {
            this.queuedSync = true;
            return;
        }
        super.sendData();
        this.queuedSync = false;
        this.syncCooldown = 8;
    }

    public void setWindows(boolean window) {
        this.window = window;
        for (int yOffset = 0; yOffset < this.height; ++yOffset) {
            for (int xOffset = 0; xOffset < this.width; ++xOffset) {
                for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                    BlockPos pos = this.field_174879_c.func_177982_a(xOffset, yOffset, zOffset);
                    BlockState blockState = this.field_145850_b.func_180495_p(pos);
                    if (!FluidTankBlock.isTank(blockState)) continue;
                    FluidTankBlock.Shape shape = FluidTankBlock.Shape.PLAIN;
                    if (window) {
                        if (this.width == 1) {
                            shape = FluidTankBlock.Shape.WINDOW;
                        }
                        if (this.width == 2) {
                            FluidTankBlock.Shape shape2 = xOffset == 0 ? (zOffset == 0 ? FluidTankBlock.Shape.WINDOW_NW : FluidTankBlock.Shape.WINDOW_SW) : (shape = zOffset == 0 ? FluidTankBlock.Shape.WINDOW_NE : FluidTankBlock.Shape.WINDOW_SE);
                        }
                        if (this.width == 3 && Math.abs(Math.abs(xOffset) - Math.abs(zOffset)) == 1) {
                            shape = FluidTankBlock.Shape.WINDOW;
                        }
                    }
                    this.field_145850_b.func_180501_a(pos, (BlockState)blockState.func_206870_a(FluidTankBlock.SHAPE, (Comparable)((Object)shape)), 22);
                    this.field_145850_b.func_72863_F().func_212863_j_().func_215568_a(pos);
                }
            }
        }
    }

    public void setController(BlockPos controller) {
        if (this.field_145850_b.field_72995_K && !this.isVirtual()) {
            return;
        }
        if (controller.equals((Object)this.controller)) {
            return;
        }
        this.controller = controller;
        this.refreshCapability();
        this.func_70296_d();
        this.sendData();
    }

    private void refreshCapability() {
        LazyOptional<IFluidHandler> oldCap = this.fluidCapability;
        this.fluidCapability = LazyOptional.of(() -> this.isController() ? this.tankInventory : (this.getControllerTE() != null ? this.getControllerTE().tankInventory : new FluidTank(0)));
        oldCap.invalidate();
    }

    public BlockPos getController() {
        return this.isController() ? this.field_174879_c : this.controller;
    }

    public void updateRenderBoundingBox() {
        this.renderBoundingBox = this.isController() ? super.getRenderBoundingBox().func_72321_a((double)(this.width - 1), (double)(this.height - 1), (double)(this.width - 1)) : super.getRenderBoundingBox();
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderBoundingBox == null) {
            this.renderBoundingBox = super.getRenderBoundingBox();
        }
        return this.renderBoundingBox;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double func_145833_n() {
        int dist = 64 + FluidTankTileEntity.getMaxHeight() * 2;
        return dist * dist;
    }

    @Nullable
    public FluidTankTileEntity getOtherFluidTankTileEntity(Direction direction) {
        TileEntity otherTE = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(direction));
        if (otherTE instanceof FluidTankTileEntity) {
            return (FluidTankTileEntity)otherTE;
        }
        return null;
    }

    @Override
    public boolean addToGoggleTooltip(List<ITextComponent> tooltip, boolean isPlayerSneaking) {
        FluidTankTileEntity controllerTE = this.getControllerTE();
        if (controllerTE == null) {
            return false;
        }
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, controllerTE.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY));
    }

    @Override
    protected void fromTag(BlockState state, CompoundNBT compound, boolean clientPacket) {
        boolean changeOfController;
        super.fromTag(state, compound, clientPacket);
        BlockPos controllerBefore = this.controller;
        int prevSize = this.width;
        int prevHeight = this.height;
        int prevLum = this.luminosity;
        this.updateConnectivity = compound.func_74764_b("Uninitialized");
        this.luminosity = compound.func_74762_e("Luminosity");
        this.controller = null;
        this.lastKnownPos = null;
        if (compound.func_74764_b("LastKnownPos")) {
            this.lastKnownPos = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("LastKnownPos"));
        }
        if (compound.func_74764_b("Controller")) {
            this.controller = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("Controller"));
        }
        if (this.isController()) {
            this.window = compound.func_74767_n("Window");
            this.width = compound.func_74762_e("Size");
            this.height = compound.func_74762_e("Height");
            this.tankInventory.setCapacity(this.getTotalTankSize() * FluidTankTileEntity.getCapacityMultiplier());
            this.tankInventory.readFromNBT(compound.func_74775_l("TankContent"));
            if (this.tankInventory.getSpace() < 0) {
                this.tankInventory.drain(-this.tankInventory.getSpace(), IFluidHandler.FluidAction.EXECUTE);
            }
        }
        if (compound.func_74764_b("ForceFluidLevel") || this.fluidLevel == null) {
            this.fluidLevel = new InterpolatedChasingValue().start(this.getFillState()).withSpeed(0.5f);
        }
        if (!clientPacket) {
            return;
        }
        boolean bl = controllerBefore == null ? this.controller != null : (changeOfController = !controllerBefore.equals((Object)this.controller));
        if (changeOfController || prevSize != this.width || prevHeight != this.height) {
            if (this.func_145830_o()) {
                this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 16);
            }
            if (this.isController()) {
                this.tankInventory.setCapacity(FluidTankTileEntity.getCapacityMultiplier() * this.getTotalTankSize());
            }
            this.updateRenderBoundingBox();
        }
        if (this.isController()) {
            float fillState = this.getFillState();
            if (compound.func_74764_b("ForceFluidLevel") || this.fluidLevel == null) {
                this.fluidLevel = new InterpolatedChasingValue().start(fillState);
            }
            this.fluidLevel.target(fillState);
        }
        if (this.luminosity != prevLum && this.func_145830_o()) {
            this.field_145850_b.func_72863_F().func_212863_j_().func_215568_a(this.field_174879_c);
        }
        if (compound.func_74764_b("LazySync")) {
            this.fluidLevel.withSpeed(compound.func_74764_b("LazySync") ? 0.125f : 0.5f);
        }
    }

    public float getFillState() {
        return (float)this.tankInventory.getFluidAmount() / (float)this.tankInventory.getCapacity();
    }

    @Override
    public void write(CompoundNBT compound, boolean clientPacket) {
        if (this.updateConnectivity) {
            compound.func_74757_a("Uninitialized", true);
        }
        if (this.lastKnownPos != null) {
            compound.func_218657_a("LastKnownPos", (INBT)NBTUtil.func_186859_a((BlockPos)this.lastKnownPos));
        }
        if (!this.isController()) {
            compound.func_218657_a("Controller", (INBT)NBTUtil.func_186859_a((BlockPos)this.controller));
        }
        if (this.isController()) {
            compound.func_74757_a("Window", this.window);
            compound.func_218657_a("TankContent", (INBT)this.tankInventory.writeToNBT(new CompoundNBT()));
            compound.func_74768_a("Size", this.width);
            compound.func_74768_a("Height", this.height);
        }
        compound.func_74768_a("Luminosity", this.luminosity);
        super.write(compound, clientPacket);
        if (!clientPacket) {
            return;
        }
        if (this.forceFluidLevelUpdate) {
            compound.func_74757_a("ForceFluidLevel", true);
        }
        if (this.queuedSync) {
            compound.func_74757_a("LazySync", true);
        }
        this.forceFluidLevelUpdate = false;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (!this.fluidCapability.isPresent()) {
            this.refreshCapability();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
    }

    public IFluidTank getTankInventory() {
        return this.tankInventory;
    }

    public int getTotalTankSize() {
        return this.width * this.width * this.height;
    }

    public static int getMaxSize() {
        return 3;
    }

    public static int getCapacityMultiplier() {
        return (Integer)AllConfigs.SERVER.fluids.fluidTankCapacity.get() * 1000;
    }

    public static int getMaxHeight() {
        return (Integer)AllConfigs.SERVER.fluids.fluidTankMaxHeight.get();
    }

    public InterpolatedChasingValue getFluidLevel() {
        return this.fluidLevel;
    }

    public void setFluidLevel(InterpolatedChasingValue fluidLevel) {
        this.fluidLevel = fluidLevel;
    }
}

