/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.validation;

import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.SpellValidationError;
import javax.annotation.Nullable;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class BaseSpellValidationError
implements SpellValidationError {
    private static final ITextComponent[] NO_ARGS = new ITextComponent[0];
    private final int position;
    private final AbstractSpellPart spellPart;
    private final String localizationCode;
    private final Object[] translationArguments;

    public BaseSpellValidationError(int position, AbstractSpellPart spellPart, String localizationCode, ITextComponent ... translationArguments) {
        this.position = position;
        this.spellPart = spellPart;
        this.localizationCode = localizationCode;
        this.translationArguments = translationArguments;
    }

    public BaseSpellValidationError(int position, AbstractSpellPart spellPart, String localizationCode) {
        this(position, spellPart, localizationCode, NO_ARGS);
    }

    public BaseSpellValidationError(int position, AbstractSpellPart spellPart, String localizationCode, AbstractSpellPart ... spellParts) {
        this(position, spellPart, localizationCode, BaseSpellValidationError.translateGlyphs(spellParts));
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    @Nullable
    public AbstractSpellPart getSpellPart() {
        return this.spellPart;
    }

    @Override
    public IFormattableTextComponent makeTextComponentExisting() {
        return this.makeTextComponent("ars_nouveau.spell.validation.exists.");
    }

    @Override
    public IFormattableTextComponent makeTextComponentAdding() {
        return this.makeTextComponent("ars_nouveau.spell.validation.adding.");
    }

    private IFormattableTextComponent makeTextComponent(String keyPrefix) {
        return new TranslationTextComponent(keyPrefix + this.localizationCode, this.translationArguments);
    }

    private static ITextComponent[] translateGlyphs(AbstractSpellPart ... parts) {
        ITextComponent[] textComponents = new ITextComponent[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            textComponents[i] = new TranslationTextComponent(parts[i].getLocalizationKey());
        }
        return textComponents;
    }
}

