/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.ISpellTier;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.common.entity.EntityAllyVex;
import com.hollingsworth.arsnouveau.common.potions.ModPotions;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;

public class EffectSummonVex
extends AbstractEffect {
    public static EffectSummonVex INSTANCE = new EffectSummonVex();

    private EffectSummonVex() {
        super("summon_vex", "Summon Vex");
    }

    @Override
    public void onResolve(RayTraceResult rayTraceResult, World world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        if (!this.canSummon(shooter)) {
            return;
        }
        Vector3d vector3d = this.safelyGetHitPos(rayTraceResult);
        int ticks = (int)(20.0 * ((double)((Integer)this.GENERIC_INT.get()).intValue() + (double)((Integer)this.EXTEND_TIME.get()).intValue() * spellStats.getDurationMultiplier()));
        BlockPos pos = new BlockPos(vector3d);
        for (int i = 0; i < 3; ++i) {
            BlockPos blockpos = pos.func_177982_a(-2 + shooter.func_70681_au().nextInt(5), 2, -2 + shooter.func_70681_au().nextInt(5));
            EntityAllyVex vexentity = new EntityAllyVex(world, shooter);
            vexentity.func_174828_a(blockpos, 0.0f, 0.0f);
            vexentity.func_213386_a((IServerWorld)world, world.func_175649_E(blockpos), SpawnReason.MOB_SUMMONED, null, null);
            vexentity.setOwner(shooter);
            vexentity.func_190651_g(blockpos);
            vexentity.func_190653_a(ticks);
            world.func_217376_c((Entity)vexentity);
        }
        shooter.func_195064_c(new EffectInstance((Effect)ModPotions.SUMMONING_SICKNESS, ticks));
    }

    @Override
    public void buildConfig(ForgeConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addGenericInt(builder, 15, "Base duration in seconds", "duration");
        this.addExtendTimeConfig(builder, 10);
    }

    @Override
    public int getManaCost() {
        return 150;
    }

    @Override
    @Nullable
    public Item getCraftingReagent() {
        return Items.field_190929_cY;
    }

    @Override
    public ISpellTier.Tier getTier() {
        return ISpellTier.Tier.THREE;
    }

    @Override
    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.SUMMON_AUGMENTS;
    }

    @Override
    public String getBookDescription() {
        return "Summons three Vex allies that will attack nearby hostile enemies. These Vex will last a short time until they begin to take damage, but time may be extended with the Extend Time augment.";
    }

    @Override
    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.CONJURATION);
    }
}

