/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.block.RedstoneAir;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;

public class EffectRedstone
extends AbstractEffect {
    public static EffectRedstone INSTANCE = new EffectRedstone();
    public ForgeConfigSpec.IntValue BONUS_TIME;

    private EffectRedstone() {
        super("redstone_signal", "Redstone Signal");
    }

    @Override
    public void onResolveBlock(BlockRayTraceResult rayTraceResult, World world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        BlockState state = BlockRegistry.REDSTONE_AIR.func_176223_P();
        int signalModifier = (int)spellStats.getAmpMultiplier() + 10;
        if (signalModifier < 1) {
            signalModifier = 1;
        }
        if (signalModifier > 15) {
            signalModifier = 15;
        }
        state = (BlockState)state.func_206870_a((Property)RedstoneAir.POWER, (Comparable)Integer.valueOf(signalModifier));
        BlockPos pos = rayTraceResult.func_216350_a().func_177972_a(rayTraceResult.func_216354_b());
        if (world.func_180495_p(pos).func_185904_a() != Material.field_151579_a || world.func_180495_p(pos).func_177230_c() == BlockRegistry.REDSTONE_AIR) {
            return;
        }
        int timeBonus = (int)spellStats.getDurationMultiplier();
        world.func_175656_a(pos, state);
        world.func_205220_G_().func_205360_a(pos, (Object)state.func_177230_c(), (Integer)this.GENERIC_INT.get() + timeBonus * (Integer)this.BONUS_TIME.get());
        BlockPos hitPos = pos.func_177972_a(rayTraceResult.func_216354_b().func_176734_d());
        BlockUtil.safelyUpdateState(world, pos);
        world.func_195593_d(pos, state.func_177230_c());
        world.func_195593_d(hitPos, state.func_177230_c());
    }

    @Override
    public void buildConfig(ForgeConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addGenericInt(builder, 5, "Base time in ticks", "base_duration");
        this.BONUS_TIME = builder.comment("Extend time bonus, in ticks").defineInRange("extend_time", 10, 0, Integer.MAX_VALUE);
    }

    @Override
    @Nullable
    public Item getCraftingReagent() {
        return Items.field_221858_em;
    }

    @Override
    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentAmplify.INSTANCE, AugmentDampen.INSTANCE, AugmentExtendTime.INSTANCE);
    }

    @Override
    public String getBookDescription() {
        return "Creates a brief redstone signal on a block, like a button. The signal starts at strength 10, and may be increased with Amplify, or decreased with Dampen. The duration may be extended with Extend Time.";
    }

    @Override
    public int getManaCost() {
        return 0;
    }

    @Override
    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.MANIPULATION);
    }
}

