/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.NewChatGui;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketNoSpamChatMessage {
    private final ITextComponent message;
    private final int messageChannelId;
    private final boolean overlayMessage;
    private static final int MESSAGE_ID = "ars_nouveau".hashCode();

    public PacketNoSpamChatMessage(ITextComponent message, int messageChannelId, boolean overlayMessage) {
        this.message = message;
        this.messageChannelId = MESSAGE_ID + messageChannelId;
        this.overlayMessage = overlayMessage;
    }

    public PacketNoSpamChatMessage(PacketBuffer buf) {
        this.message = buf.func_179258_d();
        this.messageChannelId = buf.readInt();
        this.overlayMessage = buf.readBoolean();
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_179256_a(this.message);
        buf.writeInt(this.messageChannelId);
        buf.writeBoolean(this.overlayMessage);
    }

    public void handle(Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> {
            if (this.overlayMessage) {
                if (Minecraft.func_71410_x().field_71439_g != null) {
                    Minecraft.func_71410_x().field_71439_g.func_146105_b(this.message, true);
                }
            } else {
                NewChatGui gui = Minecraft.func_71410_x().field_71456_v.func_146158_b();
                gui.func_146234_a(this.message, this.messageChannelId);
            }
        });
        ctx.setPacketHandled(true);
    }
}

