/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.pathfinding;

import com.hollingsworth.arsnouveau.common.entity.pathfinding.AbstractAdvancedPathNavigate;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.IStuckHandler;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.IStuckHandlerEntity;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class PathingStuckHandler
implements IStuckHandler {
    private static final double MIN_TARGET_DIST = 3.0;
    public static final List<Direction> HORIZONTAL_DIRS = Arrays.asList(Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST);
    private static final int MAX_TP_DELAY = 6000;
    private static final int MIN_DIST_FOR_TP = 10;
    private int teleportRange = 0;
    private int timePerBlockDistance = 200;
    private int stuckLevel = 0;
    private int globalTimeout = 0;
    private BlockPos prevDestination = BlockPos.field_177992_a;
    private boolean canBreakBlocks = false;
    private boolean canPlaceLadders = false;
    private boolean canBuildLeafBridges = false;
    private boolean canTeleportGoal = false;
    private boolean takeDamageOnCompleteStuck = false;
    private float damagePct = 0.2f;
    private int completeStuckBlockBreakRange = 0;
    private boolean hadPath = false;
    private int lastPathIndex = -1;
    private int progressedNodes = 0;
    private int delayBeforeActions;
    private int delayToNextUnstuckAction = this.delayBeforeActions = 200;
    private Random rand = new Random();

    private PathingStuckHandler() {
    }

    public static PathingStuckHandler createStuckHandler() {
        return new PathingStuckHandler();
    }

    @Override
    public void checkStuck(AbstractAdvancedPathNavigate navigator) {
        if (navigator.getDesiredPos() == null || navigator.getDesiredPos().equals((Object)BlockPos.field_177992_a)) {
            this.resetGlobalStuckTimers();
            return;
        }
        if (navigator.getOurEntity() instanceof IStuckHandlerEntity && !((IStuckHandlerEntity)navigator.getOurEntity()).canBeStuck()) {
            return;
        }
        double distanceToGoal = navigator.getOurEntity().func_213303_ch().func_72438_d(new Vector3d((double)navigator.getDesiredPos().func_177958_n(), (double)navigator.getDesiredPos().func_177956_o(), (double)navigator.getDesiredPos().func_177952_p()));
        if (distanceToGoal < 3.0) {
            this.resetGlobalStuckTimers();
            return;
        }
        if (this.prevDestination.equals((Object)navigator.getDesiredPos())) {
            ++this.globalTimeout;
            if ((double)this.globalTimeout > Math.min(6000.0, (double)this.timePerBlockDistance * Math.max(10.0, distanceToGoal))) {
                this.completeStuckAction(navigator);
            }
        } else {
            this.resetGlobalStuckTimers();
        }
        this.prevDestination = navigator.getDesiredPos();
        if (navigator.func_75505_d() == null || navigator.func_75505_d().func_75879_b()) {
            this.lastPathIndex = -1;
            this.progressedNodes = 0;
            if (!this.hadPath) {
                this.tryUnstuck(navigator);
            }
        } else if (navigator.func_75505_d().func_75873_e() == this.lastPathIndex) {
            this.tryUnstuck(navigator);
        } else if (this.lastPathIndex != -1 && navigator.func_75505_d().func_224770_k().func_177951_i((Vector3i)this.prevDestination) < 25.0) {
            int n = this.progressedNodes = navigator.func_75505_d().func_75873_e() > this.lastPathIndex ? this.progressedNodes + 1 : this.progressedNodes - 1;
            if (this.progressedNodes > 5) {
                this.resetStuckTimers();
            }
        }
        this.lastPathIndex = navigator.func_75505_d() != null ? navigator.func_75505_d().func_75873_e() : -1;
        this.hadPath = navigator.func_75505_d() != null && !navigator.func_75505_d().func_75879_b();
    }

    private void resetGlobalStuckTimers() {
        this.globalTimeout = 0;
        this.prevDestination = BlockPos.field_177992_a;
        this.resetStuckTimers();
    }

    private void completeStuckAction(AbstractAdvancedPathNavigate navigator) {
        BlockPos desired = navigator.getDesiredPos();
        World world = navigator.getOurEntity().field_70170_p;
        MobEntity entity = navigator.getOurEntity();
        if (this.canTeleportGoal) {
            for (Direction dir : HORIZONTAL_DIRS) {
                if (!world.func_175623_d(desired.func_177972_a(dir)) || !world.func_175623_d(desired.func_177972_a(dir).func_177984_a())) continue;
                entity.func_70634_a((double)desired.func_177972_a(dir).func_177958_n() + 0.5, (double)desired.func_177972_a(dir).func_177956_o(), (double)desired.func_177972_a(dir).func_177952_p() + 0.5);
                break;
            }
        }
        if (this.takeDamageOnCompleteStuck) {
            entity.func_70097_a((DamageSource)new EntityDamageSource("Stuck-damage", (Entity)entity), entity.func_110138_aP() * this.damagePct);
        }
        if (this.completeStuckBlockBreakRange > 0) {
            Direction facing = PathingStuckHandler.getFacing(new BlockPos(entity.func_213303_ch()), navigator.getDesiredPos());
            for (int i = 1; i <= this.completeStuckBlockBreakRange; ++i) {
                if (world.func_175623_d(new BlockPos(entity.func_213303_ch()).func_177967_a(facing, i)) && world.func_175623_d(new BlockPos(entity.func_213303_ch()).func_177967_a(facing, i).func_177984_a())) continue;
                this.breakBlocksAhead(world, new BlockPos(entity.func_213303_ch()).func_177967_a(facing, i - 1), facing);
                break;
            }
        }
        navigator.func_75499_g();
        this.resetGlobalStuckTimers();
    }

    public static Direction getFacing(BlockPos pos, BlockPos neighbor) {
        BlockPos vector = neighbor.func_177973_b((Vector3i)pos);
        return Direction.func_176737_a((float)vector.func_177958_n(), (float)vector.func_177956_o(), (float)(-vector.func_177952_p()));
    }

    private void tryUnstuck(AbstractAdvancedPathNavigate navigator) {
        if (this.delayToNextUnstuckAction-- > 0) {
            return;
        }
        if (this.stuckLevel == 0) {
            ++this.stuckLevel;
            this.delayToNextUnstuckAction = 600;
            navigator.func_75499_g();
            return;
        }
        if (this.stuckLevel == 2 && this.teleportRange > 0 && this.hadPath) {
            int index = Math.min(navigator.func_75505_d().func_75873_e() + this.teleportRange, navigator.func_75505_d().func_75874_d() - 1);
            PathPoint togo = navigator.func_75505_d().func_75877_a(index);
            navigator.getOurEntity().func_70634_a((double)togo.field_75839_a + 0.5, (double)togo.field_75837_b, (double)togo.field_75838_c + 0.5);
            this.delayToNextUnstuckAction = 300;
        }
        this.chanceStuckLevel();
        if (this.stuckLevel == 8) {
            this.resetStuckTimers();
        }
    }

    private void chanceStuckLevel() {
        ++this.stuckLevel;
        if (this.stuckLevel > 1 && this.rand.nextInt(6) == 0) {
            this.stuckLevel -= 2;
        }
    }

    private void resetStuckTimers() {
        this.delayToNextUnstuckAction = this.delayBeforeActions;
        this.lastPathIndex = -1;
        this.progressedNodes = 0;
        this.stuckLevel = 0;
    }

    private void breakBlocksAhead(World world, BlockPos start, Direction facing) {
        if (!world.func_175623_d(start.func_177981_b(3))) {
            this.setAirIfPossible(world, start.func_177981_b(3));
            return;
        }
        if (!world.func_175623_d(start.func_177972_a(facing))) {
            this.setAirIfPossible(world, start.func_177972_a(facing));
            return;
        }
        if (!world.func_175623_d(start.func_177984_a().func_177972_a(facing))) {
            this.setAirIfPossible(world, start.func_177984_a().func_177972_a(facing));
        }
    }

    private void setAirIfPossible(World world, BlockPos pos) {
        Block blockAtPos = world.func_180495_p(pos).func_177230_c();
        world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
    }

    public PathingStuckHandler withTeleportSteps(int steps) {
        this.teleportRange = steps;
        return this;
    }

    public PathingStuckHandler withTeleportOnFullStuck() {
        this.canTeleportGoal = true;
        return this;
    }

    public PathingStuckHandler withTakeDamageOnStuck(float damagePct) {
        this.damagePct = damagePct;
        this.takeDamageOnCompleteStuck = true;
        return this;
    }

    public PathingStuckHandler withTimePerBlockDistance(int time) {
        this.timePerBlockDistance = time;
        return this;
    }

    public PathingStuckHandler withDelayBeforeStuckActions(int delay) {
        this.delayBeforeActions = delay;
        return this;
    }

    public PathingStuckHandler withCompleteStuckBlockBreak(int range) {
        this.completeStuckBlockBreakRange = range;
        return this;
    }
}

