/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.pathfinding;

import com.hollingsworth.arsnouveau.common.entity.pathfinding.Node;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.PathingConstants;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.pathjobs.AbstractPathJob;
import com.hollingsworth.arsnouveau.common.util.Log;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class Pathfinding {
    private static final BlockingQueue<Runnable> jobQueue = new LinkedBlockingDeque<Runnable>();
    private static ThreadPoolExecutor executor;

    public static ThreadPoolExecutor getExecutor() {
        if (executor == null) {
            executor = new ThreadPoolExecutor(1, 1, 10L, TimeUnit.SECONDS, jobQueue, new MinecoloniesThreadFactory());
        }
        return executor;
    }

    public static void shutdown() {
        Pathfinding.getExecutor().shutdownNow();
        jobQueue.clear();
        executor = null;
    }

    private Pathfinding() {
    }

    public static void enqueue(AbstractPathJob job) {
        job.getResult().startJob(Pathfinding.getExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnlyIn(value=Dist.CLIENT)
    public static void debugDraw(double frame, MatrixStack matrixStack) {
        Set<Node> debugNodesPath;
        Set<Node> debugNodesVisited;
        Set<Node> debugNodesNotVisited;
        if (AbstractPathJob.lastDebugNodesNotVisited == null) {
            return;
        }
        Vector3d vec = Minecraft.func_71410_x().func_175598_ae().field_217783_c.func_216785_c();
        double dx = vec.func_82615_a();
        double dy = vec.func_82617_b();
        double dz = vec.func_82616_c();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(-dx, -dy, -dz);
        RenderSystem.enableDepthTest();
        RenderSystem.disableTexture();
        RenderSystem.disableBlend();
        RenderSystem.disableLighting();
        Iterator<Node> iterator = PathingConstants.debugNodeMonitor;
        synchronized (iterator) {
            debugNodesNotVisited = AbstractPathJob.lastDebugNodesNotVisited;
            debugNodesVisited = AbstractPathJob.lastDebugNodesVisited;
            debugNodesPath = AbstractPathJob.lastDebugNodesPath;
        }
        try {
            for (Node n : debugNodesNotVisited) {
                Pathfinding.debugDrawNode(n, 1.0f, 0.0f, 0.0f, matrixStack);
            }
            for (Node n : debugNodesVisited) {
                Pathfinding.debugDrawNode(n, 0.0f, 0.0f, 1.0f, matrixStack);
            }
            for (Node n : debugNodesPath) {
                if (n.isReachedByWorker()) {
                    Pathfinding.debugDrawNode(n, 1.0f, 0.4f, 0.0f, matrixStack);
                    continue;
                }
                Pathfinding.debugDrawNode(n, 0.0f, 1.0f, 0.0f, matrixStack);
            }
        }
        catch (ConcurrentModificationException exc) {
            Log.getLogger().catching((Throwable)exc);
        }
        RenderSystem.disableDepthTest();
        RenderSystem.enableTexture();
        RenderSystem.enableBlend();
        RenderSystem.enableLighting();
        matrixStack.func_227865_b_();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void debugDrawNode(Node n, float r, float g, float b, MatrixStack matrixStack) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)n.pos.func_177958_n() + 0.375, (double)n.pos.func_177956_o() + 0.375, (double)n.pos.func_177952_p() + 0.375);
        Entity entity = Minecraft.func_71410_x().func_175606_aa();
        double dx = (double)n.pos.func_177958_n() - entity.func_226277_ct_();
        double dy = (double)n.pos.func_177956_o() - entity.func_226278_cu_();
        double dz = (double)n.pos.func_177952_p() - entity.func_226281_cx_();
        if (Math.sqrt(dx * dx + dy * dy + dz * dz) <= 5.0) {
            Pathfinding.renderDebugText(n, matrixStack);
        }
        matrixStack.func_227862_a_(0.25f, 0.25f, 0.25f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        RenderSystem.color3f((float)r, (float)g, (float)b);
        vertexBuffer.func_227888_a_(matrix4f, 1.0f, 0.0f, 0.0f).func_181675_d();
        vertexBuffer.func_227888_a_(matrix4f, 1.0f, 1.0f, 0.0f).func_181675_d();
        vertexBuffer.func_227888_a_(matrix4f, 1.0f, 1.0f, 1.0f).func_181675_d();
        vertexBuffer.func_227888_a_(matrix4f, 1.0f, 0.0f, 1.0f).func_181675_d();
        vertexBuffer.func_227888_a_(matrix4f, 0.0f, 0.0f, 1.0f).func_181675_d();
        vertexBuffer.func_227888_a_(matrix4f, 0.0f, 1.0f, 1.0f).func_181675_d();
        vertexBuffer.func_227888_a_(matrix4f, 0.0f, 1.0f, 0.0f).func_181675_d();
        vertexBuffer.func_227888_a_(matrix4f, 0.0f, 0.0f, 0.0f).func_181675_d();
        vertexBuffer.func_227888_a_(matrix4f, 0.0f, 0.0f, 0.0f).func_181675_d();
        vertexBuffer.func_227888_a_(matrix4f, 0.0f, 1.0f, 0.0f).func_181675_d();
        vertexBuffer.func_227888_a_(matrix4f, 1.0f, 1.0f, 0.0f).func_181675_d();
        vertexBuffer.func_227888_a_(matrix4f, 1.0f, 0.0f, 0.0f).func_181675_d();
        vertexBuffer.func_227888_a_(matrix4f, 1.0f, 0.0f, 1.0f).func_181675_d();
        vertexBuffer.func_227888_a_(matrix4f, 1.0f, 1.0f, 1.0f).func_181675_d();
        vertexBuffer.func_227888_a_(matrix4f, 0.0f, 1.0f, 1.0f).func_181675_d();
        vertexBuffer.func_227888_a_(matrix4f, 0.0f, 0.0f, 1.0f).func_181675_d();
        vertexBuffer.func_227888_a_(matrix4f, 1.0f, 1.0f, 1.0f).func_181675_d();
        vertexBuffer.func_227888_a_(matrix4f, 1.0f, 1.0f, 0.0f).func_181675_d();
        vertexBuffer.func_227888_a_(matrix4f, 0.0f, 1.0f, 0.0f).func_181675_d();
        vertexBuffer.func_227888_a_(matrix4f, 0.0f, 1.0f, 1.0f).func_181675_d();
        vertexBuffer.func_227888_a_(matrix4f, 0.0f, 0.0f, 1.0f).func_181675_d();
        vertexBuffer.func_227888_a_(matrix4f, 0.0f, 0.0f, 0.0f).func_181675_d();
        vertexBuffer.func_227888_a_(matrix4f, 1.0f, 0.0f, 0.0f).func_181675_d();
        vertexBuffer.func_227888_a_(matrix4f, 1.0f, 0.0f, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        if (n.parent != null) {
            float pdx = (float)(n.parent.pos.func_177958_n() - n.pos.func_177958_n()) + 0.125f;
            float pdy = (float)(n.parent.pos.func_177956_o() - n.pos.func_177956_o()) + 0.125f;
            float pdz = (float)(n.parent.pos.func_177952_p() - n.pos.func_177952_p()) + 0.125f;
            vertexBuffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
            vertexBuffer.func_227888_a_(matrix4f, 0.5f, 0.5f, 0.5f).func_227885_a_(0.75f, 0.75f, 0.75f, 1.0f).func_181675_d();
            vertexBuffer.func_227888_a_(matrix4f, pdx / 0.25f, pdy / 0.25f, pdz / 0.25f).func_227885_a_(0.75f, 0.75f, 0.75f, 1.0f).func_181675_d();
            tessellator.func_78381_a();
        }
        matrixStack.func_227865_b_();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void renderDebugText(Node n, MatrixStack matrixStack) {
        String s1 = String.format("F: %.3f [%d]", n.getCost(), n.getCounterAdded());
        String s2 = String.format("G: %.3f [%d]", n.getScore(), n.getCounterVisited());
        FontRenderer fontrenderer = Minecraft.func_71410_x().field_71466_p;
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.75, 0.0);
        RenderSystem.normal3f((float)0.0f, (float)1.0f, (float)0.0f);
        EntityRendererManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        matrixStack.func_227863_a_(renderManager.func_229098_b_());
        matrixStack.func_227862_a_(-0.014f, -0.014f, 0.014f);
        matrixStack.func_227861_a_(0.0, 18.0, 0.0);
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.disableTexture();
        int i = Math.max(fontrenderer.func_78256_a(s1), fontrenderer.func_78256_a(s2)) / 2;
        Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        vertexBuffer.func_227888_a_(matrix4f, (float)(-i - 1), -5.0f, 0.0f).func_227885_a_(0.0f, 0.0f, 0.0f, 0.7f).func_181675_d();
        vertexBuffer.func_227888_a_(matrix4f, (float)(-i - 1), 12.0f, 0.0f).func_227885_a_(0.0f, 0.0f, 0.0f, 0.7f).func_181675_d();
        vertexBuffer.func_227888_a_(matrix4f, (float)(i + 1), 12.0f, 0.0f).func_227885_a_(0.0f, 0.0f, 0.0f, 0.7f).func_181675_d();
        vertexBuffer.func_227888_a_(matrix4f, (float)(i + 1), -5.0f, 0.0f).func_227885_a_(0.0f, 0.0f, 0.0f, 0.7f).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.enableTexture();
        IRenderTypeBuffer.Impl buffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        matrixStack.func_227861_a_(0.0, -5.0, 0.0);
        fontrenderer.func_228079_a_(s1, (float)(-fontrenderer.func_78256_a(s1)) / 2.0f, 0.0f, -1, false, matrix4f, (IRenderTypeBuffer)buffer, false, 0, 0xF000F0);
        matrixStack.func_227861_a_(0.0, 8.0, 0.0);
        fontrenderer.func_228079_a_(s2, (float)(-fontrenderer.func_78256_a(s2)) / 2.0f, 0.0f, -1, false, matrix4f, (IRenderTypeBuffer)buffer, false, 0, 0xF000F0);
        RenderSystem.depthMask((boolean)true);
        matrixStack.func_227861_a_(0.0, -8.0, 0.0);
        fontrenderer.func_228079_a_(s1, (float)(-fontrenderer.func_78256_a(s1)) / 2.0f, 0.0f, -1, false, matrix4f, (IRenderTypeBuffer)buffer, false, 0, 0xF000F0);
        matrixStack.func_227861_a_(0.0, 8.0, 0.0);
        fontrenderer.func_228079_a_(s2, (float)(-fontrenderer.func_78256_a(s2)) / 2.0f, 0.0f, -1, false, matrix4f, (IRenderTypeBuffer)buffer, false, 0, 0xF000F0);
        buffer.func_228461_a_();
        matrixStack.func_227865_b_();
    }

    public static class MinecoloniesThreadFactory
    implements ThreadFactory {
        public static int id;

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable, "Minecolonies Pathfinding Worker #" + id++);
            thread.setDaemon(true);
            thread.setUncaughtExceptionHandler((thread1, throwable) -> Log.getLogger().error("Minecolonies Pathfinding Thread errored! ", throwable));
            return thread;
        }
    }
}

