/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.api.spell.ILightable;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.util.ManaUtil;
import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.RitualBlock;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class RitualTile
extends TileEntity
implements ITickableTileEntity,
ITooltipProvider,
IAnimatable,
ILightable {
    public AbstractRitual ritual;
    AnimationFactory manager = new AnimationFactory((IAnimatable)this);
    public boolean isDecorative;
    int red;
    int blue;
    int green;
    public boolean isOff;

    public RitualTile() {
        super(BlockRegistry.RITUAL_TILE);
    }

    public void makeParticle(ParticleColor centerColor, ParticleColor outerColor, int intensity) {
        int i;
        World world = this.func_145831_w();
        BlockPos pos = this.func_174877_v();
        Random rand = world.field_73012_v;
        double xzOffset = 0.25;
        for (i = 0; i < intensity; ++i) {
            world.func_195594_a(GlowParticleData.createData(centerColor), (double)pos.func_177958_n() + 0.5 + ParticleUtil.inRange(-xzOffset / 2.0, xzOffset / 2.0), (double)(pos.func_177956_o() + 1) + ParticleUtil.inRange(-0.05, 0.2), (double)pos.func_177952_p() + 0.5 + ParticleUtil.inRange(-xzOffset / 2.0, xzOffset / 2.0), 0.0, ParticleUtil.inRange(0.0, 0.05f), 0.0);
        }
        for (i = 0; i < intensity; ++i) {
            world.func_195594_a(GlowParticleData.createData(outerColor), (double)pos.func_177958_n() + 0.5 + ParticleUtil.inRange(-xzOffset, xzOffset), (double)(pos.func_177956_o() + 1) + ParticleUtil.inRange(0.0, 0.7), (double)pos.func_177952_p() + 0.5 + ParticleUtil.inRange(-xzOffset, xzOffset), 0.0, ParticleUtil.inRange(0.0, 0.05f), 0.0);
        }
    }

    public void func_73660_a() {
        if (this.isDecorative && this.field_145850_b.field_72995_K) {
            this.makeParticle(ParticleColor.makeRandomColor(this.red, this.green, this.blue, this.field_145850_b.field_73012_v), ParticleColor.makeRandomColor(this.red, this.green, this.blue, this.field_145850_b.field_73012_v), 50);
            return;
        }
        if (this.field_145850_b.field_72995_K && this.ritual != null) {
            this.makeParticle(this.ritual.getCenterColor(), this.ritual.getOuterColor(), this.ritual.getParticleIntensity());
        }
        if (this.isOff) {
            return;
        }
        if (this.ritual != null) {
            if (this.ritual.getContext().isDone) {
                this.ritual.onEnd();
                this.ritual = null;
                this.func_145831_w().func_184133_a(null, this.func_174877_v(), SoundEvents.field_187646_bt, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                this.func_145831_w().func_180501_a(this.func_174877_v(), (BlockState)this.func_145831_w().func_180495_p(this.func_174877_v()).func_206870_a(RitualBlock.LIT, (Comparable)Boolean.valueOf(false)), 3);
                return;
            }
            if (!this.ritual.isRunning() && !this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_217357_a(ItemEntity.class, new AxisAlignedBB(this.func_174877_v()).func_186662_g(1.0)).forEach(i -> {
                    if (this.ritual.canConsumeItem(i.func_92059_d())) {
                        this.ritual.onItemConsumed(i.func_92059_d());
                        ParticleUtil.spawnPoof((ServerWorld)this.field_145850_b, i.func_233580_cy_());
                    }
                });
            }
            if (this.ritual.consumesMana() && this.ritual.needsManaNow()) {
                int cost = this.ritual.getManaCost();
                if (ManaUtil.takeManaNearbyWithParticles(this.func_174877_v(), this.func_145831_w(), 6, cost) != null) {
                    this.ritual.setNeedsMana(false);
                } else {
                    return;
                }
            }
            this.ritual.tryTick();
        }
    }

    public boolean isRitualDone() {
        return this.ritual != null && this.ritual.getContext().isDone;
    }

    public boolean canRitualStart() {
        return this.ritual.canStart();
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 3, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(this.field_145850_b.func_180495_p(this.field_174879_c), pkt.func_148857_g());
    }

    public void startRitual() {
        if (this.ritual == null || !this.ritual.canStart() || this.ritual.isRunning()) {
            return;
        }
        this.func_145831_w().func_184133_a(null, this.func_174877_v(), SoundEvents.field_193784_dd, SoundCategory.NEUTRAL, 1.0f, 1.0f);
        this.ritual.onStart();
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        String ritualID = tag.func_74779_i("ritualID");
        if (!ritualID.isEmpty()) {
            this.ritual = ArsNouveauAPI.getInstance().getRitual(ritualID);
            if (this.ritual != null) {
                this.ritual.read(tag);
                this.ritual.tile = this;
            }
        } else {
            this.ritual = null;
        }
        this.red = tag.func_74762_e("red");
        this.red = this.red > 0 ? this.red : 255;
        this.green = tag.func_74762_e("green");
        this.green = this.green > 0 ? this.green : 125;
        this.blue = tag.func_74762_e("blue");
        this.blue = this.blue > 0 ? this.blue : 255;
        this.isDecorative = tag.func_74767_n("decorative");
        this.isOff = tag.func_74767_n("off");
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        if (this.ritual != null) {
            tag.func_74778_a("ritualID", this.ritual.getID());
            this.ritual.write(tag);
        } else {
            tag.func_82580_o("ritualID");
        }
        tag.func_74768_a("red", this.red);
        tag.func_74768_a("green", this.green);
        tag.func_74768_a("blue", this.blue);
        tag.func_74757_a("decorative", this.isDecorative);
        tag.func_74757_a("off", this.isOff);
        return super.func_189515_b(tag);
    }

    public void setRitual(String selectedRitual) {
        this.ritual = ArsNouveauAPI.getInstance().getRitual(selectedRitual);
        if (this.ritual != null) {
            this.ritual.tile = this;
            World world = this.func_145831_w();
            BlockState state = world.func_180495_p(this.func_174877_v());
            world.func_180501_a(this.func_174877_v(), (BlockState)state.func_206870_a(RitualBlock.LIT, (Comparable)Boolean.valueOf(true)), 3);
        }
        this.isDecorative = false;
        this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundEvents.field_187649_bu, SoundCategory.NEUTRAL, 1.0f, 1.0f);
    }

    @Override
    public List<String> getTooltip() {
        ArrayList<String> tooltips = new ArrayList<String>();
        if (this.ritual != null) {
            tooltips.add(this.ritual.getName());
            if (this.isOff) {
                tooltips.add(new TranslationTextComponent("ars_nouveau.tooltip.turned_off").getString());
                return tooltips;
            }
            if (!this.ritual.isRunning()) {
                if (!this.ritual.canStart()) {
                    tooltips.add(new TranslationTextComponent("ars_nouveau.tooltip.conditions_unmet").getString());
                } else {
                    tooltips.add(new TranslationTextComponent("ars_nouveau.tooltip.waiting").getString());
                }
            } else {
                tooltips.add(new TranslationTextComponent("ars_nouveau.tooltip.running").getString());
            }
            if (this.ritual.getConsumedItems().size() != 0) {
                tooltips.add(new TranslationTextComponent("ars_nouveau.tooltip.consumed").getString());
                for (ItemStack i : this.ritual.getConsumedItems()) {
                    tooltips.add(i.func_200301_q().getString());
                }
            }
            if (this.ritual.needsManaNow()) {
                tooltips.add(new TranslationTextComponent("ars_nouveau.wixie.need_mana").getString());
            }
        }
        return tooltips;
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "idle", 0.0f, this::idlePredicate));
    }

    private <P extends IAnimatable> PlayState idlePredicate(AnimationEvent<P> pAnimationEvent) {
        pAnimationEvent.getController().setAnimation(new AnimationBuilder().addAnimation("gem_float", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.manager;
    }

    @Override
    public void onLight(RayTraceResult rayTraceResult, World world, LivingEntity shooter, SpellStats stats, SpellContext spellContext) {
        this.red = spellContext.colors.r;
        this.green = spellContext.colors.g;
        this.blue = spellContext.colors.b;
        this.isDecorative = true;
        BlockState state = world.func_180495_p(this.func_174877_v());
        world.func_180501_a(this.func_174877_v(), (BlockState)state.func_206870_a(RitualBlock.LIT, (Comparable)Boolean.valueOf(true)), 3);
    }
}

