/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.google.common.collect.ImmutableList;
import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.recipe.GlyphPressRecipe;
import com.hollingsworth.arsnouveau.api.spell.ISpellTier;
import com.hollingsworth.arsnouveau.api.util.ManaUtil;
import com.hollingsworth.arsnouveau.common.block.tile.AnimatedTile;
import com.hollingsworth.arsnouveau.common.block.tile.IAnimationListener;
import com.hollingsworth.arsnouveau.common.block.tile.ManaJarTile;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketOneShotAnimation;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class GlyphPressTile
extends AnimatedTile
implements ITickableTileEntity,
IAnimatable,
IAnimationListener,
ISidedInventory {
    private final Map<Direction, LazyOptional<IItemHandler>> itemHandlers = new HashMap<Direction, LazyOptional<IItemHandler>>();
    public long frames = 0L;
    public boolean isCrafting;
    public ItemStack reagentItem = ItemStack.field_190927_a;
    public ItemStack baseMaterial = ItemStack.field_190927_a;
    public ItemStack oldBaseMat = ItemStack.field_190927_a;
    public ItemEntity entity;
    AnimationFactory manager = new AnimationFactory((IAnimatable)this);

    public GlyphPressTile() {
        super(BlockRegistry.GLYPH_PRESS_TILE);
        ImmutableList.of((Object)Direction.UP, (Object)Direction.NORTH, (Object)Direction.SOUTH, (Object)Direction.EAST, (Object)Direction.WEST).forEach(this::addItemHandler);
        this.addItemHandler(null);
    }

    public void func_73660_a() {
        GlyphPressRecipe recipe;
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 20L == 0L && this.canCraft(this.reagentItem, this.baseMaterial)) {
            this.craft((PlayerEntity)FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)this.field_145850_b)));
        }
        if (this.field_145850_b.field_72995_K || !this.isCrafting) {
            return;
        }
        ++this.counter;
        if (this.counter == 110) {
            recipe = ArsNouveauAPI.getInstance().getGlyphPressRecipe(this.field_145850_b, this.reagentItem.func_77973_b(), this.getTier(this.baseMaterial.func_77973_b()));
            this.oldBaseMat = this.baseMaterial.func_77946_l();
            this.baseMaterial = recipe.output.func_77946_l();
            this.updateBlock();
        }
        if (this.counter == 150) {
            this.isCrafting = false;
            recipe = ArsNouveauAPI.getInstance().getGlyphPressRecipe(this.field_145850_b, this.reagentItem.func_77973_b(), this.getTier(this.oldBaseMat.func_77973_b()));
            if (recipe == null) {
                return;
            }
            ItemStack stack = recipe.output.func_77946_l();
            if (!stack.func_190926_b()) {
                this.field_145850_b.func_217376_c((Entity)new ItemEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5, stack));
            }
            this.reagentItem = ItemStack.field_190927_a;
            this.baseMaterial = ItemStack.field_190927_a;
            this.oldBaseMat = ItemStack.field_190927_a;
            this.counter = 1;
        }
        this.updateBlock();
    }

    @Override
    public void updateBlock() {
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 2);
    }

    public boolean craft(PlayerEntity playerEntity) {
        if (this.isCrafting || this.baseMaterial == ItemStack.field_190927_a) {
            return false;
        }
        GlyphPressRecipe recipe = ArsNouveauAPI.getInstance().getGlyphPressRecipe(this.field_145850_b, this.reagentItem.func_77973_b(), this.getTier(this.baseMaterial.func_77973_b()));
        if (recipe == null) {
            return false;
        }
        int manaCost = recipe.tier == ISpellTier.Tier.ONE ? 1000 : (recipe.tier == ISpellTier.Tier.TWO ? 2000 : 3000);
        BlockPos jar = ManaUtil.takeManaNearbyWithParticles(this.field_174879_c, this.field_145850_b, 5, manaCost);
        if (jar != null) {
            this.isCrafting = true;
            Networking.sendToNearby(this.field_145850_b, this.field_174879_c, (Object)new PacketOneShotAnimation(this.field_174879_c));
            return true;
        }
        playerEntity.func_145747_a((ITextComponent)new TranslationTextComponent("ars_nouveau.glyph_press.no_mana"), Util.field_240973_b_);
        return false;
    }

    public ISpellTier.Tier getTier(Item clay) {
        if (clay == ItemsRegistry.magicClay) {
            return ISpellTier.Tier.ONE;
        }
        if (clay == ItemsRegistry.marvelousClay) {
            return ISpellTier.Tier.TWO;
        }
        if (clay == ItemsRegistry.mythicalClay) {
            return ISpellTier.Tier.THREE;
        }
        return null;
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "controller", 1.0f, this::idlePredicate));
    }

    public AnimationFactory getFactory() {
        return this.manager;
    }

    private <E extends TileEntity> PlayState idlePredicate(AnimationEvent<E> event) {
        return PlayState.CONTINUE;
    }

    @Override
    public void startAnimation(int arg) {
        AnimationData data = this.manager.getOrCreateAnimationData(Integer.valueOf(this.hashCode()));
        data.setResetSpeedInTicks(0.0);
        AnimationController controller = (AnimationController)data.getAnimationControllers().get("controller");
        controller.markNeedsReload();
        controller.setAnimation(new AnimationBuilder().addAnimation("press", Boolean.valueOf(false)));
    }

    public int func_70302_i_() {
        return 2;
    }

    public boolean func_191420_l() {
        return this.reagentItem.func_190926_b() && this.baseMaterial.func_190926_b();
    }

    public ItemStack func_70301_a(int index) {
        return index == 0 ? this.reagentItem : (index == 1 ? this.baseMaterial : ItemStack.field_190927_a);
    }

    public ItemStack func_70298_a(int index, int count) {
        if (index == 0) {
            ItemStack stack = this.reagentItem.func_77946_l();
            stack.func_190920_e(count);
            this.reagentItem.func_190918_g(count);
            this.updateBlock();
            return stack;
        }
        if (index == 1) {
            ItemStack stack = this.baseMaterial.func_77946_l();
            stack.func_190918_g(count);
            this.baseMaterial.func_190918_g(count);
            this.updateBlock();
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = this.reagentItem.func_77946_l();
        this.reagentItem.func_190920_e(0);
        return stack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (index == 0) {
            this.reagentItem = stack;
        }
        if (index == 1) {
            this.baseMaterial = stack;
        }
        this.updateBlock();
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(PlayerEntity player) {
        return true;
    }

    public void func_174888_l() {
        this.reagentItem = ItemStack.field_190927_a;
        this.baseMaterial = ItemStack.field_190927_a;
    }

    public int[] func_180463_a(Direction side) {
        int[] nArray;
        if (side == Direction.UP) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else if (side != Direction.DOWN) {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 1;
        } else {
            nArray = new int[]{};
        }
        return nArray;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        if (this.isCrafting) {
            return false;
        }
        if (index == 0 && this.reagentItem.func_190926_b() && direction == Direction.UP) {
            return this.canCraft(itemStackIn, this.baseMaterial);
        }
        if (index == 1 && direction != Direction.UP && direction != Direction.DOWN && this.baseMaterial.func_190926_b()) {
            return this.getTier(itemStackIn.func_77973_b()) != null;
        }
        return false;
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return false;
    }

    public boolean canCraft(ItemStack reagent, ItemStack base) {
        if (reagent.func_190926_b() || base.func_190926_b()) {
            return false;
        }
        GlyphPressRecipe recipe = ArsNouveauAPI.getInstance().getGlyphPressRecipe(this.field_145850_b, reagent.func_77973_b(), this.getTier(base.func_77973_b()));
        if (recipe == null) {
            return false;
        }
        int manaCost = recipe.tier == ISpellTier.Tier.ONE ? 500 : (recipe.tier == ISpellTier.Tier.TWO ? 1500 : 3000);
        AtomicBoolean valid = new AtomicBoolean(false);
        BlockPos.func_218281_b((BlockPos)this.func_174877_v().func_177982_a(5, -3, 5), (BlockPos)this.func_174877_v().func_177982_a(-5, 3, -5)).forEach(blockPos -> {
            if (!valid.get() && this.field_145850_b.func_175625_s(blockPos) instanceof ManaJarTile && ((ManaJarTile)this.field_145850_b.func_175625_s(blockPos)).getCurrentMana() >= manaCost) {
                valid.set(true);
            }
        });
        return valid.get();
    }

    private void addItemHandler(@Nullable Direction side) {
        this.itemHandlers.put(side, (LazyOptional<IItemHandler>)LazyOptional.of(() -> new SidedInvWrapper((ISidedInventory)this, side)));
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandlers.getOrDefault(side, (LazyOptional<IItemHandler>)super.getCapability(cap, side).cast()).cast();
        }
        return super.getCapability(cap, side);
    }

    protected void invalidateCaps() {
        this.itemHandlers.values().forEach(LazyOptional::invalidate);
        super.invalidateCaps();
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        this.reagentItem = ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)compound.func_74781_a("itemStack")));
        this.baseMaterial = ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)compound.func_74781_a("baseMat")));
        this.oldBaseMat = ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)compound.func_74781_a("oldBase")));
        this.isCrafting = compound.func_74767_n("crafting");
        super.func_230337_a_(state, compound);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        CompoundNBT baseMatTag;
        if (this.reagentItem != null) {
            CompoundNBT reagentTag = new CompoundNBT();
            this.reagentItem.func_77955_b(reagentTag);
            compound.func_218657_a("itemStack", (INBT)reagentTag);
        }
        if (this.baseMaterial != null) {
            baseMatTag = new CompoundNBT();
            this.baseMaterial.func_77955_b(baseMatTag);
            compound.func_218657_a("baseMat", (INBT)baseMatTag);
        }
        if (this.oldBaseMat != null) {
            baseMatTag = new CompoundNBT();
            this.oldBaseMat.func_77955_b(baseMatTag);
            compound.func_218657_a("oldBase", (INBT)baseMatTag);
        }
        compound.func_74757_a("crafting", this.isCrafting);
        return super.func_189515_b(compound);
    }
}

