/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.particle;

import com.hollingsworth.arsnouveau.client.particle.ModParticles;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;

public class ColoredDynamicTypeData
implements IParticleData {
    private ParticleType<ColoredDynamicTypeData> type;
    public ParticleColor color;
    float scale;
    int age;
    public static final Codec<ColoredDynamicTypeData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("r").forGetter(d -> Float.valueOf(d.color.getRed())), (App)Codec.FLOAT.fieldOf("g").forGetter(d -> Float.valueOf(d.color.getGreen())), (App)Codec.FLOAT.fieldOf("b").forGetter(d -> Float.valueOf(d.color.getBlue())), (App)Codec.FLOAT.fieldOf("scale").forGetter(d -> Float.valueOf(d.scale)), (App)Codec.INT.fieldOf("age").forGetter(d -> d.age)).apply((Applicative)instance, ColoredDynamicTypeData::new));
    static final IParticleData.IDeserializer<ColoredDynamicTypeData> DESERIALIZER = new IParticleData.IDeserializer<ColoredDynamicTypeData>(){

        public ColoredDynamicTypeData fromCommand(ParticleType<ColoredDynamicTypeData> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            return new ColoredDynamicTypeData(type, ParticleColor.deserialize(reader.readString()), reader.readFloat(), reader.readInt());
        }

        public ColoredDynamicTypeData fromNetwork(ParticleType<ColoredDynamicTypeData> type, PacketBuffer buffer) {
            return new ColoredDynamicTypeData(type, ParticleColor.deserialize(buffer.func_218666_n()), buffer.readFloat(), buffer.readInt());
        }
    };

    public ParticleType<?> func_197554_b() {
        return this.type;
    }

    public ColoredDynamicTypeData(float r, float g, float b, float scale, int age) {
        this.type = ModParticles.LINE_TYPE;
        this.color = new ParticleColor(r, g, b);
        this.scale = scale;
        this.age = age;
    }

    public ColoredDynamicTypeData(ParticleType<ColoredDynamicTypeData> particleTypeData, ParticleColor color, float scale, int age) {
        this.type = particleTypeData;
        this.color = color;
        this.scale = scale;
        this.age = age;
    }

    public void func_197553_a(PacketBuffer buffer) {
        buffer.func_180714_a(this.color.serialize());
        buffer.writeFloat(this.scale);
        buffer.writeInt(this.age);
    }

    public String func_197555_a() {
        return this.type.getRegistryName().toString() + " " + this.color.serialize() + " " + this.scale + " " + this.age;
    }
}

