/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.event;

import com.hollingsworth.arsnouveau.api.event.ITimedEvent;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import javax.annotation.Nullable;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class DelayedSpellEvent
implements ITimedEvent {
    private int duration;
    private final Spell spell;
    private final SpellContext context;
    private final RayTraceResult result;
    private final World world;
    @Nullable
    private final LivingEntity shooter;

    public DelayedSpellEvent(int delay, Spell spell, RayTraceResult result, World world, @Nullable LivingEntity shooter, SpellContext context) {
        this.duration = delay;
        this.spell = spell;
        this.result = result;
        this.world = world;
        this.shooter = shooter;
        this.context = context;
    }

    @Override
    public void tick(boolean serverSide) {
        --this.duration;
        if (this.duration <= 0 && serverSide) {
            this.resolveSpell();
        } else if (!serverSide && this.result != null) {
            BlockPos hitVec = this.result instanceof EntityRayTraceResult ? ((EntityRayTraceResult)this.result).func_216348_a().func_233580_cy_() : new BlockPos(this.result.func_216347_e());
            ParticleUtil.spawnTouch((ClientWorld)this.world, hitVec, this.context.colors.toParticleColor());
        }
    }

    public void resolveSpell() {
        if (this.world == null) {
            return;
        }
        SpellResolver.resolveEffects(this.world, this.shooter, this.result, this.spell, this.context);
    }

    @Override
    public boolean isExpired() {
        return this.duration <= 0 || this.world == null;
    }
}

