/*
 * Decompiled with CFR 0.152.
 */
package owmii.losttrinkets.client.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;
import owmii.lib.client.screen.widget.IconButton;
import owmii.losttrinkets.LostTrinkets;
import owmii.losttrinkets.api.LostTrinketsAPI;
import owmii.losttrinkets.api.trinket.ITrinket;
import owmii.losttrinkets.api.trinket.Trinkets;
import owmii.losttrinkets.client.screen.AbstractLTScreen;
import owmii.losttrinkets.client.screen.AvailableTrinketsScreen;
import owmii.losttrinkets.client.screen.Textures;
import owmii.losttrinkets.client.screen.TrinketOptionScreen;
import owmii.losttrinkets.client.screen.widget.TrinketButton;
import owmii.losttrinkets.config.Configs;
import owmii.losttrinkets.network.packet.UnlockSlotPacket;

public class TrinketsScreen
extends AbstractLTScreen {
    private int x;
    private int y;
    private int columns = 10;
    private int rows = 4;
    private int btnDim = 28;

    public TrinketsScreen() {
        super((ITextComponent)new TranslationTextComponent("gui.losttrinkets.trinket.active"));
    }

    protected void func_231160_c_() {
        if (this.mc.field_71439_g != null) {
            this.x = this.field_230708_k_ / 2 - this.columns * this.btnDim / 2;
            this.y = this.field_230709_l_ / 2 - this.rows * this.btnDim / 2;
            Trinkets trinkets = LostTrinketsAPI.getTrinkets((PlayerEntity)this.mc.field_71439_g);
            int cost = Configs.GENERAL.calcCost(trinkets);
            List<ITrinket> all = trinkets.getActiveTrinkets();
            block0: for (int j1 = 0; j1 < this.rows; ++j1) {
                for (int j2 = 0; j2 < this.columns; ++j2) {
                    boolean locked;
                    int i = j2 + j1 * this.columns;
                    if (i + 1 <= all.size()) {
                        ITrinket trinket = all.get(i);
                        this.func_230480_a_((Widget)new TrinketButton(this.x + j2 * this.btnDim, this.y + j1 * this.btnDim, Textures.TRINKET_ACTIVE_BG, trinket, button -> this.mc.func_147108_a((Screen)new TrinketOptionScreen(trinket, (Screen)this)), (button, matrix, i1, i2) -> {
                            ItemStack stack = new ItemStack((IItemProvider)trinket);
                            ArrayList list = Lists.newArrayList();
                            list.add(stack.func_200301_q());
                            trinket.addTrinketDescription(stack, list);
                            list.add(new TranslationTextComponent("gui.losttrinkets.rarity." + trinket.getRarity().name().toLowerCase(Locale.ENGLISH)).func_240699_a_(TextFormatting.DARK_GRAY));
                            GuiUtils.drawHoveringText((MatrixStack)matrix, (List)list, (int)i1, (int)i2, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)240, (FontRenderer)this.field_230712_o_);
                        }));
                        continue;
                    }
                    boolean bl = locked = i + 1 > trinkets.getSlots();
                    if (locked && cost < 0) break block0;
                    this.func_230480_a_((Widget)new IconButton(this.x + j2 * this.btnDim, this.y + j1 * this.btnDim, locked ? Textures.TRINKET_BG_LOCKED : Textures.TRINKET_BG_ADD, button -> {
                        if (locked) {
                            LostTrinkets.NET.toServer((Object)new UnlockSlotPacket());
                            this.setRefreshScreen(this);
                        } else {
                            this.mc.func_147108_a((Screen)new AvailableTrinketsScreen((Screen)this, 0));
                        }
                    }, (Screen)this).setTooltip(tooltip -> {
                        if (locked) {
                            tooltip.add(new TranslationTextComponent("gui.losttrinkets.trinket.slot.locked").func_240699_a_(TextFormatting.DARK_PURPLE));
                            if (!this.mc.field_71439_g.func_184812_l_()) {
                                tooltip.add(new TranslationTextComponent("gui.losttrinkets.trinket.slot.cost", new Object[]{cost}).func_240699_a_(TextFormatting.DARK_GRAY));
                            }
                            tooltip.add(new StringTextComponent(""));
                            tooltip.add(new TranslationTextComponent("gui.losttrinkets.trinket.slot.click.unlock").func_240699_a_(TextFormatting.GRAY));
                        } else {
                            tooltip.add(new TranslationTextComponent("gui.losttrinkets.trinket.slot.click.add").func_240699_a_(TextFormatting.GRAY));
                        }
                    }));
                    if (locked) break block0;
                }
            }
        }
    }

    public void func_230430_a_(MatrixStack matrix, int mx, int my, float pt) {
        this.func_230446_a_(matrix);
        super.func_230430_a_(matrix, mx, my, pt);
        String s = this.func_231171_q_().getString();
        this.field_230712_o_.func_238405_a_(matrix, s, (float)(this.field_230708_k_ / 2 - this.field_230712_o_.func_78256_a(s) / 2), (float)(this.y - 20), 0x999999);
    }
}

