/*
 * Decompiled with CFR 0.152.
 */
package owmii.losttrinkets.client.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;
import owmii.lib.client.screen.widget.IconButton;
import owmii.losttrinkets.LostTrinkets;
import owmii.losttrinkets.api.LostTrinketsAPI;
import owmii.losttrinkets.api.trinket.ITrinket;
import owmii.losttrinkets.api.trinket.Trinkets;
import owmii.losttrinkets.client.screen.AbstractLTScreen;
import owmii.losttrinkets.client.screen.Textures;
import owmii.losttrinkets.client.screen.TrinketsScreen;
import owmii.losttrinkets.client.screen.widget.TrinketButton;
import owmii.losttrinkets.network.packet.SetActivePacket;

public class AvailableTrinketsScreen
extends AbstractLTScreen {
    @Nullable
    protected final Screen prevScreen;
    private int x;
    private int y;
    private int columns = 14;
    private int rows = 5;
    private int btnDim = 28;
    private int headID;

    public AvailableTrinketsScreen(@Nullable Screen prevScreen, int headID) {
        super((ITextComponent)new TranslationTextComponent("gui.losttrinkets.trinket.available"));
        this.prevScreen = prevScreen;
        this.headID = headID;
    }

    protected void func_231160_c_() {
        if (this.mc.field_71439_g != null) {
            int i;
            this.x = this.field_230708_k_ / 2 - this.columns * this.btnDim / 2;
            this.y = this.field_230709_l_ / 2 - this.rows * this.btnDim / 2;
            Trinkets trinkets = LostTrinketsAPI.getTrinkets((PlayerEntity)this.mc.field_71439_g);
            List<ITrinket> all = trinkets.getAvailableTrinkets();
            int total = all.size();
            int cur = 0;
            for (int j1 = 0; j1 < this.rows; ++j1) {
                for (int j2 = 0; j2 < this.columns; ++j2) {
                    i = j2 + j1 * this.columns + this.headID;
                    if (i + 1 > total) continue;
                    ITrinket trinket = all.get(i);
                    this.func_230480_a_((Widget)new TrinketButton(this.x + j2 * this.btnDim, this.y + j1 * this.btnDim, Textures.TRINKET_BG, trinket, button -> {
                        LostTrinkets.NET.toServer((Object)new SetActivePacket(i));
                        trinkets.setActive(trinket, (PlayerEntity)this.mc.field_71439_g);
                        this.setRefreshScreen(new TrinketsScreen());
                    }, (button, matrix, i1, i2) -> {
                        ItemStack stack = new ItemStack((IItemProvider)trinket);
                        ArrayList list = Lists.newArrayList();
                        list.add(stack.func_200301_q());
                        trinket.addTrinketDescription(stack, list);
                        list.add(new TranslationTextComponent("gui.losttrinkets.rarity." + trinket.getRarity().name().toLowerCase(Locale.ENGLISH)).func_240699_a_(TextFormatting.DARK_GRAY));
                        GuiUtils.drawHoveringText((MatrixStack)matrix, (List)list, (int)i1, (int)i2, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)240, (FontRenderer)this.field_230712_o_);
                    }));
                    ++cur;
                }
            }
            int x1 = this.x + this.columns * this.btnDim / 2 - this.btnDim / 2 - 30;
            int y1 = this.y + 150;
            i = this.columns * this.rows;
            if (cur == this.columns * this.rows && total > this.headID) {
                this.func_230480_a_((Widget)new IconButton(60 + x1, y1, Textures.TRINKET_NEXT, button -> this.mc.func_147108_a((Screen)new AvailableTrinketsScreen(this.prevScreen, this.headID + i)), (Screen)this));
            }
            if (this.headID > 0) {
                this.func_230480_a_((Widget)new IconButton(x1, y1, Textures.TRINKET_PREV, button -> this.mc.func_147108_a((Screen)new AvailableTrinketsScreen(this.prevScreen, Math.max(0, this.headID - i))), (Screen)this));
            }
        }
    }

    public void func_230430_a_(MatrixStack matrix, int mx, int my, float pt) {
        List<ITrinket> all;
        this.func_230446_a_(matrix);
        if (this.mc.field_71439_g != null && (all = LostTrinketsAPI.getTrinkets((PlayerEntity)this.mc.field_71439_g).getAvailableTrinkets()).isEmpty()) {
            int x = this.field_230708_k_ / 2;
            int y = this.field_230709_l_ / 2;
            String name = I18n.func_135052_a((String)"gui.losttrinkets.trinket.empty", (Object[])new Object[0]);
            this.field_230712_o_.func_238421_b_(matrix, name, (float)(x - this.field_230712_o_.func_78256_a(name) / 2), (float)(y - 5), 0x999999);
        }
        super.func_230430_a_(matrix, mx, my, pt);
        String s = this.func_231171_q_().getString();
        this.field_230712_o_.func_238405_a_(matrix, s, (float)(this.field_230708_k_ / 2 - this.field_230712_o_.func_78256_a(s) / 2), (float)(this.y - 20), 0x999999);
    }

    public void func_231175_as__() {
        if (this.prevScreen instanceof TrinketsScreen) {
            this.mc.func_147108_a(this.prevScreen);
        }
    }
}

