/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.texture.type;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import java.lang.annotation.ElementType;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import team.chisel.ctm.api.texture.ITextureType;
import team.chisel.ctm.api.texture.TextureType;

public class TextureTypeRegistry {
    private static final Logger log = LogManager.getLogger(TextureTypeRegistry.class);
    private static Map<String, ITextureType> map = Maps.newHashMap();

    public static void scan() {
        List annotations = ModList.get().getAllScanData().stream().map(ModFileScanData::getAnnotations).flatMap(Collection::stream).filter(a -> TextureType.class.getName().equals(a.getAnnotationType().getClassName())).collect(Collectors.toList());
        log.debug("Found {} @TextureType annotations from scan", (Object)annotations.size());
        HashMultimap annots = HashMultimap.create();
        for (ModFileScanData.AnnotationData annotationData : annotations) {
            annots.put((Object)annotationData, (Object)((String)annotationData.getAnnotationData().get("value")));
        }
        log.debug("Found {} unique texture types", (Object)annots.size());
        for (Map.Entry entry : annots.asMap().entrySet()) {
            ITextureType type;
            if (((ModFileScanData.AnnotationData)entry.getKey()).getTargetType() == ElementType.FIELD) {
                try {
                    Class<?> c = Class.forName(((ModFileScanData.AnnotationData)entry.getKey()).getClassType().getClassName());
                    Field f = c.getDeclaredField(((ModFileScanData.AnnotationData)entry.getKey()).getMemberName());
                    type = (ITextureType)f.get(null);
                }
                catch (Exception e) {
                    throw new RuntimeException("Exception loading texture type for class: " + ((ModFileScanData.AnnotationData)entry.getKey()).getClassType(), e);
                }
            } else if (((ModFileScanData.AnnotationData)entry.getKey()).getTargetType() == ElementType.TYPE) {
                try {
                    Class<?> clazz = Class.forName(((ModFileScanData.AnnotationData)entry.getKey()).getClassType().getClassName());
                    type = (ITextureType)clazz.newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException("Exception loading texture type for class: " + ((ModFileScanData.AnnotationData)entry.getKey()).getClassType() + " (on member " + ((ModFileScanData.AnnotationData)entry.getKey()).getMemberName() + ")", e);
                }
            } else {
                throw new IllegalArgumentException("@TextureType found on invalid element type: " + (Object)((Object)((ModFileScanData.AnnotationData)entry.getKey()).getTargetType()) + " (" + ((ModFileScanData.AnnotationData)entry.getKey()).getClassType() + ")");
            }
            for (String name : (Collection)entry.getValue()) {
                log.debug("Registering scanned texture type: {}", (Object)name);
                TextureTypeRegistry.register(name, type);
            }
        }
    }

    public static void register(String name, ITextureType type) {
        String key = name.toLowerCase(Locale.ROOT);
        if (map.containsKey(key) && map.get(key) != type) {
            throw new IllegalArgumentException("Render Type with name " + key + " has already been registered!");
        }
        if (map.get(key) != type) {
            map.put(key, type);
        }
    }

    public static ITextureType getType(String name) {
        String key = name.toLowerCase(Locale.ROOT);
        return map.get(key);
    }

    public static boolean isValid(String name) {
        return TextureTypeRegistry.getType(name) != null;
    }
}

