/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.texture.render;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3i;
import team.chisel.ctm.api.texture.ITextureContext;
import team.chisel.ctm.api.util.TextureInfo;
import team.chisel.ctm.client.texture.ctx.TextureContextPosition;
import team.chisel.ctm.client.texture.render.AbstractTexture;
import team.chisel.ctm.client.texture.type.TextureTypeEldritch;
import team.chisel.ctm.client.util.Quad;

@ParametersAreNonnullByDefault
public class TextureEldritch
extends AbstractTexture<TextureTypeEldritch> {
    private static final Random rand = new Random();

    public TextureEldritch(TextureTypeEldritch type, TextureInfo info) {
        super(type, info);
    }

    @Override
    public List<BakedQuad> transformQuad(BakedQuad quad, @Nullable ITextureContext context, int quadGoal) {
        Quad q = this.makeQuad(quad, context);
        Quad.UVs uvs = q.getUvs();
        Vector2f min = new Vector2f(uvs.getMinU(), uvs.getMinV());
        Vector2f max = new Vector2f(uvs.getMaxU(), uvs.getMaxV());
        Direction facing = quad.func_178210_d();
        BlockPos pos = context == null ? BlockPos.field_177992_a : ((TextureContextPosition)context).getPosition();
        rand.setSeed(MathHelper.func_180186_a((Vector3i)pos) + (long)facing.ordinal());
        float offx = this.offsetRand();
        float offy = this.offsetRand();
        Quad[] subdiv = q.subdivide(4);
        for (int i = 0; i < subdiv.length; ++i) {
            Quad quadrant = subdiv[i];
            for (int j = 0; quadrant != null && j < 4; ++j) {
                Vector2f uv = quadrant.getUv(j);
                if (uv.field_189982_i == min.field_189982_i || uv.field_189982_i == max.field_189982_i || uv.field_189983_j == min.field_189983_j || uv.field_189983_j == max.field_189983_j) continue;
                float xinterp = Quad.normalize(min.field_189982_i, max.field_189982_i, uv.field_189982_i);
                float yinterp = Quad.normalize(min.field_189983_j, max.field_189983_j, uv.field_189983_j);
                uv = new Vector2f(Quad.lerp(min.field_189982_i, max.field_189982_i, xinterp += offx), Quad.lerp(min.field_189983_j, max.field_189983_j, yinterp += offy));
                subdiv[i] = quadrant.withUv(j, uv);
            }
        }
        return Arrays.stream(subdiv).filter(Objects::nonNull).map(Quad::rebake).collect(Collectors.toList());
    }

    private float offsetRand() {
        return (float)rand.nextGaussian() * 0.08f;
    }
}

