/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import xreliquary.entities.shot.ShotEntityBase;
import xreliquary.init.ModItems;
import xreliquary.init.ModSounds;
import xreliquary.items.BulletItem;
import xreliquary.items.ItemBase;
import xreliquary.items.MagazineItem;
import xreliquary.reference.Settings;
import xreliquary.util.LanguageHelper;
import xreliquary.util.NBTHelper;
import xreliquary.util.RegistryHelper;
import xreliquary.util.potions.XRPotionHelper;

public class HandgunItem
extends ItemBase {
    private static final int HANDGUN_RELOAD_SKILL_OFFSET = 10;
    private static final int HANDGUN_COOLDOWN_SKILL_OFFSET = 5;
    private static final String MAGAZINE_TYPE_TAG = "magazineType";
    private final Map<String, IShotEntityFactory> magazineShotFactories = new HashMap<String, IShotEntityFactory>();
    private final Map<String, Supplier<BulletItem>> magazineBulletItems = new HashMap<String, Supplier<BulletItem>>();

    public void registerMagazine(String magazineRegistryName, IShotEntityFactory factory, Supplier<BulletItem> getBulletItem) {
        this.magazineShotFactories.put(magazineRegistryName, factory);
        this.magazineBulletItems.put(magazineRegistryName, getBulletItem);
    }

    public HandgunItem() {
        super(new Item.Properties().func_200917_a(1), () -> ((ForgeConfigSpec.BooleanValue)Settings.COMMON.disable.disableHandgun).get());
    }

    private short getBulletCount(ItemStack handgun) {
        return NBTHelper.getShort("bulletCount", handgun);
    }

    public ItemStack getBulletStack(ItemStack handgun) {
        String magazineType = this.getMagazineType(handgun);
        if (!this.magazineBulletItems.containsKey(magazineType)) {
            return new ItemStack((IItemProvider)ModItems.EMPTY_BULLET.get(), 1);
        }
        BulletItem bulletItem = this.magazineBulletItems.get(magazineType).get();
        ItemStack bulletStack = new ItemStack((IItemProvider)bulletItem, (int)this.getBulletCount(handgun));
        XRPotionHelper.addPotionEffectsToStack(bulletStack, this.getPotionEffects(handgun));
        return bulletStack;
    }

    private void setBulletCount(ItemStack handgun, short bulletCount) {
        NBTHelper.putShort("bulletCount", handgun, bulletCount);
    }

    private String getMagazineType(ItemStack handgun) {
        return NBTHelper.getString(MAGAZINE_TYPE_TAG, handgun);
    }

    private void setMagazineType(ItemStack handgun, ItemStack magazine) {
        NBTHelper.putString(MAGAZINE_TYPE_TAG, handgun, RegistryHelper.getItemRegistryName(magazine.func_77973_b()));
    }

    private boolean hasAmmo(ItemStack handgun) {
        return this.getBulletCount(handgun) > 0;
    }

    public long getCooldown(ItemStack handgun) {
        return NBTHelper.getLong("coolDownTime", handgun);
    }

    private void setCooldown(ItemStack handgun, long coolDownTime) {
        NBTHelper.putLong("coolDownTime", handgun, coolDownTime);
    }

    private List<EffectInstance> getPotionEffects(ItemStack handgun) {
        return XRPotionHelper.getPotionEffectsFromStack(handgun);
    }

    private void setPotionEffects(ItemStack handgun, List<EffectInstance> potionEffects) {
        XRPotionHelper.cleanPotionEffects(handgun);
        XRPotionHelper.addPotionEffectsToStack(handgun, potionEffects);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addMoreInformation(ItemStack handgun, @Nullable World world, List<ITextComponent> tooltip) {
        LanguageHelper.formatTooltip(this.func_77658_a() + ".tooltip2", (ImmutableMap<String, String>)ImmutableMap.of((Object)"count", (Object)String.valueOf(this.getBulletCount(handgun)), (Object)"type", (Object)LanguageHelper.getLocalization("magazine.xreliquary." + this.getMagazineTranslationKey(handgun), new Object[0])), tooltip);
        XRPotionHelper.addPotionTooltip(handgun, tooltip);
    }

    @Override
    protected boolean hasMoreInformation(ItemStack stack) {
        return true;
    }

    private String getMagazineTranslationKey(ItemStack handgun) {
        return this.getMagazineType(handgun).replace("xreliquary:", "");
    }

    public UseAction func_77661_b(ItemStack handgun) {
        if (this.getBulletCount(handgun) > 0) {
            return UseAction.NONE;
        }
        return UseAction.BLOCK;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.func_77973_b() != newStack.func_77973_b() || this.getBulletCount(oldStack) < this.getBulletCount(newStack);
    }

    private boolean isCooldownOver(World world, ItemStack handgun) {
        return this.getCooldown(handgun) < world.func_82737_E();
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack handgun = player.func_184586_b(hand);
        if (this.getBulletCount(handgun) > 0 && !this.isCooldownOver(world, handgun) && this.otherHandgunCooledDownMore(player, hand, handgun)) {
            return new ActionResult(ActionResultType.PASS, (Object)handgun);
        }
        if (this.getBulletCount(handgun) > 0 || this.hasFilledMagazine(player)) {
            player.func_184598_c(hand);
            return new ActionResult(ActionResultType.SUCCESS, (Object)handgun);
        }
        return new ActionResult(ActionResultType.PASS, (Object)handgun);
    }

    private boolean otherHandgunCooledDownMore(PlayerEntity player, Hand currentHand, ItemStack currentHandgun) {
        if (currentHand == Hand.MAIN_HAND) {
            ItemStack offHandItem = player.func_184592_cb();
            return offHandItem.func_77973_b() == this && this.getCooldown(offHandItem) < this.getCooldown(currentHandgun);
        }
        ItemStack mainHandItem = player.func_184614_ca();
        return mainHandItem.func_77973_b() == this && this.getCooldown(mainHandItem) < this.getCooldown(currentHandgun);
    }

    public void onUsingTick(ItemStack handgun, LivingEntity entity, int unadjustedCount) {
        if (entity.field_70170_p.field_72995_K || !(entity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        int maxUseOffset = this.getItemUseDuration() - this.getPlayerReloadDelay(player);
        int actualCount = unadjustedCount - maxUseOffset;
        if (--actualCount == 0 || this.isCooldownOver(entity.field_70170_p, handgun) && this.getBulletCount(handgun) > 0 || !this.hasFilledMagazine(player)) {
            player.func_184597_cx();
        }
    }

    public int func_77626_a(ItemStack handgun) {
        return this.getItemUseDuration();
    }

    public void func_77615_a(ItemStack handgun, World worldIn, LivingEntity entityLiving, int timeLeft) {
        if (!(entityLiving instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entityLiving;
        if (this.hasAmmo(handgun)) {
            if (this.isCooldownOver(player.field_70170_p, handgun)) {
                this.setFiringCooldown(handgun, worldIn, player);
                this.fireBullet(handgun, worldIn, player, handgun == player.func_184614_ca() ? Hand.MAIN_HAND : Hand.OFF_HAND);
            }
            return;
        }
        this.setCooldown(handgun, player.field_70170_p.func_82737_E() + 12L);
        this.getMagazineSlot(player).ifPresent(slot -> {
            ItemStack magazine = (ItemStack)player.field_71071_by.field_70462_a.get(slot.intValue());
            this.setMagazineType(handgun, magazine);
            this.setPotionEffects(handgun, XRPotionHelper.getPotionEffectsFromStack(magazine));
            magazine.func_190918_g(1);
            if (magazine.func_190926_b()) {
                player.field_71071_by.field_70462_a.set(slot.intValue(), (Object)ItemStack.field_190927_a);
            }
            player.func_184609_a(player.func_184600_cs());
            this.spawnEmptyMagazine(player);
            this.setBulletCount(handgun, (short)8);
            player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), ModSounds.xload, SoundCategory.PLAYERS, 0.25f, 1.0f);
            this.setFiringCooldown(handgun, worldIn, player);
        });
        if (this.getBulletCount(handgun) == 0) {
            this.setPotionEffects(handgun, Collections.emptyList());
        }
    }

    private void setSecondHandgunFiringCooldown(PlayerEntity player, ItemStack currentHandgun) {
        if (player.func_184614_ca() == currentHandgun) {
            this.setHalfFiringCooldown(player, player.func_184592_cb());
        } else if (player.func_184592_cb() == currentHandgun) {
            this.setHalfFiringCooldown(player, player.func_184614_ca());
        }
    }

    private void setHalfFiringCooldown(PlayerEntity player, ItemStack potentialHandgun) {
        if (potentialHandgun.func_77973_b() == this && this.isCooldownOver(player.field_70170_p, potentialHandgun)) {
            this.setCooldown(potentialHandgun, player.field_70170_p.func_82737_E() + (long)(this.getPlayerFiringCooldown(player) / 2));
        }
    }

    private void setFiringCooldown(ItemStack handgun, World worldIn, PlayerEntity player) {
        this.setCooldown(handgun, worldIn.func_82737_E() + (long)this.getPlayerFiringCooldown(player));
        this.setSecondHandgunFiringCooldown(player, handgun);
    }

    private int getPlayerFiringCooldown(PlayerEntity player) {
        return (Integer)Settings.COMMON.items.handgun.maxSkillLevel.get() + 5 - Math.min(player.field_71068_ca, (Integer)Settings.COMMON.items.handgun.maxSkillLevel.get());
    }

    private int getItemUseDuration() {
        return 10 + (Integer)Settings.COMMON.items.handgun.maxSkillLevel.get();
    }

    private void fireBullet(ItemStack handgun, World world, PlayerEntity player, Hand hand) {
        if (!world.field_72995_K) {
            String magazineType = this.getMagazineType(handgun);
            if (!this.magazineShotFactories.containsKey(magazineType)) {
                return;
            }
            this.spawnShotEntity(handgun, world, player, hand, magazineType);
            world.func_184133_a(null, player.func_233580_cy_(), ModSounds.xshot, SoundCategory.PLAYERS, 0.5f, 1.2f);
            this.setBulletCount(handgun, (short)(this.getBulletCount(handgun) - 1));
            if (this.getBulletCount(handgun) == 0) {
                this.setPotionEffects(handgun, Collections.emptyList());
            }
            this.spawnCasing(player);
        }
    }

    private void spawnShotEntity(ItemStack handgun, World world, PlayerEntity player, Hand hand, String magazineType) {
        if (!this.magazineShotFactories.containsKey(magazineType)) {
            return;
        }
        ShotEntityBase shot = this.magazineShotFactories.get(magazineType).createShot(world, player, hand).addPotionEffects(this.getPotionEffects(handgun));
        double motionX = -MathHelper.func_76126_a((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI));
        double motionZ = MathHelper.func_76134_b((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI));
        double motionY = -MathHelper.func_76126_a((float)(player.field_70125_A / 180.0f * (float)Math.PI));
        shot.func_70186_c(motionX, motionY, motionZ, 1.2f, 1.0f);
        world.func_217376_c((Entity)shot);
    }

    private void spawnEmptyMagazine(PlayerEntity player) {
        ItemStack emptyMagazine = new ItemStack((IItemProvider)ModItems.EMPTY_MAGAZINE.get());
        if (!player.field_71071_by.func_70441_a(emptyMagazine)) {
            player.func_70099_a(emptyMagazine, 0.1f);
        }
    }

    private void spawnCasing(PlayerEntity player) {
        ItemStack emptyCasing = new ItemStack((IItemProvider)ModItems.EMPTY_BULLET.get());
        if (!player.field_71071_by.func_70441_a(emptyCasing)) {
            player.func_70099_a(emptyCasing, 0.1f);
        }
    }

    private boolean hasFilledMagazine(PlayerEntity player) {
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack == null || !(stack.func_77973_b() instanceof MagazineItem) || stack.func_77973_b() == ModItems.EMPTY_MAGAZINE.get()) continue;
            return true;
        }
        return false;
    }

    private Optional<Integer> getMagazineSlot(PlayerEntity player) {
        for (int slot = 0; slot < player.field_71071_by.field_70462_a.size(); ++slot) {
            Item item = ((ItemStack)player.field_71071_by.field_70462_a.get(slot)).func_77973_b();
            if (!(item instanceof MagazineItem) || item == ModItems.EMPTY_MAGAZINE.get()) continue;
            return Optional.of(slot);
        }
        return Optional.empty();
    }

    private int getPlayerReloadDelay(PlayerEntity player) {
        return (Integer)Settings.COMMON.items.handgun.maxSkillLevel.get() + 10 - Math.min(player.field_71068_ca, (Integer)Settings.COMMON.items.handgun.maxSkillLevel.get());
    }

    public static interface IShotEntityFactory {
        public ShotEntityBase createShot(World var1, PlayerEntity var2, Hand var3);
    }
}

