/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.entities;

import java.util.List;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.network.PacketDistributor;
import xreliquary.init.ModEntities;
import xreliquary.init.ModItems;
import xreliquary.network.PacketFXThrownPotionImpact;
import xreliquary.network.PacketHandler;
import xreliquary.reference.Colors;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
public class GlowingWaterEntity
extends ThrowableEntity
implements IRendersAsItem {
    public GlowingWaterEntity(EntityType<GlowingWaterEntity> entityType, World world) {
        super(entityType, world);
    }

    public GlowingWaterEntity(World world, PlayerEntity player) {
        super(ModEntities.GLOWING_WATER, (LivingEntity)player, world);
    }

    public GlowingWaterEntity(World world, double x, double y, double z) {
        super(ModEntities.GLOWING_WATER, x, y, z, world);
    }

    protected float func_70185_h() {
        return 0.05f;
    }

    private boolean isUndead(LivingEntity e) {
        return e.func_70668_bt() == CreatureAttribute.field_223223_b_;
    }

    protected void func_70227_a(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K) {
            this.spawnParticles();
            AxisAlignedBB bb = this.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0);
            List eList = this.field_70170_p.func_217357_a(MobEntity.class, bb);
            eList.stream().filter(this::isUndead).forEach(e -> {
                float amount = 18.0f + (float)this.field_70146_Z.nextInt(17);
                Entity thrower = this.func_234616_v_();
                if (thrower instanceof PlayerEntity) {
                    e.func_70097_a(DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)thrower)), amount);
                } else {
                    e.func_70097_a(DamageSource.field_76376_m, amount);
                }
            });
            this.field_70170_p.func_217379_c(2002, this.func_233580_cy_(), 0);
            this.func_70106_y();
        }
    }

    private void spawnParticles() {
        double x = this.func_226277_ct_();
        double y = this.func_226278_cu_();
        double z = this.func_226281_cx_();
        ItemParticleData itemParticleData = new ItemParticleData(ParticleTypes.field_197591_B, new ItemStack((IItemProvider)ModItems.GLOWING_WATER.get()));
        for (int particleNum = 0; particleNum < 8; ++particleNum) {
            this.field_70170_p.func_195594_a((IParticleData)itemParticleData, x, y, z, this.field_70146_Z.nextGaussian() * 0.15, this.field_70146_Z.nextDouble() * 0.2, this.field_70146_Z.nextGaussian() * 0.15);
        }
        this.field_70170_p.func_184133_a(null, this.func_233580_cy_(), SoundEvents.field_187561_bM, SoundCategory.NEUTRAL, 1.0f, this.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
        PacketHandler.sendToAllAround(new PacketFXThrownPotionImpact(Colors.get("3B64DC"), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()), new PacketDistributor.TargetPoint(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 32.0, this.field_70170_p.func_234923_W_()));
    }

    protected void func_70088_a() {
    }

    public ItemStack func_184543_l() {
        return new ItemStack((IItemProvider)ModItems.GLOWING_WATER.get());
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

