/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.client.particle;

import javax.annotation.Nullable;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.world.ClientWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xreliquary.client.particle.BubbleColorParticleData;
import xreliquary.client.particle.ColorParticleData;

@OnlyIn(value=Dist.CLIENT)
public class CauldronBubbleParticle
extends SpriteTexturedParticle {
    private final IAnimatedSprite spriteSet;

    private CauldronBubbleParticle(ClientWorld world, ColorParticleData particleData, double x, double y, double z, IAnimatedSprite spriteSet) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.spriteSet = spriteSet;
        this.func_187115_a(0.02f, 0.02f);
        this.field_70544_f = 0.5f + (world.field_73012_v.nextFloat() - 0.5f) * 0.4f;
        this.field_187129_i = 0.0;
        this.field_187130_j = 0.0;
        this.field_187131_k = 0.0;
        this.field_70552_h = particleData.getRed();
        this.field_70553_i = particleData.getGreen();
        this.field_70551_j = particleData.getBlue();
        this.field_70547_e = 20;
        this.field_70546_d = 0;
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        this.func_82338_g((float)this.field_70546_d / (float)this.field_70547_e);
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
        } else {
            this.func_217566_b(this.spriteSet);
        }
    }

    public float func_217561_b(float partialTicks) {
        return 0.1f * this.field_70544_f * (1.0f + (float)this.field_70546_d / 20.0f);
    }

    public void func_217566_b(IAnimatedSprite animatedSprite) {
        int ageFromDeath = this.field_70547_e - this.field_70546_d;
        if (ageFromDeath <= 6) {
            animatedSprite.func_217591_a(4 - Math.max(ageFromDeath / 2, 1), this.field_70547_e);
        } else {
            animatedSprite.func_217591_a(0, this.field_70547_e);
        }
    }

    public IParticleRenderType func_217558_b() {
        return IParticleRenderType.field_217602_b;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements IParticleFactory<BubbleColorParticleData> {
        private final IAnimatedSprite spriteSet;

        public Factory(IAnimatedSprite spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle makeParticle(BubbleColorParticleData particleData, ClientWorld world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            CauldronBubbleParticle particle = new CauldronBubbleParticle(world, particleData, x, y, z, this.spriteSet);
            particle.func_217567_a(this.spriteSet.func_217591_a(particle.field_70546_d, particle.field_70547_e));
            return particle;
        }
    }
}

