/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.blocks;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wile.rsgauges.libmc.detail.Auxiliaries;
import wile.rsgauges.libmc.detail.Networking;

public abstract class RsBlock
extends Block
implements IWaterLoggable {
    public static final long RSBLOCK_CONFIG_SOLID = 0L;
    public static final long RSBLOCK_CONFIG_CUTOUT = 0x1000000000000000L;
    public static final long RSBLOCK_CONFIG_CUTOUT_MIPPED = 0x2000000000000000L;
    public static final long RSBLOCK_CONFIG_TRANSLUCENT = 0x3000000000000000L;
    public static final long RSBLOCK_NOT_WATERLOGGABLE = 0x8000000000000L;
    private static final RenderTypeHint[] render_layer_map_ = new RenderTypeHint[]{RenderTypeHint.SOLID, RenderTypeHint.CUTOUT, RenderTypeHint.CUTOUT_MIPPED, RenderTypeHint.TRANSLUCENT};
    public final long config;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public RsBlock(long config, AbstractBlock.Properties properties) {
        this(config, properties, Auxiliaries.getPixeledAABB(0.0, 0.0, 0.0, 16.0, 16.0, 16.0));
    }

    public RsBlock(long config, AbstractBlock.Properties properties, AxisAlignedBB aabb) {
        this(config, properties, VoxelShapes.func_197881_a((AxisAlignedBB)aabb));
    }

    public RsBlock(long config, AbstractBlock.Properties properties, VoxelShape vshape) {
        super(properties);
        this.config = config;
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public RenderTypeHint getRenderTypeHint() {
        return render_layer_map_[(int)(this.config >> 60 & 3L)];
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        Auxiliaries.Tooltip.addInformation(stack, world, tooltip, flag, true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addHitEffects(BlockState state, World worldObj, RayTraceResult target, ParticleManager manager) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean hasCustomBreakingProgress(BlockState state) {
        return true;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader source, BlockPos pos, ISelectionContext selectionContext) {
        return VoxelShapes.func_197868_b();
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext selectionContext) {
        return this.func_220053_a(state, world, pos, selectionContext);
    }

    public boolean func_181623_g() {
        return false;
    }

    public boolean canCreatureSpawn(BlockState state, IBlockReader world, BlockPos pos, EntitySpawnPlacementRegistry.PlacementType type, @Nullable EntityType<?> entityType) {
        return false;
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{WATERLOGGED});
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState fs;
        BlockState state = super.func_196258_a(context);
        if (state == null) {
            return null;
        }
        state = (this.config & 0x8000000000000L) == 0L ? (BlockState)state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf((fs = context.func_195991_k().func_204610_c(context.func_195995_a())).func_206886_c() == Fluids.field_204546_a)) : (BlockState)state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        return state;
    }

    public FluidState func_204507_t(BlockState state) {
        return (this.config & 0x8000000000000L) == 0L ? (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue() ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state)) : super.func_204507_t(state);
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        if ((this.config & 0x8000000000000L) == 0L && ((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            return false;
        }
        return super.func_200123_i(state, reader, pos);
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        super.func_196243_a(state, world, pos, newState, isMoving);
        world.func_175666_e(pos, newState.func_177230_c());
        world.func_195593_d(pos, newState.func_177230_c());
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos pos, BlockPos facingPos) {
        if ((this.config & 0x8000000000000L) == 0L && ((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return state;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        return Collections.singletonList(new ItemStack((IItemProvider)state.func_177230_c().func_199767_j()));
    }

    public boolean hasTileEntity(BlockState state) {
        return false;
    }

    public void func_196270_a(BlockState state, World world, BlockPos pos, PlayerEntity player) {
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        return ActionResultType.PASS;
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rnd) {
    }

    public static abstract class RsTileEntity
    extends TileEntity
    implements Networking.IPacketTileNotifyReceiver {
        private static final int NBT_ENTITY_TYPE = 1;

        public RsTileEntity(TileEntityType<?> te_type) {
            super(te_type);
        }

        public void write(CompoundNBT nbt, boolean updatePacket) {
        }

        public void read(CompoundNBT nbt, boolean updatePacket) {
        }

        protected final void syncToClients() {
            if (this.field_145850_b.func_201670_d()) {
                return;
            }
            CompoundNBT nbt = new CompoundNBT();
            this.write(nbt, true);
            Networking.PacketTileNotifyServerToClient.sendToAllPlayers((ServerWorld)this.func_145831_w(), this.func_174877_v(), nbt);
        }

        @Override
        public final void onServerPacketReceived(CompoundNBT nbt) {
            this.read(nbt, true);
        }

        public final CompoundNBT func_189515_b(CompoundNBT nbt) {
            super.func_189515_b(nbt);
            this.write(nbt, false);
            return nbt;
        }

        public final void func_230337_a_(BlockState state, CompoundNBT nbt) {
            super.func_230337_a_(state, nbt);
            this.read(nbt, false);
        }
    }

    public static enum RenderTypeHint {
        SOLID,
        CUTOUT,
        CUTOUT_MIPPED,
        TRANSLUCENT;

    }
}

