/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.blocks;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import wile.rsgauges.blocks.SwitchBlock;
import wile.rsgauges.detail.ModResources;

public class LinkSenderSwitchBlock
extends SwitchBlock {
    private final boolean is_analog;

    public LinkSenderSwitchBlock(long config, AbstractBlock.Properties properties, AxisAlignedBB unrotatedBBUnpowered, @Nullable AxisAlignedBB unrotatedBBPowered, @Nullable ModResources.BlockSoundEvent powerOnSound, @Nullable ModResources.BlockSoundEvent powerOffSound, boolean analog_device) {
        super(config, properties, unrotatedBBUnpowered, unrotatedBBPowered, powerOnSound, powerOffSound);
        this.is_analog = analog_device;
    }

    @Override
    public boolean switchLinkHasAnalogSupport(World world, BlockPos pos) {
        return this.is_analog;
    }

    @Override
    protected int getPower(BlockState state, IBlockReader world, BlockPos pos, Direction side, boolean strong) {
        return 0;
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        SwitchBlock.SwitchTileEntity te = this.getTe((IWorldReader)world, pos);
        if (te != null) {
            te.reset((IWorldReader)world);
        }
        world.func_180501_a(pos, (BlockState)world.func_180495_p(pos).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)), 27);
        this.func_220069_a(state, world, pos, state.func_177230_c(), pos.func_177972_a(((Direction)state.func_177229_b((Property)FACING)).func_176734_d()), false);
    }

    @Override
    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        int power;
        if (!this.isAffectedByNeigbour(state, (IWorld)world, pos, fromPos)) {
            return;
        }
        SwitchBlock.SwitchTileEntity te = this.getTe((IWorldReader)world, pos);
        if (te == null) {
            return;
        }
        if (this.isCube()) {
            power = world.func_175687_A(pos);
        } else {
            Direction facing = ((Direction)state.func_177229_b((Property)FACING)).func_176734_d();
            BlockPos neighbour_pos = pos.func_177972_a(facing);
            BlockState neighbour_state = world.func_180495_p(neighbour_pos);
            power = !state.func_185897_m() ? world.func_175687_A(neighbour_pos) : Math.max(neighbour_state.func_185911_a((IBlockReader)world, neighbour_pos, facing), neighbour_state.func_185893_b((IBlockReader)world, neighbour_pos, facing));
        }
        if ((this.config & 0x100000L) != 0L && te.inverted()) {
            power = 15 - power;
        }
        if (te.on_power() == power) {
            return;
        }
        te.on_power(power);
        boolean powered = power > 0;
        boolean was_powered = (Boolean)state.func_177229_b((Property)POWERED);
        if (powered != was_powered && ((this.config & 0x20000000L) == 0L || powered && !was_powered)) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(powered)), 27);
            if ((this.config & 0x20000000L) != 0L) {
                te.on_timer_reset();
                te.on_timer_extend();
                te.reschedule_block_tick();
            }
            if (powered && this.power_on_sound != null) {
                this.power_on_sound.play(world, pos);
            } else if (!powered && this.power_off_sound != null) {
                this.power_off_sound.play(world, pos);
            }
        }
        if (!te.activateSwitchLinks(power, powered ? 15 : 0, powered != was_powered)) {
            ModResources.BlockSoundEvents.SWITCHLINK_LINK_PEAL_USE_FAILED.play(world, pos);
        }
    }

    public boolean getWeakChanges(BlockState state, IWorldReader world, BlockPos pos) {
        return true;
    }
}

