/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.blocks;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import wile.rsgauges.blocks.SwitchBlock;
import wile.rsgauges.detail.ModResources;
import wile.rsgauges.detail.SwitchLink;

public class LinkReceiverSwitchBlock
extends SwitchBlock {
    private final boolean is_analog;

    public LinkReceiverSwitchBlock(long config, AbstractBlock.Properties properties, AxisAlignedBB unrotatedBBUnpowered, @Nullable AxisAlignedBB unrotatedBBPowered, @Nullable ModResources.BlockSoundEvent powerOnSound, @Nullable ModResources.BlockSoundEvent powerOffSound, boolean analog_device) {
        super(config, properties, unrotatedBBUnpowered, unrotatedBBPowered, powerOnSound, powerOffSound);
        this.is_analog = analog_device;
    }

    @Override
    public boolean switchLinkHasAnalogSupport(World world, BlockPos pos) {
        return this.is_analog;
    }

    @Override
    public SwitchLink.RequestResult switchLinkTrigger(SwitchLink link) {
        BlockPos pos = link.target_position;
        World world = link.world;
        SwitchBlock.SwitchTileEntity te = this.getTe((IWorldReader)world, pos);
        BlockState state = world.func_180495_p(pos);
        if (te == null || !te.verifySwitchLinkTarget(link)) {
            return SwitchLink.RequestResult.TARGET_GONE;
        }
        int p = this.is_analog ? link.source_analog_power : link.source_digital_power;
        te.on_power(p);
        boolean powered = p > 0;
        boolean was_powered = (Boolean)state.func_177229_b((Property)POWERED);
        if (powered != was_powered) {
            if ((this.config & 0x20000000L) == 0L) {
                world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(powered)), 27);
                (powered ? this.power_off_sound : this.power_on_sound).play(world, pos);
            } else if (powered) {
                world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(true)), 27);
                this.power_on_sound.play(world, pos);
                te.on_timer_reset();
                te.on_timer_extend();
                te.reschedule_block_tick();
            }
        }
        this.notifyNeighbours(world, pos, state, te, false);
        if (!te.activateSwitchLinks(te.on_power(), powered ? 15 : 0, powered != was_powered)) {
            ModResources.BlockSoundEvents.SWITCHLINK_LINK_PEAL_USE_FAILED.play(world, pos);
        }
        return SwitchLink.RequestResult.OK;
    }
}

