/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.transportstorage.tile;

import com.buuz135.industrial.block.transportstorage.tile.BHTile;
import com.buuz135.industrial.capability.tile.BigSidedFluidTankComponent;
import com.buuz135.industrial.utils.BlockUtils;
import com.buuz135.industrial.utils.NumberUtils;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.filter.FilterSlot;
import com.hrznstudio.titanium.api.filter.IFilter;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.filter.ItemStackFilter;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.Rarity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class BlackHoleTankTile
extends BHTile<BlackHoleTankTile> {
    @Save
    public BigSidedFluidTankComponent<BlackHoleTankTile> tank;
    @Save
    private ItemStackFilter filter;
    private boolean isEmpty;

    public BlackHoleTankTile(BasicTileBlock<BlackHoleTankTile> base, Rarity rarity) {
        super(base);
        this.tank = (BigSidedFluidTankComponent)new BigSidedFluidTankComponent<BlackHoleTankTile>("tank", BlockUtils.getFluidAmountByRarity(rarity), 20, 20, 0){

            @Override
            public void sync() {
                BlackHoleTankTile.this.syncObject(BlackHoleTankTile.this.tank);
            }
        }.setColor(DyeColor.BLUE).setValidator(fluidStack -> ((ItemStack)this.filter.getFilterSlots()[0].getFilter()).func_190926_b() ? true : ((ItemStack)this.filter.getFilterSlots()[0].getFilter()).getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(iFluidHandlerItem -> iFluidHandlerItem.getFluidInTank(0).isFluidEqual(fluidStack)).orElse(false));
        this.addTank((FluidTankComponent)this.tank);
        this.filter = new ItemStackFilter("filter", 1);
        this.addFilter((IFilter)this.filter);
        FilterSlot slot = new FilterSlot(79, 60, 0, (Object)ItemStack.field_190927_a);
        slot.setColor(DyeColor.CYAN);
        this.filter.setFilter(0, slot);
        this.isEmpty = true;
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (this.isEmpty != (this.tank.getFluidAmount() == 0)) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        }
        this.isEmpty = this.tank.getFluidAmount() == 0;
    }

    public ActionResultType onActivated(PlayerEntity playerIn, Hand hand, Direction facing, double hitX, double hitY, double hitZ) {
        if (super.onActivated(playerIn, hand, facing, hitX, hitY, hitZ) == ActionResultType.SUCCESS) {
            return ActionResultType.SUCCESS;
        }
        this.openGui(playerIn);
        return ActionResultType.SUCCESS;
    }

    @Override
    public ItemStack getDisplayStack() {
        ItemStack filledBucket;
        if (this.tank.getFluidAmount() > 0 && !(filledBucket = FluidUtil.getFilledBucket((FluidStack)this.tank.getFluid())).func_190926_b()) {
            return filledBucket;
        }
        return new ItemStack((IItemProvider)Items.field_151133_ar);
    }

    @Override
    public String getFormatedDisplayAmount() {
        return NumberUtils.getFormatedBigNumber(this.tank.getFluidAmount() / 1000) + " b";
    }

    @Nonnull
    public BlackHoleTankTile getSelf() {
        return this;
    }

    public SidedFluidTankComponent<BlackHoleTankTile> getTank() {
        return this.tank;
    }
}

