/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.resourceproduction.tile;

import com.buuz135.industrial.block.tile.IndustrialProcessingTile;
import com.buuz135.industrial.config.machine.resourceproduction.SporeRecreatorConfig;
import com.buuz135.industrial.module.ModuleResourceProduction;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.util.ItemHandlerUtil;
import javax.annotation.Nonnull;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class SporesRecreatorTile
extends IndustrialProcessingTile<SporesRecreatorTile> {
    private int getPowerPerTick;
    @Save
    private SidedFluidTankComponent<SporesRecreatorTile> tank = (SidedFluidTankComponent)new SidedFluidTankComponent("water", SporeRecreatorConfig.maxWaterTankSize, 31, 20, 0).setColor(DyeColor.CYAN).setTankAction(FluidTankComponent.Action.FILL).setComponentHarness((IComponentHarness)this).setValidator(fluidStack -> fluidStack.getFluid().func_207187_a((Fluid)Fluids.field_204546_a) || fluidStack.getFluid().func_207187_a((Fluid)Fluids.field_204547_b));
    @Save
    private SidedInventoryComponent<SporesRecreatorTile> input;
    @Save
    private SidedInventoryComponent<SporesRecreatorTile> output;

    public SporesRecreatorTile() {
        super(ModuleResourceProduction.SPORES_RECREATOR, 79, 40);
        this.addTank(this.tank);
        this.input = (SidedInventoryComponent)new SidedInventoryComponent("input", 53, 22, 3, 1).setColor(DyeColor.BLUE).setRange(1, 3).setComponentHarness((IComponentHarness)this).setInputFilter((stack, integer) -> stack.func_77973_b().func_206844_a((ITag)Tags.Items.MUSHROOMS) || stack.func_77973_b().equals(Items.field_234722_bw_) || stack.func_77973_b().equals(Items.field_234723_bx_)).setOutputFilter((stack, integer) -> false);
        this.addInventory((InventoryComponent)this.input);
        this.output = (SidedInventoryComponent)new SidedInventoryComponent("output", 110, 22, 9, 2).setColor(DyeColor.ORANGE).setRange(3, 3).setComponentHarness((IComponentHarness)this).setInputFilter((stack, integer) -> false);
        this.addInventory((InventoryComponent)this.output);
        this.getPowerPerTick = SporeRecreatorConfig.powerPerTick;
    }

    @Override
    public boolean canIncrease() {
        return !ItemHandlerUtil.getFirstItem(this.input).func_190926_b() && this.tank.getFluidAmount() >= 100 && (ItemHandlerUtil.getFirstItem(this.input).func_77973_b().func_206844_a((ITag)Tags.Items.MUSHROOMS) ? this.tank.getFluid().getFluid().func_207187_a((Fluid)Fluids.field_204546_a) : this.tank.getFluid().getFluid().func_207187_a((Fluid)Fluids.field_204547_b)) && ItemHandlerHelper.insertItem(this.output, (ItemStack)new ItemStack((IItemProvider)ItemHandlerUtil.getFirstItem(this.input).func_77973_b(), 2), (boolean)true).func_190926_b();
    }

    @Override
    public Runnable onFinish() {
        return () -> {
            ItemStack outputStack = new ItemStack((IItemProvider)ItemHandlerUtil.getFirstItem(this.input).func_77973_b(), 2);
            this.tank.drainForced(100, IFluidHandler.FluidAction.EXECUTE);
            ItemHandlerUtil.getFirstItem(this.input).func_190918_g(1);
            ItemHandlerHelper.insertItem(this.output, (ItemStack)outputStack, (boolean)false);
        };
    }

    protected EnergyStorageComponent<SporesRecreatorTile> createEnergyStorage() {
        return new EnergyStorageComponent(SporeRecreatorConfig.maxStoredPower, 10, 20);
    }

    @Override
    protected int getTickPower() {
        return this.getPowerPerTick;
    }

    @Nonnull
    public SporesRecreatorTile getSelf() {
        return this;
    }
}

