/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.resourceproduction.tile;

import com.buuz135.industrial.block.tile.IndustrialProcessingTile;
import com.buuz135.industrial.config.machine.resourceproduction.ResourcefulFurnaceConfig;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.module.ModuleResourceProduction;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.util.RecipeUtil;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ResourcefulFurnaceTile
extends IndustrialProcessingTile<ResourcefulFurnaceTile> {
    private int getPowerPerTick;
    @Save
    private SidedInventoryComponent<ResourcefulFurnaceTile> input = (SidedInventoryComponent)new SidedInventoryComponent("input", 44, 22, 3, 0).setColor(DyeColor.BLUE).setSlotLimit(1).setRange(1, 3).setOnSlotChanged((itemStack, integer) -> this.checkForRecipe((int)integer));
    @Save
    private SidedInventoryComponent<ResourcefulFurnaceTile> output;
    @Save
    private SidedFluidTankComponent<ResourcefulFurnaceTile> tank;
    private FurnaceRecipe[] recipes;

    public ResourcefulFurnaceTile() {
        super(ModuleResourceProduction.RESOURCEFUL_FURNACE, 74, 40);
        this.addInventory((InventoryComponent)this.input);
        this.output = (SidedInventoryComponent)new SidedInventoryComponent("output", 110, 22, 3, 1).setColor(DyeColor.ORANGE).setInputFilter((itemStack, integer) -> false).setRange(1, 3);
        this.addInventory((InventoryComponent)this.output);
        this.tank = (SidedFluidTankComponent)new SidedFluidTankComponent("essence", ResourcefulFurnaceConfig.maxEssenceTankSize, 132, 20, 2).setColor(DyeColor.LIME).setTankAction(FluidTankComponent.Action.DRAIN);
        this.addTank(this.tank);
        this.recipes = new FurnaceRecipe[3];
        this.getPowerPerTick = ResourcefulFurnaceConfig.powerPerTick;
    }

    public void func_226984_a_(World p_226984_1_, BlockPos p_226984_2_) {
        super.func_226984_a_(p_226984_1_, p_226984_2_);
        this.checkForRecipe(0);
        this.checkForRecipe(1);
        this.checkForRecipe(2);
    }

    private void checkForRecipe(int slot) {
        Collection recipes = RecipeUtil.getCookingRecipes((World)this.field_145850_b);
        this.recipes[slot] = recipes.stream().filter(furnaceRecipe -> ((Ingredient)furnaceRecipe.func_192400_c().get(0)).test(this.input.getStackInSlot(slot))).findAny().orElse(null);
    }

    @Override
    public boolean canIncrease() {
        for (FurnaceRecipe recipe : this.recipes) {
            if (recipe == null || !ItemHandlerHelper.insertItem(this.output, (ItemStack)recipe.func_77571_b().func_77946_l(), (boolean)true).func_190926_b()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Runnable onFinish() {
        return () -> {
            for (int i = 0; i < this.recipes.length; ++i) {
                FurnaceRecipe recipe = this.recipes[i];
                if (recipe == null || !ItemHandlerHelper.insertItem(this.output, (ItemStack)recipe.func_77571_b().func_77946_l(), (boolean)true).func_190926_b() || !ItemHandlerHelper.insertItem(this.output, (ItemStack)recipe.func_77571_b().func_77946_l(), (boolean)true).func_190926_b()) continue;
                this.input.setStackInSlot(i, ItemStack.field_190927_a);
                ItemHandlerHelper.insertItem(this.output, (ItemStack)recipe.func_77571_b().func_77946_l(), (boolean)false);
                this.tank.fillForced(new FluidStack((Fluid)ModuleCore.ESSENCE.getSourceFluid(), (int)(recipe.func_222138_b() * 20.0f)), IFluidHandler.FluidAction.EXECUTE);
            }
        };
    }

    protected EnergyStorageComponent<ResourcefulFurnaceTile> createEnergyStorage() {
        return new EnergyStorageComponent(ResourcefulFurnaceConfig.maxStoredPower, 10, 20);
    }

    @Override
    protected int getTickPower() {
        return this.getPowerPerTick;
    }

    @Nonnull
    public ResourcefulFurnaceTile getSelf() {
        return this;
    }
}

