/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.modules.router.blocks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ListCommand;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftoolsbase.api.xnet.channels.IChannelType;
import mcjty.rftoolsbase.api.xnet.channels.IConnectorSettings;
import mcjty.rftoolsbase.api.xnet.keys.NetworkId;
import mcjty.rftoolsbase.api.xnet.keys.SidedConsumer;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.xnet.client.ControllerChannelClientInfo;
import mcjty.xnet.compat.XNetTOPDriver;
import mcjty.xnet.logic.LogicTools;
import mcjty.xnet.modules.cables.CableColor;
import mcjty.xnet.modules.controller.ChannelInfo;
import mcjty.xnet.modules.controller.blocks.TileEntityController;
import mcjty.xnet.modules.router.LocalChannelId;
import mcjty.xnet.modules.router.RouterModule;
import mcjty.xnet.multiblock.ColorId;
import mcjty.xnet.multiblock.WirelessChannelKey;
import mcjty.xnet.multiblock.WorldBlob;
import mcjty.xnet.multiblock.XNetBlobData;
import mcjty.xnet.setup.Config;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.tuple.Pair;

public final class TileEntityRouter
extends GenericTileEntity {
    private final Map<LocalChannelId, String> publishedChannels = new HashMap<LocalChannelId, String>();
    private int channelCount = 0;
    public List<ControllerChannelClientInfo> clientLocalChannels = null;
    public List<ControllerChannelClientInfo> clientRemoteChannels = null;
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Router").containerSupplier(DefaultContainerProvider.empty(RouterModule.CONTAINER_ROUTER, (GenericTileEntity)this)));
    public static final Key<BlockPos> PARAM_POS = new Key("pos", Type.BLOCKPOS);
    public static final Key<Integer> PARAM_CHANNEL = new Key("channel", Type.INTEGER);
    public static final Key<String> PARAM_NAME = new Key("name", Type.STRING);
    @ServerCommand
    public static final Command<?> CMD_UPDATENAME = Command.create((String)"router.updateName", (te, player, params) -> te.updatePublishName((BlockPos)params.get(PARAM_POS), (Integer)params.get(PARAM_CHANNEL), (String)params.get(PARAM_NAME)));
    @ServerCommand(type=ControllerChannelClientInfo.class, serializer=ControllerChannelClientInfo.Serializer.class)
    public static final ListCommand<?, ?> CMD_GETCHANNELS = ListCommand.create((String)"xnet.router.getChannelInfo", (te, player, params) -> {
        ArrayList<ControllerChannelClientInfo> list = new ArrayList<ControllerChannelClientInfo>();
        te.findLocalChannelInfo(list, false, false);
        return list;
    }, (te, player, params, list) -> {
        te.clientLocalChannels = list;
    });
    @ServerCommand(type=ControllerChannelClientInfo.class, serializer=ControllerChannelClientInfo.Serializer.class)
    public static final ListCommand<?, ?> CMD_GETREMOTECHANNELS = ListCommand.create((String)"xnet.router.getRemoteChannelInfo", (te, player, params) -> {
        ArrayList<ControllerChannelClientInfo> list = new ArrayList<ControllerChannelClientInfo>();
        te.findRemoteChannelInfo(list);
        return list;
    }, (te, player, params, list) -> {
        te.clientRemoteChannels = list;
    });

    public TileEntityRouter() {
        super((TileEntityType)RouterModule.TYPE_ROUTER.get());
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().topDriver((TOPDriver)XNetTOPDriver.DRIVER).tileEntitySupplier(TileEntityRouter::new).manualEntry(ManualHelper.create((String)"xnet:network/router")).info(new InfoLine[]{TooltipBuilder.key((String)"message.xnet.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()})){

            protected void func_206840_a(@Nonnull StateContainer.Builder<Block, BlockState> builder) {
                super.func_206840_a(builder);
                builder.func_206894_a(new Property[]{TileEntityController.ERROR});
            }
        };
    }

    public void addPublishedChannels(Set<String> channels) {
        channels.addAll(this.publishedChannels.values());
    }

    public int countPublishedChannelsOnNet() {
        HashSet channels = new HashSet();
        NetworkId networkId = this.findRoutingNetwork();
        if (networkId != null) {
            LogicTools.routers(this.field_145850_b, networkId).forEach(router -> router.addPublishedChannels(channels));
        }
        return channels.size();
    }

    public boolean inError() {
        return this.channelCount > (Integer)Config.maxPublishedChannels.get();
    }

    public int getChannelCount() {
        return this.channelCount;
    }

    public void setChannelCount(int cnt) {
        if (this.channelCount == cnt) {
            return;
        }
        this.channelCount = cnt;
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (this.inError()) {
            if (!((Boolean)state.func_177229_b((Property)TileEntityController.ERROR)).booleanValue()) {
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)TileEntityController.ERROR, (Comparable)Boolean.valueOf(true)), 3);
            }
        } else if (((Boolean)state.func_177229_b((Property)TileEntityController.ERROR)).booleanValue()) {
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)TileEntityController.ERROR, (Comparable)Boolean.valueOf(false)), 3);
        }
        this.markDirtyQuick();
    }

    public void writeInfo(CompoundNBT tagCompound) {
        super.writeInfo(tagCompound);
        CompoundNBT info = this.getOrCreateInfo(tagCompound);
        info.func_74768_a("chancnt", this.channelCount);
        ListNBT published = new ListNBT();
        for (Map.Entry<LocalChannelId, String> entry : this.publishedChannels.entrySet()) {
            CompoundNBT tc = new CompoundNBT();
            BlockPosTools.write((CompoundNBT)tc, (String)"pos", (BlockPos)entry.getKey().getControllerPos());
            tc.func_74768_a("index", entry.getKey().getIndex());
            tc.func_74778_a("name", entry.getValue());
            published.add((Object)tc);
        }
        info.func_218657_a("published", (INBT)published);
    }

    public void readInfo(CompoundNBT tagCompound) {
        super.readInfo(tagCompound);
        CompoundNBT info = tagCompound.func_74775_l("Info");
        this.channelCount = info.func_74762_e("chancnt");
        ListNBT published = info.func_150295_c("published", 10);
        for (int i = 0; i < published.size(); ++i) {
            CompoundNBT tc = published.func_150305_b(i);
            LocalChannelId id = new LocalChannelId(BlockPosTools.read((CompoundNBT)tc, (String)"pos"), tc.func_74762_e("index"));
            String name = tc.func_74779_i("name");
            this.publishedChannels.put(id, name);
        }
    }

    public Stream<Pair<String, IChannelType>> publishedChannelStream() {
        return LogicTools.connectors(this.field_145850_b, this.field_174879_c).map(connectorPos -> LogicTools.getControllerForConnector(this.field_145850_b, connectorPos)).filter(Objects::nonNull).flatMap(controller -> IntStream.range(0, 8).mapToObj(i -> {
            LocalChannelId id;
            String publishedName;
            ChannelInfo channelInfo = controller.getChannels()[i];
            if (channelInfo != null && !channelInfo.getChannelName().isEmpty() && (publishedName = this.publishedChannels.get(id = new LocalChannelId(controller.func_174877_v(), i))) != null && !publishedName.isEmpty()) {
                return Pair.of((Object)publishedName, (Object)channelInfo.getType());
            }
            return null;
        }).filter(Objects::nonNull));
    }

    public void findLocalChannelInfo(List<ControllerChannelClientInfo> list, boolean onlyPublished, boolean remote) {
        LogicTools.connectors(this.field_145850_b, this.func_174877_v()).map(connectorPos -> LogicTools.getControllerForConnector(this.field_145850_b, connectorPos)).filter(Objects::nonNull).forEach(controller -> {
            for (int i = 0; i < 8; ++i) {
                ChannelInfo channelInfo = controller.getChannels()[i];
                if (channelInfo == null || channelInfo.getChannelName().isEmpty()) continue;
                LocalChannelId id = new LocalChannelId(controller.func_174877_v(), i);
                String publishedName = this.publishedChannels.get(id);
                if (publishedName == null) {
                    publishedName = "";
                }
                if (onlyPublished && publishedName.isEmpty()) continue;
                ControllerChannelClientInfo ci = new ControllerChannelClientInfo(channelInfo.getChannelName(), publishedName, controller.func_174877_v(), channelInfo.getType(), remote, i);
                if (!list.stream().noneMatch(ii -> Objects.equals(ii.getPublishedName(), ci.getPublishedName()) && Objects.equals(ii.getChannelName(), ci.getChannelName()) && Objects.equals(ii.getChannelType(), ci.getChannelType()) && Objects.equals(ii.getPos(), ci.getPos()))) continue;
                list.add(ci);
            }
        });
    }

    private void findRemoteChannelInfo(List<ControllerChannelClientInfo> list) {
        NetworkId networkId = this.findRoutingNetwork();
        if (networkId != null) {
            LogicTools.consumers(this.field_145850_b, networkId).forEach(consumerPos -> {
                LogicTools.routers(this.field_145850_b, consumerPos).filter(r -> r != this).forEach(router -> router.findLocalChannelInfo(list, true, false));
                LogicTools.wirelessRouters(this.field_145850_b, consumerPos).filter(router -> !router.inError()).forEach(router -> router.findRemoteChannelInfo(list));
            });
        }
    }

    @Nullable
    public NetworkId findRoutingNetwork() {
        WorldBlob worldBlob = XNetBlobData.get(this.field_145850_b).getWorldBlob(this.field_145850_b);
        return LogicTools.routingConnectors(this.field_145850_b, this.func_174877_v()).findFirst().map(worldBlob::getNetworkAt).orElse(null);
    }

    public void addRoutedConnectors(Map<SidedConsumer, IConnectorSettings> connectors, @Nonnull BlockPos controllerPos, int channel, IChannelType type, Map<WirelessChannelKey, Integer> wirelessVersions) {
        if (this.inError()) {
            return;
        }
        LocalChannelId id = new LocalChannelId(controllerPos, channel);
        String publishedName = this.publishedChannels.get(id);
        if (publishedName != null && !publishedName.isEmpty()) {
            NetworkId networkId = this.findRoutingNetwork();
            if (networkId != null) {
                LogicTools.consumers(this.field_145850_b, networkId).forEach(consumerPos -> {
                    LogicTools.routers(this.field_145850_b, consumerPos).forEach(router -> router.addConnectorsFromConnectedNetworks(connectors, publishedName, type));
                    LogicTools.wirelessRouters(this.field_145850_b, consumerPos).filter(router -> !router.inError()).forEach(router -> {
                        router.addWirelessConnectors(connectors, publishedName, type, null, wirelessVersions);
                        router.addWirelessConnectors(connectors, publishedName, type, this.getOwnerUUID(), wirelessVersions);
                    });
                });
            } else {
                this.addConnectorsFromConnectedNetworks(connectors, publishedName, type);
            }
        }
    }

    public boolean addConnectorsFromConnectedNetworks(Map<SidedConsumer, IConnectorSettings> connectors, String channelName, IChannelType type) {
        AtomicBoolean rc = new AtomicBoolean(false);
        LogicTools.connectors(this.field_145850_b, this.func_174877_v()).map(connectorPos -> LogicTools.getControllerForConnector(this.field_145850_b, connectorPos)).filter(Objects::nonNull).forEach(controller -> {
            for (int i = 0; i < 8; ++i) {
                String publishedName;
                ChannelInfo info = controller.getChannels()[i];
                if (info == null || (publishedName = this.publishedChannels.get(new LocalChannelId(controller.func_174877_v(), i))) == null || publishedName.isEmpty() || !channelName.equals(publishedName) || !type.equals(info.getType())) continue;
                connectors.putAll(controller.getConnectors(i));
                rc.set(true);
            }
        });
        return rc.get();
    }

    private void updatePublishName(@Nonnull BlockPos controllerPos, int channel, String name) {
        LocalChannelId id = new LocalChannelId(controllerPos, channel);
        if (name == null || name.isEmpty()) {
            this.publishedChannels.remove(id);
        } else {
            this.publishedChannels.put(id, name);
        }
        int number = this.countPublishedChannelsOnNet();
        WorldBlob worldBlob = XNetBlobData.get(this.field_145850_b).getWorldBlob(this.field_145850_b);
        NetworkId networkId = this.findRoutingNetwork();
        if (networkId != null) {
            if (number != this.channelCount) {
                LogicTools.routers(this.field_145850_b, networkId).forEach(router -> router.setChannelCount(number));
            }
            worldBlob.markNetworkDirty(networkId);
        }
        for (NetworkId net : worldBlob.getNetworksAt(this.field_174879_c)) {
            worldBlob.markNetworkDirty(net);
        }
        for (Direction facing : OrientationTools.DIRECTION_VALUES) {
            for (NetworkId net : worldBlob.getNetworksAt(this.field_174879_c.func_177972_a(facing))) {
                worldBlob.markNetworkDirty(net);
            }
        }
        this.markDirtyQuick();
    }

    public void onReplaced(World world, BlockPos pos, BlockState state, BlockState newstate) {
        if (state.func_177230_c() == newstate.func_177230_c()) {
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            XNetBlobData blobData = XNetBlobData.get(this.field_145850_b);
            WorldBlob worldBlob = blobData.getWorldBlob(this.field_145850_b);
            worldBlob.removeCableSegment(pos);
            blobData.save();
        }
    }

    public void onBlockPlacedBy(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.onBlockPlacedBy(world, pos, state, placer, stack);
        if (!world.field_72995_K) {
            XNetBlobData blobData = XNetBlobData.get(world);
            WorldBlob worldBlob = blobData.getWorldBlob(world);
            NetworkId networkId = worldBlob.newNetwork();
            worldBlob.createNetworkProvider(pos, new ColorId(CableColor.ROUTING.ordinal() + 1), networkId);
            blobData.save();
        }
    }
}

