/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.modules.controller.blocks;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ListCommand;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.Cached;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftoolsbase.api.xnet.channels.IChannelSettings;
import mcjty.rftoolsbase.api.xnet.channels.IChannelType;
import mcjty.rftoolsbase.api.xnet.channels.IConnectorSettings;
import mcjty.rftoolsbase.api.xnet.channels.IControllerContext;
import mcjty.rftoolsbase.api.xnet.keys.ConsumerId;
import mcjty.rftoolsbase.api.xnet.keys.NetworkId;
import mcjty.rftoolsbase.api.xnet.keys.SidedConsumer;
import mcjty.rftoolsbase.api.xnet.keys.SidedPos;
import mcjty.rftoolsbase.api.xnet.net.IWorldBlob;
import mcjty.rftoolsbase.modules.filter.items.FilterModuleItem;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.xnet.XNet;
import mcjty.xnet.client.ChannelClientInfo;
import mcjty.xnet.client.ConnectedBlockClientInfo;
import mcjty.xnet.client.ConnectorClientInfo;
import mcjty.xnet.client.ConnectorInfo;
import mcjty.xnet.compat.XNetTOPDriver;
import mcjty.xnet.logic.LogicTools;
import mcjty.xnet.modules.cables.CableModule;
import mcjty.xnet.modules.cables.blocks.ConnectorBlock;
import mcjty.xnet.modules.cables.blocks.ConnectorTileEntity;
import mcjty.xnet.modules.controller.ChannelInfo;
import mcjty.xnet.modules.controller.ConnectedBlockInfo;
import mcjty.xnet.modules.controller.ControllerModule;
import mcjty.xnet.modules.controller.KnownUnsidedBlocks;
import mcjty.xnet.modules.controller.network.PacketControllerError;
import mcjty.xnet.modules.controller.network.PacketJsonToClipboard;
import mcjty.xnet.multiblock.ColorId;
import mcjty.xnet.multiblock.NetworkChecker;
import mcjty.xnet.multiblock.WirelessChannelKey;
import mcjty.xnet.multiblock.WorldBlob;
import mcjty.xnet.multiblock.XNetBlobData;
import mcjty.xnet.multiblock.XNetWirelessChannels;
import mcjty.xnet.setup.Config;
import mcjty.xnet.setup.XNetMessages;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkDirection;
import org.apache.commons.lang3.tuple.Pair;

public final class TileEntityController
extends GenericTileEntity
implements ITickableTileEntity,
IControllerContext {
    public static final Key<Integer> PARAM_INDEX = new Key("index", Type.INTEGER);
    public static final Key<String> PARAM_TYPE = new Key("type", Type.STRING);
    public static final Key<String> PARAM_JSON = new Key("json", Type.STRING);
    public static final Key<Integer> PARAM_CHANNEL = new Key("channel", Type.INTEGER);
    public static final Key<Integer> PARAM_SIDE = new Key("side", Type.INTEGER);
    public static final Key<BlockPos> PARAM_POS = new Key("pos", Type.BLOCKPOS);
    public static final BooleanProperty ERROR = BooleanProperty.func_177716_a((String)"error");
    public static final int SLOT_FILTER = 0;
    public static final int FILTER_SLOTS = 4;
    public List<ChannelClientInfo> clientChannels = null;
    public List<ConnectedBlockClientInfo> clientConnectedBlocks = null;
    private final Predicate<ItemStack>[] filterCaches = new Predicate[4];
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(4).box(SlotDefinition.specific(s -> s.func_77973_b() instanceof FilterModuleItem), 0, 17, 5, 4, 1).playerSlots(91, 157));
    private NetworkId networkId;
    private final ChannelInfo[] channels = new ChannelInfo[8];
    private int colors = 0;
    private final Map<SidedConsumer, IConnectorSettings>[] cachedConnectors = new Map[8];
    private final Map<SidedConsumer, IConnectorSettings>[] cachedRoutedConnectors = new Map[8];
    private final Map<WirelessChannelKey, Integer> wirelessVersions = new HashMap<WirelessChannelKey, Integer>();
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).itemValid((slot, stack) -> stack.func_77973_b() instanceof FilterModuleItem).onUpdate((slot, stack) -> this.clearFilterCache()).build();
    @Cap(type=CapType.ENERGY)
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)Config.controllerMaxRF.get()).intValue(), (long)((Integer)Config.controllerRfPerTick.get()).intValue());
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Controller").containerSupplier(DefaultContainerProvider.container(ControllerModule.CONTAINER_CONTROLLER, CONTAINER_FACTORY, (GenericTileEntity)this)).itemHandler(() -> this.items).energyHandler(() -> this.energyStorage).setupSync((GenericTileEntity)this));
    private final Cached<NetworkChecker> networkChecker = Cached.of(this::createNetworkChecker);
    @ServerCommand
    public static final Command<?> CMD_CREATECONNECTOR = Command.create((String)"controller.createConnector", (te, player, params) -> te.createConnector((Integer)params.get(PARAM_CHANNEL), new SidedPos((BlockPos)params.get(PARAM_POS), OrientationTools.DIRECTION_VALUES[(Integer)params.get(PARAM_SIDE)])));
    @ServerCommand
    public static final Command<?> CMD_REMOVECONNECTOR = Command.create((String)"controller.removeConnector", (te, player, params) -> te.removeConnector((Integer)params.get(PARAM_CHANNEL), new SidedPos((BlockPos)params.get(PARAM_POS), OrientationTools.DIRECTION_VALUES[(Integer)params.get(PARAM_SIDE)])));
    @ServerCommand
    public static final Command<?> CMD_UPDATECONNECTOR = Command.create((String)"controller.updateConnector", (te, player, params) -> te.updateConnector((Integer)params.get(PARAM_CHANNEL), new SidedPos((BlockPos)params.get(PARAM_POS), OrientationTools.DIRECTION_VALUES[(Integer)params.get(PARAM_SIDE)]), params));
    @ServerCommand
    public static final Command<?> CMD_CREATECHANNEL = Command.create((String)"controller.createChannel", (te, player, params) -> te.createChannel((Integer)params.get(PARAM_INDEX), (String)params.get(PARAM_TYPE)));
    @ServerCommand
    public static final Command<?> CMD_PASTECHANNEL = Command.create((String)"controller.pasteChannel", (te, player, params) -> te.pasteChannel(player, (Integer)params.get(PARAM_INDEX), (String)params.get(PARAM_JSON)));
    @ServerCommand
    public static final Command<?> CMD_COPYCHANNEL = Command.create((String)"controller.copyChannel", (te, player, params) -> te.copyChannel(player, (Integer)params.get(PARAM_INDEX)));
    @ServerCommand
    public static final Command<?> CMD_PASTECONNECTOR = Command.create((String)"controller.pasteConnector", (te, player, params) -> te.pasteConnector(player, (Integer)params.get(PARAM_INDEX), new SidedPos((BlockPos)params.get(PARAM_POS), OrientationTools.DIRECTION_VALUES[(Integer)params.get(PARAM_SIDE)]), (String)params.get(PARAM_JSON)));
    @ServerCommand
    public static final Command<?> CMD_COPYCONNECTOR = Command.create((String)"controller.copyConnector", (te, player, params) -> te.copyConnector(player, (Integer)params.get(PARAM_INDEX), new SidedPos((BlockPos)params.get(PARAM_POS), OrientationTools.DIRECTION_VALUES[(Integer)params.get(PARAM_SIDE)])));
    @ServerCommand
    public static final Command<?> CMD_REMOVECHANNEL = Command.create((String)"controller.removeChannel", (te, player, params) -> te.removeChannel((Integer)params.get(PARAM_INDEX)));
    @ServerCommand
    public static final Command<?> CMD_UPDATECHANNEL = Command.create((String)"controller.updateChannel", (te, player, params) -> te.updateChannel((Integer)params.get(PARAM_CHANNEL), params));
    @ServerCommand(type=ChannelClientInfo.class, serializer=ChannelClientInfo.Serializer.class)
    public static final ListCommand<?, ?> CMD_GETCHANNELS = ListCommand.create((String)"xnet.controller.getChannelInfo", (te, player, params) -> te.findChannelInfo(), (te, player, params, list) -> {
        te.clientChannels = list;
    });
    @ServerCommand(type=ConnectedBlockClientInfo.class, serializer=ConnectedBlockClientInfo.Serializer.class)
    public static final ListCommand<?, ?> CMD_GETCONNECTEDBLOCKS = ListCommand.create((String)"xnet.controller.getConnectedBlocks", (te, player, params) -> te.findConnectedBlocksForClient(), (te, player, params, list) -> {
        te.clientConnectedBlocks = list;
    });

    public TileEntityController() {
        super((TileEntityType)ControllerModule.TYPE_CONTROLLER.get());
        for (int i = 0; i < 8; ++i) {
            this.channels[i] = null;
        }
    }

    private void clearFilterCache() {
        for (int i = 0; i < 4; ++i) {
            this.filterCaches[i] = null;
        }
    }

    @Nonnull
    public Predicate<ItemStack> getIndexedFilter(int idx) {
        if (idx < 0 || idx >= 4) {
            return stack -> false;
        }
        if (this.filterCaches[idx] == null) {
            ItemStack stack2 = this.items.getStackInSlot(idx);
            this.filterCaches[idx] = stack2.func_77973_b() instanceof FilterModuleItem ? FilterModuleItem.getCache((ItemStack)stack2) : s -> false;
        }
        return this.filterCaches[idx];
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().topDriver((TOPDriver)XNetTOPDriver.DRIVER).tileEntitySupplier(TileEntityController::new).manualEntry(ManualHelper.create((String)"xnet:simple/controller")).info(new InfoLine[]{TooltipBuilder.key((String)"message.xnet.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()})){

            protected void func_206840_a(@Nonnull StateContainer.Builder<Block, BlockState> builder) {
                super.func_206840_a(builder);
                builder.func_206894_a(new Property[]{ERROR});
            }
        };
    }

    private NetworkChecker createNetworkChecker() {
        NetworkChecker checker = new NetworkChecker();
        checker.add(this.networkId);
        WorldBlob worldBlob = XNetBlobData.get(this.field_145850_b).getWorldBlob(this.field_145850_b);
        LogicTools.routers(this.field_145850_b, this.networkId).forEach(router -> {
            checker.add(worldBlob.getNetworksAt(router.func_174877_v()));
            NetworkId routerNetwork = worldBlob.getNetworkAt(router.func_174877_v());
            if (routerNetwork != null) {
                LogicTools.routers(this.field_145850_b, routerNetwork).filter(r -> router != r).forEach(r -> LogicTools.connectors(this.field_145850_b, r.func_174877_v()).forEach(connectorPos -> checker.add(worldBlob.getNetworkAt((BlockPos)connectorPos))));
            }
        });
        return checker;
    }

    public World getControllerWorld() {
        return this.field_145850_b;
    }

    public NetworkId getNetworkId() {
        return this.networkId;
    }

    public void setNetworkId(NetworkId networkId) {
        if (networkId == null && this.networkId == null) {
            return;
        }
        if (networkId != null && networkId.equals((Object)this.networkId)) {
            return;
        }
        this.networkChecker.clear();
        this.networkId = networkId;
        this.markDirtyQuick();
    }

    public ChannelInfo[] getChannels() {
        return this.channels;
    }

    public Cached<NetworkChecker> getNetworkChecker() {
        return this.networkChecker;
    }

    private void checkNetwork(WorldBlob worldBlob) {
        if (this.networkId != null && ((NetworkChecker)this.networkChecker.get()).isDirtyAndMarkClean(worldBlob)) {
            this.cleanCaches();
            return;
        }
        for (Map.Entry<WirelessChannelKey, Integer> entry : this.wirelessVersions.entrySet()) {
            XNetWirelessChannels channels = XNetWirelessChannels.get(this.field_145850_b);
            XNetWirelessChannels.WirelessChannelInfo channel = channels.findChannel(entry.getKey());
            if (channel == null) {
                this.cleanCaches();
                return;
            }
            if (channel.getVersion() == entry.getValue().intValue()) continue;
            this.cleanCaches();
            return;
        }
    }

    private void cleanCaches() {
        for (int i = 0; i < 8; ++i) {
            if (this.channels[i] == null) continue;
            this.cleanCache(i);
        }
    }

    public boolean matchColor(int colorMask) {
        return (this.colors & colorMask) == colorMask;
    }

    public int getColors() {
        return this.colors;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            WorldBlob worldBlob = XNetBlobData.get(this.field_145850_b).getWorldBlob(this.field_145850_b);
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (worldBlob.getNetworksAt(this.func_174877_v()).size() > 1) {
                if (!((Boolean)state.func_177229_b((Property)ERROR)).booleanValue()) {
                    this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)ERROR, (Comparable)Boolean.valueOf(true)), 3);
                }
                return;
            }
            if (((Boolean)state.func_177229_b((Property)ERROR)).booleanValue()) {
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)ERROR, (Comparable)Boolean.valueOf(false)), 3);
            }
            this.checkNetwork(worldBlob);
            if (!this.checkAndConsumeRF((Integer)Config.controllerRFT.get())) {
                return;
            }
            boolean dirty = false;
            int newcolors = 0;
            for (int i = 0; i < 8; ++i) {
                if (this.channels[i] == null || !this.channels[i].isEnabled()) continue;
                if (this.checkAndConsumeRF((Integer)Config.controllerChannelRFT.get())) {
                    this.channels[i].getChannelSettings().tick(i, (IControllerContext)this);
                }
                newcolors |= this.channels[i].getChannelSettings().getColors();
                dirty = true;
            }
            if (newcolors != this.colors) {
                dirty = true;
                this.colors = newcolors;
            }
            if (dirty) {
                this.markDirtyQuick();
            }
        }
    }

    public boolean checkAndConsumeRF(int rft) {
        if (rft > 0) {
            if (this.energyStorage.getEnergy() < (long)rft) {
                return false;
            }
            this.energyStorage.consumeEnergy((long)rft);
            this.markDirtyQuick();
        }
        return true;
    }

    private void networkDirty() {
        if (this.networkId != null) {
            XNetBlobData.get(this.field_145850_b).getWorldBlob(this.field_145850_b).markNetworkDirty(this.networkId);
        }
    }

    private void cleanCache(int channel) {
        this.cachedConnectors[channel] = null;
        this.cachedRoutedConnectors[channel] = null;
        this.channels[channel].getChannelSettings().cleanCache();
    }

    @Nonnull
    public Map<SidedConsumer, IConnectorSettings> getConnectors(int channel) {
        if (this.cachedConnectors[channel] == null) {
            WorldBlob worldBlob = XNetBlobData.get(this.field_145850_b).getWorldBlob(this.field_145850_b);
            this.cachedConnectors[channel] = new HashMap<SidedConsumer, IConnectorSettings>();
            for (Map.Entry<SidedConsumer, ConnectorInfo> entry : this.channels[channel].getConnectors().entrySet()) {
                SidedConsumer sidedConsumer = entry.getKey();
                BlockPos pos = this.findConsumerPosition(sidedConsumer.getConsumerId());
                if (pos == null || !worldBlob.getNetworksAt(pos).contains(this.getNetworkId())) continue;
                this.cachedConnectors[channel].put(sidedConsumer, entry.getValue().getConnectorSettings());
            }
        }
        return this.cachedConnectors[channel];
    }

    @Nonnull
    public Map<SidedConsumer, IConnectorSettings> getRoutedConnectors(int channel) {
        if (this.cachedRoutedConnectors[channel] == null) {
            this.cachedRoutedConnectors[channel] = new HashMap<SidedConsumer, IConnectorSettings>();
            this.wirelessVersions.clear();
            if (!this.channels[channel].getChannelName().isEmpty()) {
                LogicTools.routers(this.field_145850_b, this.networkId).forEach(router -> router.addRoutedConnectors(this.cachedRoutedConnectors[channel], this.func_174877_v(), channel, this.channels[channel].getType(), this.wirelessVersions));
            }
        }
        return this.cachedRoutedConnectors[channel];
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT tagCompound) {
        if (this.networkId != null) {
            tagCompound.func_74768_a("networkId", this.networkId.getId());
        }
        return super.func_189515_b(tagCompound);
    }

    public void read(CompoundNBT tagCompound) {
        super.read(tagCompound);
        this.networkId = tagCompound.func_74764_b("networkId") ? new NetworkId(tagCompound.func_74762_e("networkId")) : null;
    }

    protected void writeInfo(CompoundNBT tagCompound) {
        super.writeInfo(tagCompound);
        CompoundNBT info = this.getOrCreateInfo(tagCompound);
        info.func_74768_a("colors", this.colors);
        for (int i = 0; i < 8; ++i) {
            if (this.channels[i] == null) continue;
            CompoundNBT tc = new CompoundNBT();
            tc.func_74778_a("type", this.channels[i].getType().getID());
            this.channels[i].writeToNBT(tc);
            info.func_218657_a("channel" + i, (INBT)tc);
        }
    }

    public void readInfo(CompoundNBT tagCompound) {
        super.readInfo(tagCompound);
        CompoundNBT info = tagCompound.func_74775_l("Info");
        this.colors = info.func_74762_e("colors");
        for (int i = 0; i < 8; ++i) {
            if (info.func_74764_b("channel" + i)) {
                CompoundNBT tc = info.func_74775_l("channel" + i);
                String id = tc.func_74779_i("type");
                IChannelType type = XNet.xNetApi.findType(id);
                if (type == null) {
                    XNet.setup.getLogger().warn("Unsupported type " + id + "!");
                    continue;
                }
                this.channels[i] = new ChannelInfo(type);
                this.channels[i].readFromNBT(tc);
                continue;
            }
            this.channels[i] = null;
        }
    }

    @Nullable
    public BlockPos findConsumerPosition(@Nonnull ConsumerId consumerId) {
        WorldBlob worldBlob = XNetBlobData.get(this.field_145850_b).getWorldBlob(this.field_145850_b);
        return this.findConsumerPosition(worldBlob, consumerId);
    }

    @Nullable
    private BlockPos findConsumerPosition(@Nonnull WorldBlob worldBlob, @Nonnull ConsumerId consumerId) {
        return worldBlob.getConsumerPosition(consumerId);
    }

    public List<SidedPos> getConnectedBlockPositions() {
        WorldBlob worldBlob = XNetBlobData.get(this.field_145850_b).getWorldBlob(this.field_145850_b);
        ArrayList<SidedPos> result = new ArrayList<SidedPos>();
        HashSet set = new HashSet();
        Stream<BlockPos> consumers = this.getConsumerStream(worldBlob);
        consumers.forEach(consumerPos -> {
            String name = "";
            TileEntity te = this.field_145850_b.func_175625_s(consumerPos);
            if (te instanceof ConnectorTileEntity) {
                name = ((ConnectorTileEntity)te).getConnectorName();
            } else {
                XNet.setup.getLogger().warn("What? The connector at " + BlockPosTools.toString((BlockPos)consumerPos) + " is not a connector?");
            }
            for (Direction facing : OrientationTools.DIRECTION_VALUES) {
                if (!ConnectorBlock.isConnectable((IBlockReader)this.field_145850_b, consumerPos, facing)) continue;
                BlockPos pos = consumerPos.func_177972_a(facing);
                SidedPos sidedPos = new SidedPos(pos, facing.func_176734_d());
                result.add(sidedPos);
            }
        });
        return result;
    }

    @Nonnull
    private List<ConnectedBlockClientInfo> findConnectedBlocksForClient() {
        WorldBlob worldBlob = XNetBlobData.get(this.field_145850_b).getWorldBlob(this.field_145850_b);
        HashSet set = new HashSet();
        Stream<BlockPos> consumers = this.getConsumerStream(worldBlob);
        consumers.forEach(consumerPos -> {
            String name = "";
            TileEntity te = this.field_145850_b.func_175625_s(consumerPos);
            if (te instanceof ConnectorTileEntity) {
                name = ((ConnectorTileEntity)te).getConnectorName();
            } else {
                XNet.setup.getLogger().warn("What? The connector at " + BlockPosTools.toString((BlockPos)consumerPos) + " is not a connector?");
            }
            for (Direction facing : OrientationTools.DIRECTION_VALUES) {
                if (!ConnectorBlock.isConnectable((IBlockReader)this.field_145850_b, consumerPos, facing)) continue;
                BlockPos pos = consumerPos.func_177972_a(facing);
                SidedPos sidedPos = new SidedPos(pos, facing.func_176734_d());
                BlockState state = this.field_145850_b.func_180495_p(pos);
                ItemStack item = state.func_177230_c().func_185473_a((IBlockReader)this.field_145850_b, pos, state);
                ConnectedBlockClientInfo info = new ConnectedBlockClientInfo(sidedPos, item, name);
                set.add(info);
            }
        });
        ArrayList<ConnectedBlockClientInfo> list = new ArrayList<ConnectedBlockClientInfo>(set);
        list.sort(Comparator.comparing(ConnectedBlockClientInfo::getBlockUnlocName).thenComparing(ConnectedBlockClientInfo::getPos));
        return list;
    }

    private Stream<BlockPos> getConsumerStream(WorldBlob worldBlob) {
        return XNet.xNetApi.getConsumerProviders().stream().map(provider -> provider.getConsumers(this.field_145850_b, (IWorldBlob)worldBlob, this.getNetworkId()).stream()).flatMap(s -> s);
    }

    @Nonnull
    private List<ChannelClientInfo> findChannelInfo() {
        WorldBlob worldBlob = XNetBlobData.get(this.field_145850_b).getWorldBlob(this.field_145850_b);
        ArrayList<ChannelClientInfo> chanList = new ArrayList<ChannelClientInfo>();
        for (ChannelInfo channel : this.channels) {
            if (channel != null) {
                ChannelClientInfo clientInfo = new ChannelClientInfo(channel.getChannelName(), channel.getType(), channel.getChannelSettings(), channel.isEnabled());
                for (Map.Entry<SidedConsumer, ConnectorInfo> entry : channel.getConnectors().entrySet()) {
                    BlockPos consumerPos;
                    SidedConsumer sidedConsumer = entry.getKey();
                    ConnectorInfo info = entry.getValue();
                    if (info.getConnectorSettings() == null || (consumerPos = this.findConsumerPosition(worldBlob, sidedConsumer.getConsumerId())) == null) continue;
                    SidedPos pos = new SidedPos(consumerPos.func_177972_a(sidedConsumer.getSide()), sidedConsumer.getSide().func_176734_d());
                    boolean advanced = this.field_145850_b.func_180495_p(consumerPos).func_177230_c() == CableModule.ADVANCED_CONNECTOR.get();
                    ConnectorClientInfo ci = new ConnectorClientInfo(pos, sidedConsumer.getConsumerId(), channel.getType(), info.getConnectorSettings());
                    clientInfo.getConnectors().put(sidedConsumer, ci);
                }
                chanList.add(clientInfo);
                continue;
            }
            chanList.add(null);
        }
        return chanList;
    }

    private void updateChannel(int channel, TypedMap params) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        for (Key key : params.getKeys()) {
            data.put(key.getName(), params.get(key));
        }
        this.channels[channel].getChannelSettings().update(data);
        Boolean enabled = (Boolean)data.get("enabled");
        this.channels[channel].setEnabled(Boolean.TRUE.equals(enabled));
        String name = (String)data.get("name");
        this.channels[channel].setChannelName(name);
        this.markAsDirty();
    }

    public void markAsDirty() {
        this.networkDirty();
        this.markDirtyQuick();
    }

    private void removeChannel(int channel) {
        this.channels[channel] = null;
        this.cachedConnectors[channel] = null;
        this.cachedRoutedConnectors[channel] = null;
        this.markAsDirty();
    }

    private void createChannel(int channel, String typeId) {
        IChannelType type = XNet.xNetApi.findType(typeId);
        this.channels[channel] = new ChannelInfo(type);
        this.markAsDirty();
    }

    private void updateConnector(int channel, SidedPos pos, TypedMap params) {
        WorldBlob worldBlob = XNetBlobData.get(this.field_145850_b).getWorldBlob(this.field_145850_b);
        ConsumerId consumerId = worldBlob.getConsumerAt(pos.getPos().func_177972_a(pos.getSide()));
        for (Map.Entry<SidedConsumer, ConnectorInfo> entry : this.channels[channel].getConnectors().entrySet()) {
            SidedConsumer key = entry.getKey();
            if (!key.getConsumerId().equals((Object)consumerId) || !key.getSide().func_176734_d().equals((Object)pos.getSide())) continue;
            HashMap<String, Object> data = new HashMap<String, Object>();
            for (Key k : params.getKeys()) {
                data.put(k.getName(), params.get(k));
            }
            this.channels[channel].getConnectors().get(key).getConnectorSettings().update(data);
            this.markAsDirty();
            return;
        }
    }

    private void removeConnector(int channel, SidedPos pos) {
        WorldBlob worldBlob = XNetBlobData.get(this.field_145850_b).getWorldBlob(this.field_145850_b);
        ConsumerId consumerId = worldBlob.getConsumerAt(pos.getPos().func_177972_a(pos.getSide()));
        SidedConsumer toremove = null;
        for (Map.Entry<SidedConsumer, ConnectorInfo> entry : this.channels[channel].getConnectors().entrySet()) {
            SidedConsumer key = entry.getKey();
            if (!key.getSide().func_176734_d().equals((Object)pos.getSide()) || !key.getConsumerId().equals((Object)consumerId)) continue;
            toremove = key;
            break;
        }
        if (toremove != null) {
            this.channels[channel].getConnectors().remove(toremove);
            this.markAsDirty();
        }
    }

    private ConnectorInfo createConnector(int channel, SidedPos pos) {
        BlockPos consumerPos;
        WorldBlob worldBlob = XNetBlobData.get(this.field_145850_b).getWorldBlob(this.field_145850_b);
        ConsumerId consumerId = worldBlob.getConsumerAt(consumerPos = pos.getPos().func_177972_a(pos.getSide()));
        if (consumerId == null) {
            throw new RuntimeException("What?");
        }
        SidedConsumer id = new SidedConsumer(consumerId, pos.getSide().func_176734_d());
        boolean advanced = this.field_145850_b.func_180495_p(consumerPos).func_177230_c() == CableModule.ADVANCED_CONNECTOR.get();
        ConnectorInfo info = this.channels[channel].createConnector(id, advanced);
        this.markAsDirty();
        return info;
    }

    private IConnectorSettings findConnectorSettings(ChannelInfo channel, SidedPos p) {
        WorldBlob worldBlob = XNetBlobData.get(this.field_145850_b).getWorldBlob(this.field_145850_b);
        for (Map.Entry<SidedConsumer, ConnectorInfo> entry : channel.getConnectors().entrySet()) {
            SidedPos pos;
            BlockPos consumerPos;
            SidedConsumer sidedConsumer = entry.getKey();
            ConnectorInfo info = entry.getValue();
            if (info.getConnectorSettings() == null || (consumerPos = this.findConsumerPosition(worldBlob, sidedConsumer.getConsumerId())) == null || !(pos = new SidedPos(consumerPos.func_177972_a(sidedConsumer.getSide()), sidedConsumer.getSide().func_176734_d())).equals((Object)p)) continue;
            return info.getConnectorSettings();
        }
        return null;
    }

    @Nonnull
    private Set<ConnectedBlockInfo> findConnectedBlocks() {
        WorldBlob worldBlob = XNetBlobData.get(this.field_145850_b).getWorldBlob(this.field_145850_b);
        HashSet<ConnectedBlockInfo> set = new HashSet<ConnectedBlockInfo>();
        Stream<BlockPos> consumers = this.getConsumerStream(worldBlob);
        consumers.forEach(consumerPos -> {
            String name = "";
            TileEntity te = this.field_145850_b.func_175625_s(consumerPos);
            if (te instanceof ConnectorTileEntity) {
                name = ((ConnectorTileEntity)te).getConnectorName();
            } else {
                XNet.setup.getLogger().warn("What? The connector at " + BlockPosTools.toString((BlockPos)consumerPos) + " is not a connector?");
            }
            for (Direction facing : OrientationTools.DIRECTION_VALUES) {
                if (!ConnectorBlock.isConnectable((IBlockReader)this.field_145850_b, consumerPos, facing)) continue;
                BlockPos pos = consumerPos.func_177972_a(facing);
                SidedPos sidedPos = new SidedPos(pos, facing.func_176734_d());
                BlockState state = this.field_145850_b.func_180495_p(pos);
                state = state.func_177230_c().isAir(state, (IBlockReader)this.field_145850_b, pos) ? null : state;
                ConnectedBlockInfo info = new ConnectedBlockInfo(sidedPos, state, name);
                set.add(info);
            }
        });
        return set;
    }

    private void copyConnector(PlayerEntity player, int index, SidedPos sidedPos) {
        JsonObject object;
        ChannelInfo channel = this.channels[index];
        IChannelSettings settings = channel.getChannelSettings();
        JsonObject parent = new JsonObject();
        IConnectorSettings connectorSettings = this.findConnectorSettings(channel, sidedPos);
        if (connectorSettings != null && (object = connectorSettings.writeToJson()) != null) {
            parent.add("type", (JsonElement)new JsonPrimitive(channel.getType().getID()));
            parent.add("connector", (JsonElement)object);
            boolean advanced = ConnectorBlock.isAdvancedConnector(this.field_145850_b, sidedPos.getPos().func_177972_a(sidedPos.getSide()));
            parent.add("advanced", (JsonElement)new JsonPrimitive(Boolean.valueOf(advanced)));
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String json = gson.toJson((JsonElement)parent);
            XNetMessages.INSTANCE.sendTo((Object)new PacketJsonToClipboard(json), ((ServerPlayerEntity)player).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
            return;
        }
        XNetMessages.INSTANCE.sendTo((Object)new PacketControllerError("Error copying connector!"), ((ServerPlayerEntity)player).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
    }

    private void copyChannel(PlayerEntity player, int index) {
        ChannelInfo channel = this.channels[index];
        IChannelSettings settings = channel.getChannelSettings();
        JsonObject parent = new JsonObject();
        JsonObject channelObject = settings.writeToJson();
        if (channelObject != null) {
            parent.add("type", (JsonElement)new JsonPrimitive(channel.getType().getID()));
            parent.add("name", (JsonElement)new JsonPrimitive(channel.getChannelName()));
            parent.add("channel", (JsonElement)channelObject);
            JsonArray connectors = new JsonArray();
            Set<ConnectedBlockInfo> connectedBlocks = this.findConnectedBlocks();
            for (ConnectedBlockInfo connectedBlock : connectedBlocks) {
                JsonObject object;
                SidedPos sidedPos = connectedBlock.getPos();
                IConnectorSettings connectorSettings = this.findConnectorSettings(channel, sidedPos);
                if (connectorSettings == null || (object = connectorSettings.writeToJson()) == null) continue;
                JsonObject connectorObject = new JsonObject();
                connectorObject.add("connector", (JsonElement)object);
                connectorObject.add("name", (JsonElement)new JsonPrimitive(connectedBlock.getName()));
                boolean advanced = ConnectorBlock.isAdvancedConnector(this.field_145850_b, sidedPos.getPos().func_177972_a(sidedPos.getSide()));
                connectorObject.add("advanced", (JsonElement)new JsonPrimitive(Boolean.valueOf(advanced)));
                if (!connectedBlock.isAir()) {
                    BlockState state = connectedBlock.getConnectedState();
                    connectorObject.add("block", (JsonElement)new JsonPrimitive(state.func_177230_c().getRegistryName().toString()));
                }
                connectors.add((JsonElement)connectorObject);
            }
            parent.add("connectors", (JsonElement)connectors);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String json = gson.toJson((JsonElement)parent);
            XNetMessages.INSTANCE.sendTo((Object)new PacketJsonToClipboard(json), ((ServerPlayerEntity)player).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        } else {
            XNetMessages.INSTANCE.sendTo((Object)new PacketControllerError("Channel does not support this!"), ((ServerPlayerEntity)player).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    private int calculateMatchingScore(IChannelType type, ConnectedBlockInfo info, String name, ResourceLocation block, @Nonnull Direction side, @Nonnull Direction facingOverride, boolean advanced, boolean advancedNeeded) {
        ResourceLocation infoBlock;
        Direction facing;
        BlockPos blockPos;
        int score = 0;
        String infoName = info.getName();
        if (!name.isEmpty() && Objects.equals(name, infoName)) {
            score += 100;
        }
        if (!type.supportsBlock(this.field_145850_b, blockPos = info.getPos().getPos(), facing = info.getPos().getSide())) {
            score -= 1000;
        }
        if (!KnownUnsidedBlocks.isUnsided(infoBlock = info.getConnectedState().func_177230_c().getRegistryName()) && !facingOverride.equals((Object)facing)) {
            score -= 1000;
        }
        boolean infoAdvanced = ConnectorBlock.isAdvancedConnector(this.field_145850_b, blockPos.func_177972_a(facing));
        if (advanced) {
            score = infoAdvanced ? (score += 50) : (advancedNeeded ? (score -= 1000) : (score -= 40));
        } else if (infoAdvanced) {
            --score;
        }
        if (!info.isAir() && Objects.equals(infoBlock, block)) {
            score += 200;
        }
        if (facing.equals((Object)side)) {
            score += 2;
        }
        return score;
    }

    private void pasteConnector(PlayerEntity player, int channel, SidedPos sidedPos, String json) {
        try {
            JsonParser parser = new JsonParser();
            JsonObject root = parser.parse(json).getAsJsonObject();
            if (!root.has("connector") || !root.has("type")) {
                XNetMessages.INSTANCE.sendTo((Object)new PacketControllerError("Invalid connector json!"), ((ServerPlayerEntity)player).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
                return;
            }
            String typeId = root.get("type").getAsString();
            IChannelType type = XNet.xNetApi.findType(typeId);
            if (type != this.channels[channel].getType()) {
                XNetMessages.INSTANCE.sendTo((Object)new PacketControllerError("Wrong channel type!"), ((ServerPlayerEntity)player).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
                return;
            }
            boolean advanced = root.get("advanced").getAsBoolean();
            JsonObject connectorObject = root.get("connector").getAsJsonObject();
            boolean advancedNeeded = connectorObject.get("advancedneeded").getAsBoolean();
            BlockPos blockPos = sidedPos.getPos();
            Direction facing = sidedPos.getSide();
            Direction side = Direction.func_176739_a((String)connectorObject.get("side").getAsString());
            Direction facingOverride = connectorObject.has("facingoverride") ? Direction.func_176739_a((String)connectorObject.get("facingoverride").getAsString()) : side;
            boolean infoAdvanced = ConnectorBlock.isAdvancedConnector(this.field_145850_b, blockPos.func_177972_a(facing));
            if (advanced && !infoAdvanced && (advancedNeeded || !facingOverride.equals((Object)facing))) {
                XNetMessages.INSTANCE.sendTo((Object)new PacketControllerError("Advanced connector is needed!"), ((ServerPlayerEntity)player).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
                return;
            }
            if (!infoAdvanced) {
                connectorObject.remove("facingoverride");
            }
            ConnectorInfo info = this.createConnector(channel, sidedPos);
            info.getConnectorSettings().readFromJson(connectorObject);
        }
        catch (JsonSyntaxException e) {
            XNetMessages.INSTANCE.sendTo((Object)new PacketControllerError("Error pasting clipboard data!"), ((ServerPlayerEntity)player).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        }
        this.markAsDirty();
    }

    private void pasteChannel(PlayerEntity player, int channel, String json) {
        try {
            ResourceLocation block;
            JsonParser parser = new JsonParser();
            JsonObject root = parser.parse(json).getAsJsonObject();
            if (!(root.has("channel") && root.has("type") && root.has("name"))) {
                XNetMessages.INSTANCE.sendTo((Object)new PacketControllerError("Invalid channel json!"), ((ServerPlayerEntity)player).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
                return;
            }
            String typeId = root.get("type").getAsString();
            IChannelType type = XNet.xNetApi.findType(typeId);
            this.channels[channel] = new ChannelInfo(type);
            this.channels[channel].setChannelName(root.get("name").getAsString());
            this.channels[channel].getChannelSettings().readFromJson(root.get("channel").getAsJsonObject());
            this.channels[channel].setEnabled(false);
            Set<ConnectedBlockInfo> connectedBlocks = this.findConnectedBlocks();
            boolean notEnoughConnectors = false;
            JsonArray connectors = root.get("connectors").getAsJsonArray();
            ArrayList<PossibleConnection> connections = new ArrayList<PossibleConnection>();
            for (JsonElement con : connectors) {
                JsonObject connector = con.getAsJsonObject();
                String name = connector.get("name").getAsString();
                boolean advanced = connector.get("advanced").getAsBoolean();
                block = connector.has("block") ? new ResourceLocation(connector.get("block").getAsString()) : null;
                JsonObject connectorSettings = connector.get("connector").getAsJsonObject();
                Direction side = Direction.func_176739_a((String)connectorSettings.get("side").getAsString());
                Direction facingOverride = connectorSettings.has("facingoverride") ? Direction.func_176739_a((String)connectorSettings.get("facingoverride").getAsString()) : side;
                boolean advancedNeeded = connectorSettings.get("advancedneeded").getAsBoolean();
                List<Pair<ConnectedBlockInfo, Integer>> sortedMatches = connectedBlocks.stream().map(info -> Pair.of((Object)info, (Object)this.calculateMatchingScore(type, (ConnectedBlockInfo)info, name, block, side, facingOverride, advanced, advancedNeeded))).sorted((p1, p2) -> Integer.compare((Integer)p2.getRight(), (Integer)p1.getRight())).collect(Collectors.toList());
                if (!sortedMatches.isEmpty() && (Integer)((Pair)sortedMatches.get(0)).getRight() > -50) {
                    connections.add(new PossibleConnection(connector, sortedMatches));
                    continue;
                }
                notEnoughConnectors = true;
            }
            while (!connections.isEmpty()) {
                connections.sort((p1, p2) -> Integer.compare((Integer)((Pair)((PossibleConnection)p2).sortedMatches.get(0)).getRight(), (Integer)((Pair)((PossibleConnection)p1).sortedMatches.get(0)).getRight()));
                PossibleConnection pair = (PossibleConnection)connections.remove(0);
                JsonObject connector = pair.connector;
                if (pair.sortedMatches.isEmpty()) {
                    notEnoughConnectors = true;
                    break;
                }
                ConnectedBlockInfo info2 = (ConnectedBlockInfo)((Pair)pair.sortedMatches.get(0)).getKey();
                boolean infoAdvanced = ConnectorBlock.isAdvancedConnector(this.field_145850_b, info2.getPos().getPos());
                JsonObject connectorSettings = connector.get("connector").getAsJsonObject();
                if (!infoAdvanced) {
                    connectorSettings.remove("facingoverride");
                }
                block = connector.has("block") ? new ResourceLocation(connector.get("block").getAsString()) : null;
                System.out.println("Pasting " + info2.getName() + " (" + block.toString() + " into " + info2.getConnectedState().func_177230_c().getRegistryName().toString() + ") with score = " + ((Pair)pair.sortedMatches.get(0)).getRight());
                ConnectorInfo connectorInfo = this.createConnector(channel, info2.getPos());
                connectorInfo.getConnectorSettings().readFromJson(connectorSettings);
                for (PossibleConnection connection : connections) {
                    ArrayList<Pair> newMatches = new ArrayList<Pair>();
                    for (Pair match : connection.sortedMatches) {
                        if (match.getLeft() == info2) continue;
                        newMatches.add(match);
                    }
                    connection.sortedMatches = newMatches;
                }
            }
            if (notEnoughConnectors) {
                XNetMessages.INSTANCE.sendTo((Object)new PacketControllerError("Not everything could be pasted!"), ((ServerPlayerEntity)player).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
            }
        }
        catch (JsonSyntaxException e) {
            XNetMessages.INSTANCE.sendTo((Object)new PacketControllerError("Error pasting clipboard data!"), ((ServerPlayerEntity)player).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        }
        this.markAsDirty();
    }

    public void onBlockPlacedBy(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.onBlockPlacedBy(world, pos, state, placer, stack);
        this.findNeighbourConnector(world, pos);
    }

    public void onReplaced(World world, BlockPos pos, BlockState state, BlockState newstate) {
        if (state.func_177230_c() == newstate.func_177230_c()) {
            return;
        }
        XNetBlobData blobData = XNetBlobData.get(this.field_145850_b);
        WorldBlob worldBlob = blobData.getWorldBlob(this.field_145850_b);
        worldBlob.removeCableSegment(pos);
        blobData.save();
    }

    public void checkRedstone(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            this.findNeighbourConnector(world, pos);
        }
    }

    private void findNeighbourConnector(World world, BlockPos pos) {
        if (world.field_72995_K) {
            return;
        }
        XNetBlobData blobData = XNetBlobData.get(world);
        WorldBlob worldBlob = blobData.getWorldBlob(world);
        ColorId oldColor = worldBlob.getColorAt(pos);
        ColorId newColor = null;
        for (Direction facing : OrientationTools.DIRECTION_VALUES) {
            ColorId color;
            if (!(world.func_180495_p(pos.func_177972_a(facing)).func_177230_c() instanceof ConnectorBlock) || (color = worldBlob.getColorAt(pos.func_177972_a(facing))) == null) continue;
            if (color == oldColor) {
                return;
            }
            newColor = color;
        }
        if (newColor != null) {
            if (worldBlob.getBlobAt(pos) != null) {
                worldBlob.removeCableSegment(pos);
            }
            NetworkId networkId = worldBlob.newNetwork();
            worldBlob.createNetworkProvider(pos, newColor, networkId);
            blobData.save();
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof TileEntityController) {
                ((TileEntityController)te).setNetworkId(networkId);
            }
        }
    }

    private static class PossibleConnection {
        private final JsonObject connector;
        private List<Pair<ConnectedBlockInfo, Integer>> sortedMatches;

        public PossibleConnection(JsonObject connector, List<Pair<ConnectedBlockInfo, Integer>> sortedMatches) {
            this.connector = connector;
            this.sortedMatches = sortedMatches;
        }
    }
}

