/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.jei;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import mythicbotany.ModBlocks;
import mythicbotany.ModRecipes;
import mythicbotany.MythicBotany;
import mythicbotany.jei.InfusionCategory;
import mythicbotany.jei.LittleBoxItemRenderer;
import mythicbotany.jei.RuneRitualCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

@JeiPlugin
public class MythicJei
implements IModPlugin {
    private static IJeiRuntime runtime = null;

    @Nonnull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation(MythicBotany.getInstance().modid, "jeiplugin");
    }

    public void registerCategories(@Nonnull IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new InfusionCategory(registration.getJeiHelpers().getGuiHelper()), new RuneRitualCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(@Nonnull IRecipeRegistration registration) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        RecipeManager recipes = Objects.requireNonNull(world).func_199532_z();
        registration.addRecipes((Collection)recipes.func_241447_a_(ModRecipes.INFUSER), InfusionCategory.UID);
        registration.addRecipes((Collection)recipes.func_241447_a_(ModRecipes.RUNE_RITUAL), RuneRitualCategory.UID);
    }

    public void registerRecipeCatalysts(@Nonnull IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack(ModBlocks.manaInfuser), new ResourceLocation[]{InfusionCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack(ModBlocks.masterRuneHolder), new ResourceLocation[]{RuneRitualCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack(ModBlocks.runeHolder), new ResourceLocation[]{RuneRitualCategory.UID});
    }

    public void onRuntimeAvailable(@Nonnull IJeiRuntime jeiRuntime) {
        runtime = jeiRuntime;
        LittleBoxItemRenderer.setParent((IIngredientRenderer<ItemStack>)runtime.getIngredientManager().getIngredientRenderer((Object)new ItemStack((IItemProvider)Items.field_221585_m)));
    }

    public static void runtime(Consumer<IJeiRuntime> action) {
        if (runtime != null) {
            action.accept(runtime);
        }
    }

    public static <T> Optional<T> runtime(Function<IJeiRuntime, T> action) {
        if (runtime != null) {
            return Optional.of(action.apply(runtime));
        }
        return Optional.empty();
    }
}

