/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.functionalflora.base;

import com.mojang.blaze3d.matrix.MatrixStack;
import io.github.noeppi_noeppi.libx.LibX;
import io.github.noeppi_noeppi.libx.mod.ModX;
import io.github.noeppi_noeppi.libx.mod.registration.BlockBase;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mythicbotany.functionalflora.base.BlockFunctionalFlower;
import mythicbotany.functionalflora.base.FunctionalFlowerBase;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.botania.api.BotaniaAPIClient;
import vazkii.botania.api.wand.IWandHUD;
import vazkii.botania.api.wand.IWandable;
import vazkii.botania.common.core.handler.ConfigHandler;

public class BlockFloatingFunctionalFlower<T extends FunctionalFlowerBase>
extends BlockBase
implements IWandHUD,
IWandable {
    private static final VoxelShape SHAPE = BlockFloatingFunctionalFlower.func_208617_a((double)1.6, (double)1.6, (double)1.6, (double)14.4, (double)14.4, (double)14.4);
    private final BlockFunctionalFlower<T> nonFloatingBlock;

    public BlockFloatingFunctionalFlower(ModX mod, BlockFunctionalFlower<T> nonFloatingBlock) {
        super(mod, AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k).func_235828_a_((state, world, pos) -> false).func_200946_b().func_200947_a(SoundType.field_185850_c));
        this.nonFloatingBlock = nonFloatingBlock;
    }

    public BlockFunctionalFlower<T> getNonFloatingBlock() {
        return this.nonFloatingBlock;
    }

    @Nonnull
    public VoxelShape func_220053_a(@Nonnull BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos, @Nonnull ISelectionContext ctx) {
        return SHAPE;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public T createTileEntity(BlockState state, IBlockReader world) {
        FunctionalFlowerBase te = (FunctionalFlowerBase)this.nonFloatingBlock.getTileType().func_200968_a();
        if (te != null) {
            te.setFloating(true);
        }
        return (T)((Object)te);
    }

    public T getTile(World world, BlockPos pos) {
        return this.nonFloatingBlock.getTile(world, pos);
    }

    public TileEntityType<T> getTileType() {
        return this.nonFloatingBlock.getTileType();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderHUD(MatrixStack matrixStack, Minecraft minecraft, World world, BlockPos pos) {
        T te = this.getTile(world, pos);
        String name = I18n.func_135052_a((String)this.getNonFloatingBlock().func_149739_a(), (Object[])new Object[0]);
        BotaniaAPIClient.instance().drawComplexManaHUD(matrixStack, ((FunctionalFlowerBase)((Object)te)).color, ((FunctionalFlowerBase)((Object)te)).getCurrentMana(), ((FunctionalFlowerBase)((Object)te)).maxMana, name, new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(this.getNonFloatingBlock().isGenerating ? BlockFunctionalFlower.SPREADER_ID : BlockFunctionalFlower.POOL_ID)), ((FunctionalFlowerBase)((Object)te)).isValidBinding());
    }

    public boolean onUsedByWand(PlayerEntity player, ItemStack stack, World world, BlockPos pos, Direction side) {
        if (world.field_72995_K) {
            LibX.getNetwork().requestTE(world, pos);
        }
        return true;
    }

    public boolean func_149740_M(@Nonnull BlockState state) {
        return true;
    }

    public int func_180641_l(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos) {
        T te = this.getTile(world, pos);
        if (((FunctionalFlowerBase)((Object)te)).getCurrentMana() > 0) {
            return 1 + (int)((double)((FunctionalFlowerBase)((Object)te)).getCurrentMana() / (double)((FunctionalFlowerBase)((Object)te)).maxMana * 14.0);
        }
        return 0;
    }

    public boolean func_200123_i(BlockState state, @Nonnull IBlockReader reader, @Nonnull BlockPos pos) {
        return state.func_204520_s().func_206888_e();
    }

    public void func_190948_a(@Nonnull ItemStack stack, @Nullable IBlockReader world, @Nonnull List<ITextComponent> list, @Nonnull ITooltipFlag flag) {
        super.func_190948_a(stack, world, list, flag);
        if (this.getNonFloatingBlock().isGenerating) {
            list.add((ITextComponent)new TranslationTextComponent("botania.flowerType.generating").func_240701_a_(new TextFormatting[]{TextFormatting.BLUE, TextFormatting.ITALIC}));
        } else {
            list.add((ITextComponent)new TranslationTextComponent("botania.flowerType.functional").func_240701_a_(new TextFormatting[]{TextFormatting.BLUE, TextFormatting.ITALIC}));
        }
        list.add((ITextComponent)new TranslationTextComponent("block." + this.mod.modid + "." + this.getNonFloatingBlock().getRegistryName().func_110623_a() + ".description").func_240701_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.ITALIC}));
    }

    public boolean func_220074_n(@Nonnull BlockState state) {
        return true;
    }

    @Nonnull
    public BlockRenderType func_149645_b(@Nonnull BlockState state) {
        return (Boolean)ConfigHandler.CLIENT.staticFloaters.get() != false ? BlockRenderType.MODEL : BlockRenderType.ENTITYBLOCK_ANIMATED;
    }
}

