/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.data.recipes.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mythicbotany.ModRecipes;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import vazkii.botania.common.core.helper.ItemNBTHelper;

public class InfuserRecipeBuilder {
    private final ItemStack result;
    private final List<Ingredient> ingredients = new ArrayList<Ingredient>();
    private String group;
    private int manaCost = -1;
    private int fromColor = 0xFFFFFF;
    private int toColor = 0xFFFFFF;

    private InfuserRecipeBuilder(ItemStack result) {
        this.result = result;
    }

    public static InfuserRecipeBuilder infuserRecipe(IItemProvider result) {
        return new InfuserRecipeBuilder(new ItemStack(result)).setGroup("infuser");
    }

    public static InfuserRecipeBuilder infuserRecipe(ItemStack result) {
        return new InfuserRecipeBuilder(result).setGroup("infuser");
    }

    public InfuserRecipeBuilder addIngredient(ITag<Item> tag) {
        return this.addIngredient(Ingredient.func_199805_a(tag));
    }

    public InfuserRecipeBuilder addIngredient(IItemProvider item) {
        return this.addIngredient(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item}), 1);
    }

    public InfuserRecipeBuilder addIngredient(IItemProvider item, int quantity) {
        for (int i = 0; i < quantity; ++i) {
            this.addIngredient(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item}));
        }
        return this;
    }

    public InfuserRecipeBuilder addIngredient(Ingredient ingredient) {
        return this.addIngredient(ingredient, 1);
    }

    public InfuserRecipeBuilder addIngredient(Ingredient ingredient, int quantity) {
        for (int i = 0; i < quantity; ++i) {
            this.ingredients.add(ingredient);
        }
        return this;
    }

    public InfuserRecipeBuilder setManaCost(int mana) {
        this.manaCost = mana;
        return this;
    }

    public InfuserRecipeBuilder setColors(int fromColor, int toColor) {
        this.fromColor = fromColor;
        this.toColor = toColor;
        return this;
    }

    public InfuserRecipeBuilder setGroup(String group) {
        this.group = group;
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumer) {
        this.build(consumer, this.result.func_77973_b().getRegistryName());
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, ResourceLocation id) {
        this.validate(id);
        consumerIn.accept(new FinishedRecipe(new ResourceLocation(id.func_110624_b(), "mythicbotany_infusion/" + id.func_110623_a()), this.result, this.manaCost, this.group == null ? "" : this.group, this.fromColor, this.toColor, this.ingredients));
    }

    private void validate(ResourceLocation id) {
        if (this.manaCost < 0) {
            throw new IllegalStateException("No mana cost set for " + id);
        }
    }

    private static class FinishedRecipe
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final ItemStack output;
        private final int mana;
        private final String group;
        private final int fromColor;
        private final int toColor;
        private final List<Ingredient> inputs;

        private FinishedRecipe(ResourceLocation id, ItemStack output, int mana, String group, int fromColor, int toColor, List<Ingredient> inputs) {
            this.id = id;
            this.output = output;
            this.mana = mana;
            this.group = group;
            this.fromColor = fromColor;
            this.toColor = toColor;
            this.inputs = inputs;
        }

        public void func_218610_a(@Nonnull JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            json.add("output", (JsonElement)ItemNBTHelper.serializeStack((ItemStack)this.output));
            JsonArray ingredients = new JsonArray();
            for (Ingredient ingredient : this.inputs) {
                ingredients.add(ingredient.func_200304_c());
            }
            json.addProperty("mana", (Number)this.mana);
            json.add("ingredients", (JsonElement)ingredients);
            json.addProperty("fromColor", (Number)this.fromColor);
            json.addProperty("toColor", (Number)this.toColor);
        }

        @Nonnull
        public ResourceLocation func_200442_b() {
            return this.id;
        }

        @Nonnull
        public IRecipeSerializer<?> func_218609_c() {
            return ModRecipes.INFUSER_SERIALIZER;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

