/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.data.custom;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import mythicbotany.MythicBotany;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;

public class FloatingFlowerModelBuilder
extends BlockModelBuilder {
    private ResourceLocation flower = null;

    public FloatingFlowerModelBuilder(ResourceLocation outputLocation, ExistingFileHelper existingFileHelper) {
        super(outputLocation, existingFileHelper);
    }

    public static FloatingFlowerModelBuilder create(BlockModelProvider provider, String path) {
        Preconditions.checkNotNull((Object)path, (Object)"Path must not be null");
        ResourceLocation outputLoc = new ResourceLocation(MythicBotany.getInstance().modid, "block/" + path);
        return (FloatingFlowerModelBuilder)provider.generatedModels.computeIfAbsent(outputLoc, rl -> new FloatingFlowerModelBuilder((ResourceLocation)rl, provider.existingFileHelper));
    }

    public FloatingFlowerModelBuilder flower(ResourceLocation flower) {
        this.flower = flower.func_110623_a().startsWith("block/") ? flower : new ResourceLocation(flower.func_110624_b(), "block/" + flower.func_110623_a());
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = super.toJson();
        json.addProperty("loader", "botania:floating_flower");
        if (this.flower != null) {
            JsonObject flowerObj = new JsonObject();
            flowerObj.addProperty("parent", this.flower.toString());
            json.add("flower", (JsonElement)flowerObj);
        }
        return json;
    }
}

