/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.alfheim.teleporter;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import mythicbotany.MythicBotany;
import mythicbotany.config.MythicConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.IngameMenuScreen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.TickEvent;
import vazkii.botania.client.core.handler.MiscellaneousIcons;

public class AlfheimPortalHandler {
    public static int clientInPortalTime;
    private static final Set<ServerPlayerEntity> inPortal;
    private static final Map<ServerPlayerEntity, Integer> timesInPortal;

    public static void endTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Iterator<ServerPlayerEntity> itr = timesInPortal.keySet().iterator();
            while (itr.hasNext()) {
                ServerPlayerEntity player = itr.next();
                if (inPortal.contains(player)) continue;
                MythicBotany.getNetwork().updatePortalTime(player, 0);
                itr.remove();
            }
            timesInPortal.keySet().removeIf(p -> !inPortal.contains(p));
            inPortal.clear();
        }
    }

    public static boolean setInPortal(World world, PlayerEntity playerEntity) {
        if (!world.field_72995_K && playerEntity instanceof ServerPlayerEntity && !playerEntity.func_242280_ah()) {
            int timeInPortal;
            ServerPlayerEntity player = (ServerPlayerEntity)playerEntity;
            inPortal.add(player);
            if (!timesInPortal.containsKey(player)) {
                timesInPortal.put(player, 1);
                timeInPortal = 1;
            } else {
                timeInPortal = timesInPortal.get(player) + 1;
                timesInPortal.put(player, timeInPortal);
            }
            MythicBotany.getNetwork().updatePortalTime(player, timeInPortal);
            return timeInPortal >= Math.max(player.func_82145_z(), 80);
        }
        return false;
    }

    public static boolean shouldCheck(World world) {
        if (!MythicConfig.enableAlfheim) {
            return false;
        }
        if (world instanceof ServerWorld) {
            return !timesInPortal.isEmpty() || ((ServerWorld)world).func_73046_m().func_71259_af() % 4 == 3;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderGameOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL && clientInPortalTime > 0 && !(Minecraft.func_71410_x().field_71462_r instanceof IngameMenuScreen)) {
            MatrixStack matrixStack = event.getMatrixStack();
            matrixStack.func_227860_a_();
            int w = Minecraft.func_71410_x().func_228018_at_().func_198107_o();
            int h = Minecraft.func_71410_x().func_228018_at_().func_198087_p();
            float scale = (float)Math.max(w, h) / 48.0f;
            matrixStack.func_227861_a_(w < h ? (double)((h - w) / -2) : 0.0, w > h ? (double)((w - h) / -2) : 0.0, 0.0);
            matrixStack.func_227862_a_(scale, scale, scale);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)MathHelper.func_76131_a((float)(((float)clientInPortalTime + Minecraft.func_71410_x().func_184121_ak()) / 80.0f), (float)0.05f, (float)0.8f));
            RenderSystem.pushTextureAttributes();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(MiscellaneousIcons.INSTANCE.alfPortalTex.func_229310_a_());
            AbstractGui.func_238470_a_((MatrixStack)matrixStack, (int)0, (int)0, (int)0, (int)48, (int)48, (TextureAtlasSprite)MiscellaneousIcons.INSTANCE.alfPortalTex.func_229314_c_());
            RenderSystem.popAttributes();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            matrixStack.func_227865_b_();
        }
    }

    static {
        inPortal = new HashSet<ServerPlayerEntity>();
        timesInPortal = new HashMap<ServerPlayerEntity, Integer>();
    }
}

